/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.MessageHandler;
import com.sforce.ws.SessionRenewer;
import com.sforce.ws.tools.VersionInfo;
import com.sforce.ws.transport.JdkHttpTransport;
import com.sforce.ws.transport.MessageCaptureHandler;
import com.sforce.ws.transport.Transport;
import com.sforce.ws.transport.TransportFactory;
import com.sforce.ws.util.Base64;
import com.sforce.ws.util.Verbose;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class ConnectorConfig {
    private MessageCaptureHandler captureHtmlHandler;
    private int readTimeout;
    private int connectionTimeout;
    private boolean traceMessage;
    private boolean compression = true;
    private boolean prettyPrintXml;
    private boolean manualLogin;
    private boolean useChunkedPost;
    private String username;
    private String password;
    private String sessionId;
    private String authEndpoint;
    private String serviceEndpoint;
    private String restEndpoint;
    private String traceFile;
    private PrintStream traceStream;
    private String proxyUsername;
    private String proxyPassword;
    private HashMap<String, String> headers;
    private Proxy proxy = null;
    private ArrayList<MessageHandler> handlers = new ArrayList();
    private int maxRequestSize;
    private int maxResponseSize;
    private boolean validateSchema = true;
    private Class transport = JdkHttpTransport.class;
    private SessionRenewer sessionRenewer;
    private String ntlmDomain;
    private TransportFactory transportFactory;
    private SSLContext sslContext;
    public static final ConnectorConfig DEFAULT = new ConnectorConfig();

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public Class getTransport() {
        return this.transport;
    }

    public TransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    public void setTransportFactory(TransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }

    public void setTransport(Class transport) {
        this.transport = transport;
    }

    public void setNtlmDomain(String domain) {
        this.ntlmDomain = domain;
        if (System.getProperty("http.auth.ntlm.domain") == null) {
            System.setProperty("http.auth.ntlm.domain", domain);
        } else {
            Verbose.log("http.auth.ntlm.domain already set");
        }
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public void setProxy(String host, int port) {
        InetSocketAddress addr = new InetSocketAddress(host, port);
        this.proxy = new Proxy(Proxy.Type.HTTP, addr);
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy == null ? Proxy.NO_PROXY : this.proxy;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getRequestHeader(String key) {
        String ret = null;
        if (this.headers != null) {
            ret = this.headers.get(key);
        }
        return ret;
    }

    public void setRequestHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(key, value);
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean isPrettyPrintXml() {
        return this.prettyPrintXml;
    }

    public void setPrettyPrintXml(boolean prettyPrintXml) {
        this.prettyPrintXml = prettyPrintXml;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String serviceEndpoint) {
        if (serviceEndpoint == null || serviceEndpoint.equals("")) {
            throw new IllegalArgumentException("illegal service endpoint " + serviceEndpoint);
        }
        this.serviceEndpoint = serviceEndpoint;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(boolean compress) {
        this.compression = compress;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isTraceMessage() {
        return this.traceMessage;
    }

    public void setTraceMessage(boolean traceMessage) {
        this.traceMessage = traceMessage;
    }

    public String getTraceFile() {
        return this.traceFile;
    }

    public void setTraceFile(String traceFile) throws FileNotFoundException {
        this.traceFile = traceFile;
        File file = new File(traceFile);
        if (file.exists()) {
            Verbose.log("Log file already exists, appending to " + file);
        }
        this.traceStream = new PrintStream(new FileOutputStream(file, true), true);
    }

    public PrintStream getTraceStream() {
        return this.traceStream == null ? System.out : this.traceStream;
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public void setAuthEndpoint(String authEndpoint) {
        if (authEndpoint == null || authEndpoint.equals("")) {
            throw new IllegalArgumentException("Illegal auth endpoint " + authEndpoint);
        }
        this.authEndpoint = authEndpoint;
    }

    public void setManualLogin(boolean manualLogin) {
        this.manualLogin = manualLogin;
    }

    public boolean isManualLogin() {
        return this.manualLogin;
    }

    public void setUseChunkedPost(boolean chunk) {
        this.useChunkedPost = chunk;
    }

    public boolean useChunkedPost() {
        return this.useChunkedPost;
    }

    public void verifyPartnerEndpoint() throws ConnectionException {
        this.verifyEndpoint("/services/Soap/u/");
    }

    public void verifyEnterpriseEndpoint() throws ConnectionException {
        this.verifyEndpoint("/services/Soap/c/");
    }

    public void verifyToolingEndpoint() throws ConnectionException {
        this.verifyEndpoint("/services/Soap/T/");
    }

    public Iterator<MessageHandler> getMessagerHandlers() {
        return this.handlers.iterator();
    }

    public boolean hasMessageHandlers() {
        return this.handlers.size() != 0;
    }

    public void addMessageHandler(MessageHandler handler) {
        this.handlers.add(handler);
    }

    public void clearMessageHandlers() {
        this.handlers.clear();
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    public void setMaxResponseSize(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    private void verifyEndpoint(String contains) throws ConnectionException {
        if (this.authEndpoint != null && !this.authEndpoint.contains(contains)) {
            throw new ConnectionException("Check authEndpoint. It must contain '" + contains + "'. authEndpoint specified " + this.authEndpoint);
        }
        if (this.serviceEndpoint != null && !this.serviceEndpoint.contains(contains)) {
            throw new ConnectionException("Check serviceEndpoint. It must contain '" + contains + "'. serviceEndpoint specified " + this.serviceEndpoint);
        }
    }

    public String getRestEndpoint() {
        return this.restEndpoint;
    }

    public void setRestEndpoint(String restEndpoint) {
        this.restEndpoint = restEndpoint;
    }

    public SessionRenewer getSessionRenewer() {
        return this.sessionRenewer;
    }

    public void setSessionRenewer(SessionRenewer sessionRenewer) {
        this.sessionRenewer = sessionRenewer;
    }

    public Transport createTransport() throws ConnectionException {
        if (this.transportFactory != null) {
            return this.transportFactory.createTransport();
        }
        try {
            Transport t = (Transport)this.getTransport().newInstance();
            t.setConfig(this);
            return t;
        }
        catch (InstantiationException e) {
            throw new ConnectionException("Failed to create new Transport " + this.getTransport());
        }
        catch (IllegalAccessException e) {
            throw new ConnectionException("Failed to create new Transport " + this.getTransport());
        }
    }

    public HttpURLConnection createConnection(URL url, HashMap<String, String> httpHeaders) throws IOException {
        return this.createConnection(url, httpHeaders, true);
    }

    public void teeInputStream(byte[] bytes) {
        new TeeInputStream(bytes);
    }

    public OutputStream teeOutputStream(OutputStream os) {
        return new TeeOutputStream(os);
    }

    public HttpURLConnection createConnection(URL url, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        if (this.isTraceMessage()) {
            this.getTraceStream().println("WSC: Creating a new connection to " + url + " Proxy = " + this.getProxy() + " username " + this.getProxyUsername());
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.getProxy());
        connection.addRequestProperty("User-Agent", VersionInfo.info());
        if (this.getHeaders() != null) {
            for (Map.Entry<String, String> ent : this.getHeaders().entrySet()) {
                connection.setRequestProperty(ent.getKey(), ent.getValue());
            }
        }
        if (enableCompression && this.isCompression()) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            connection.addRequestProperty("Accept-Encoding", "gzip");
        }
        if (this.getProxyUsername() != null) {
            String token = this.getProxyUsername() + ":" + this.getProxyPassword();
            String auth = "Basic " + new String(Base64.encode(token.getBytes()));
            connection.addRequestProperty("Proxy-Authorization", auth);
            connection.addRequestProperty("Https-Proxy-Authorization", auth);
        }
        if (httpHeaders != null) {
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (this.getReadTimeout() != 0) {
            connection.setReadTimeout(this.getReadTimeout());
        }
        if (this.getConnectionTimeout() != 0) {
            connection.setConnectTimeout(this.getConnectionTimeout());
        }
        return connection;
    }

    public void setCaptureHtmlExceptionResponse(boolean captureHtmlResponse) {
        if (captureHtmlResponse) {
            this.captureHtmlHandler = new MessageCaptureHandler();
            this.addMessageHandler(this.captureHtmlHandler);
        }
    }

    public MessageCaptureHandler getCaptureHtmlHandler() {
        return this.captureHtmlHandler;
    }

    public class TeeOutputStream
    extends OutputStream {
        private OutputStream out;

        private TeeOutputStream(OutputStream out) {
            ConnectorConfig.this.getTraceStream().println("------------ Request start   ----------");
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            ConnectorConfig.this.getTraceStream().write((char)b);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            ConnectorConfig.this.getTraceStream().write(b);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ConnectorConfig.this.getTraceStream().write(b, off, len);
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            ConnectorConfig.this.getTraceStream().println();
            ConnectorConfig.this.getTraceStream().flush();
            this.out.close();
            ConnectorConfig.this.getTraceStream().println("------------ Request end   ----------");
        }
    }

    public class TeeInputStream {
        private int level = 0;

        private TeeInputStream(byte[] bytes) {
            ConnectorConfig.this.getTraceStream().println("------------ Response start ----------");
            if (ConnectorConfig.this.isPrettyPrintXml()) {
                this.prettyPrint(bytes);
            } else {
                ConnectorConfig.this.getTraceStream().print(new String(bytes));
            }
            ConnectorConfig.this.getTraceStream().println();
            ConnectorConfig.this.getTraceStream().println("------------ Response end   ----------");
        }

        private void prettyPrint(byte[] bytes) {
            boolean newLine = true;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == 60) {
                    if (i + 1 < bytes.length) {
                        this.level = bytes[i + 1] == 47 ? --this.level : ++this.level;
                    }
                    for (int j = 0; newLine && j < this.level; ++j) {
                        ConnectorConfig.this.getTraceStream().print("  ");
                    }
                }
                ConnectorConfig.this.getTraceStream().write(bytes[i]);
                if (bytes[i] != 62) continue;
                if (i + 1 < bytes.length && bytes[i + 1] == 60) {
                    ConnectorConfig.this.getTraceStream().println();
                    newLine = true;
                    continue;
                }
                newLine = false;
            }
        }
    }
}

