/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.sync;

import android.util.Log;
import com.feedhenry.sdk.sync.FHSyncDataRecord;
import com.feedhenry.sdk.sync.FHSyncPendingRecord;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.json.fh.JSONArray;
import org.json.fh.JSONObject;

public class FHTestUtils {
    private static final String TAG = FHTestUtils.class.getSimpleName();

    public static JSONObject generateJSON() throws Exception {
        JSONObject ret = new JSONObject();
        ret.put("testStringKey", (Object)FHTestUtils.genRandomString(10));
        ret.put("testNumberKey", new Random().nextInt());
        JSONArray arr = new JSONArray();
        arr.put((Object)FHTestUtils.genRandomString(10));
        arr.put((Object)FHTestUtils.genRandomString(10));
        ret.put("testArrayKey", (Object)arr);
        JSONObject dict = new JSONObject();
        dict.put(FHTestUtils.genRandomString(10), (Object)FHTestUtils.genRandomString(10));
        dict.put(FHTestUtils.genRandomString(10), (Object)FHTestUtils.genRandomString(10));
        ret.put("testDictKey", (Object)dict);
        return ret;
    }

    private static String genRandomString(int pLength) {
        Random r = new Random();
        String letter = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pLength; ++i) {
            sb.append(letter.charAt(r.nextInt(1000000) % letter.length()));
        }
        return sb.toString();
    }

    public static FHSyncDataRecord generateRadomDataRecord() throws Exception {
        JSONObject json = FHTestUtils.generateJSON();
        return new FHSyncDataRecord(json);
    }

    public static FHSyncPendingRecord generateRandomPendingRecord() throws Exception {
        FHSyncPendingRecord pending = new FHSyncPendingRecord();
        pending.setInFlightDate(new Date());
        pending.setInFlight(true);
        pending.setCrashed(false);
        pending.setAction("create");
        pending.setTimestamp(new Date().getTime());
        pending.setUid(FHTestUtils.genRandomString(10));
        pending.setPreData(FHTestUtils.generateRadomDataRecord());
        pending.setPostData(FHTestUtils.generateRadomDataRecord());
        return pending;
    }

    public static <T> T instanciatePrivateInnerClass(String className, Object outerInstance, Object ... params) {
        try {
            Class<T> innerClass = FHTestUtils.findClass(className, outerInstance.getClass().getDeclaredClasses());
            Constructor<T> innerClassConstructor = FHTestUtils.findConstructor(innerClass, outerInstance.getClass(), params);
            innerClassConstructor.setAccessible(true);
            params = FHTestUtils.prependTo(outerInstance, params);
            return innerClassConstructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            Log.e((String)TAG, (String)("Error creating inner class " + className), (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private static <T> Class<T> findClass(String className, Class<?>[] declaredClasses) {
        for (Class<?> klass : declaredClasses) {
            if (!klass.getSimpleName().matches(className)) continue;
            return klass;
        }
        throw new IllegalArgumentException(String.format("Class name %s not found ", className));
    }

    private static <T> Constructor<T> findConstructor(Class<T> innerClass, Class<?> outerClassType, Object[] params) {
        try {
            Constructor<?>[] constructors;
            Class[] paramsKlasses = new Class[params.length + 1];
            paramsKlasses[0] = outerClassType;
            for (int i = 0; i < params.length; ++i) {
                paramsKlasses[i + 1] = params[i].getClass();
            }
            for (Constructor<?> constructor : constructors = innerClass.getDeclaredConstructors()) {
                Class<?>[] constructorParams = constructor.getParameterTypes();
                if (constructorParams.length != paramsKlasses.length) continue;
                boolean found = true;
                for (int i = 0; i < params.length; ++i) {
                    if (constructorParams[i].isAssignableFrom(paramsKlasses[i])) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return constructor;
            }
            Log.e((String)TAG, (String)"No Constructor.");
            throw new IllegalArgumentException("Could not find a constructor for " + params.toString());
        }
        catch (SecurityException ex) {
            Log.e((String)TAG, (String)"Error finding constructor.", (Throwable)ex);
            throw new IllegalArgumentException(ex);
        }
    }

    private static <T> T[] prependTo(T outerInstance, T[] params) {
        ArrayList<T> paramsList = new ArrayList<T>(params.length + 1);
        paramsList.add(outerInstance);
        for (T param : params) {
            paramsList.add(param);
        }
        return paramsList.toArray(params);
    }

    public static void injectInto(Object source, Object value) {
        FHTestUtils.injectInto(source, source.getClass(), value);
    }

    private static void injectInto(Object source, Class<? extends Object> sourceClass, Object value) {
        Field[] fields;
        for (Field field : fields = sourceClass.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(value.getClass())) continue;
            try {
                field.setAccessible(true);
                field.set(source, value);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        if (sourceClass.getSuperclass() != Object.class) {
            FHTestUtils.injectInto(source, sourceClass.getSuperclass(), value);
        }
    }

    static Object getPrivateField(Object client, String fieldName) {
        try {
            Class<?> klass = client.getClass();
            Field field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(client);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            Log.e((String)FHTestUtils.class.getName(), (String)ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }
}

