/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.api;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Looper;
import android.provider.Settings;
import android.test.AndroidTestCase;
import com.feedhenry.sdk.FH;
import com.feedhenry.sdk.FHAct;
import com.feedhenry.sdk.FHActCallback;
import com.feedhenry.sdk.FHResponse;
import com.feedhenry.sdk.api.FHActRequest;
import com.feedhenry.sdk.api.FHCloudRequest;
import com.feedhenry.sdk.utils.DataManager;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import cz.msebera.android.httpclient.Header;
import cz.msebera.android.httpclient.message.BasicHeader;
import org.json.fh.JSONException;
import org.json.fh.JSONObject;

public class FHSDKTest
extends AndroidTestCase {
    private JSONObject resJson = null;
    private MockWebServer mockWebServer = null;

    public void setUp() throws Exception {
        super.setUp();
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.play(9000);
        FH.init((Context)this.getContext(), null);
        FH.setLogLevel((int)1);
        DataManager.getInstance().save("sessionToken", "testsessiontoken");
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.shutdownServer();
        FH.stop();
    }

    public void testFHActASync() throws Exception {
        this.actTest(true);
    }

    public void testFhActSync() throws Exception {
        this.actTest(false);
    }

    private void actTest(boolean async) throws Exception {
        String cloudHost = FH.getCloudHost();
        System.out.println("cloud host is " + cloudHost);
        FHSDKTest.assertEquals((String)"http://localhost:9000", (String)cloudHost);
        MockResponse actSuccessResponse = new MockResponse();
        actSuccessResponse.addHeader("Content-Type", (Object)"application/json");
        actSuccessResponse.setBody("{'status':'ok', 'type': 'act'}");
        this.mockWebServer.enqueue(actSuccessResponse);
        FHActRequest actCall = FH.buildActRequest((String)"test", (JSONObject)new JSONObject());
        FHActCallback callback = new FHActCallback(){

            public void success(FHResponse pResponse) {
                FHSDKTest.this.resJson = pResponse.getJson();
            }

            public void fail(FHResponse pResponse) {
                FHSDKTest.this.resJson = null;
            }
        };
        if (async) {
            this.runAsyncRequest((FHAct)actCall, callback);
        } else {
            actCall.execute(callback);
        }
        FHSDKTest.assertEquals((String)this.resJson.getString("type"), (String)"act");
        RecordedRequest request = this.mockWebServer.takeRequest();
        FHSDKTest.assertEquals((String)"POST", (String)request.getMethod().toUpperCase());
        FHSDKTest.assertEquals((String)"/cloud/test", (String)request.getPath());
        String requestBody = new String(request.getBody().readUtf8());
        JSONObject requestJson = new JSONObject(requestBody);
        FHSDKTest.assertTrue((boolean)requestJson.has("__fh"));
        JSONObject fhParams = requestJson.getJSONObject("__fh");
        String deviceId = fhParams.optString("cuid", null);
        FHSDKTest.assertEquals((String)this.getDeviceId(), (String)deviceId);
    }

    public void testCloudGetSync() throws Exception {
        this.enqueueCloudResponse();
        JSONObject p = new JSONObject();
        p.put("test", (Object)"true");
        this.makeCloudRequest("GET", null, p, false);
        this.verifyCloudRequest("/v1/cloud/test?test=true", "GET", null, null);
    }

    public void testCloudGetAsync() throws Exception {
        this.enqueueCloudResponse();
        JSONObject p = new JSONObject();
        p.put("test", (Object)"true");
        this.makeCloudRequest("GET", null, p, true);
        this.verifyCloudRequest("/v1/cloud/test?test=true", "GET", null, null);
    }

    public void testCloudDeleteSync() throws Exception {
        this.enqueueCloudResponse();
        JSONObject p = new JSONObject();
        p.put("test", (Object)"true");
        this.makeCloudRequest("DELETE", null, p, false);
        this.verifyCloudRequest("/v1/cloud/test?test=true", "DELETE", null, null);
    }

    public void testCloudDeleteAsync() throws Exception {
        this.enqueueCloudResponse();
        JSONObject p = new JSONObject();
        p.put("test", (Object)"true");
        this.makeCloudRequest("DELETE", null, p, true);
        this.verifyCloudRequest("/v1/cloud/test?test=true", "DELETE", null, null);
    }

    public void testCloudPostSync() throws Exception {
        this.enqueueCloudResponse();
        JSONObject p = new JSONObject();
        p.put("test", (Object)"true");
        Header[] headers = new Header[]{new BasicHeader("testHeader", "testValue")};
        this.makeCloudRequest("POST", headers, p, false);
        this.verifyCloudRequest("/v1/cloud/test", "POST", headers, p);
    }

    public void testCloudPostASync() throws Exception {
        this.enqueueCloudResponse();
        JSONObject p = new JSONObject();
        p.put("test", (Object)"true");
        Header[] headers = new Header[]{new BasicHeader("testHeader", "testValue")};
        this.makeCloudRequest("POST", headers, p, true);
        this.verifyCloudRequest("/v1/cloud/test", "POST", headers, p);
    }

    public void testCloudPutSync() throws Exception {
        this.enqueueCloudResponse();
        JSONObject p = new JSONObject();
        p.put("test", (Object)"true");
        Header[] headers = new Header[]{new BasicHeader("testHeader", "testValue")};
        this.makeCloudRequest("PUT", headers, p, false);
        this.verifyCloudRequest("/v1/cloud/test", "PUT", headers, p);
    }

    public void testCloudPutASync() throws Exception {
        this.enqueueCloudResponse();
        JSONObject p = new JSONObject();
        p.put("test", (Object)"true");
        Header[] headers = new Header[]{new BasicHeader("testHeader", "testValue")};
        this.makeCloudRequest("PUT", headers, p, true);
        this.verifyCloudRequest("/v1/cloud/test", "PUT", headers, p);
    }

    private void shutdownServer() throws Exception {
        this.mockWebServer.shutdown();
        Thread.sleep(100L);
    }

    private void enqueueCloudResponse() throws Exception {
        MockResponse cloudSuccessResponse = new MockResponse();
        cloudSuccessResponse.addHeader("Content-Type", (Object)"application/json");
        cloudSuccessResponse.setBody("{'status':'ok', 'type': 'cloud'}");
        this.mockWebServer.enqueue(cloudSuccessResponse);
    }

    private void makeCloudRequest(String method, Header[] headers, JSONObject params, boolean pAsync) throws JSONException, Exception {
        FHCloudRequest cloudRequest = FH.buildCloudRequest((String)"/v1/cloud/test", (String)method, (Header[])headers, (JSONObject)params);
        FHActCallback callback = new FHActCallback(){

            public void success(FHResponse pResponse) {
                FHSDKTest.this.resJson = pResponse.getJson();
            }

            public void fail(FHResponse pResponse) {
                FHSDKTest.this.resJson = null;
            }
        };
        if (pAsync) {
            this.runAsyncRequest((FHAct)cloudRequest, callback);
        } else {
            cloudRequest.execute(callback);
        }
        FHSDKTest.assertNotNull((Object)this.resJson);
        FHSDKTest.assertEquals((String)"cloud", (String)this.resJson.getString("type"));
    }

    private void verifyCloudRequest(String path, String method, Header[] headers, JSONObject params) throws Exception {
        RecordedRequest request = this.mockWebServer.takeRequest();
        FHSDKTest.assertEquals((String)method.toLowerCase(), (String)request.getMethod().toLowerCase());
        String cuidHeader = request.getHeader("x-fh-cuid");
        FHSDKTest.assertEquals((String)this.getDeviceId(), (String)cuidHeader);
        if (null != headers) {
            for (int i = 0; i < headers.length; ++i) {
                String requestHeaderValue = request.getHeader(headers[i].getName());
                FHSDKTest.assertEquals((String)requestHeaderValue, (String)headers[i].getValue());
            }
        }
        if (null != params) {
            String requestBody = new String(request.getBody().readUtf8());
            FHSDKTest.assertEquals((String)requestBody.toString(), (String)params.toString());
        }
    }

    private String getDeviceId() {
        return Settings.Secure.getString((ContentResolver)this.getContext().getContentResolver(), (String)"android_id");
    }

    private void runAsyncRequest(final FHAct pRequest, final FHActCallback pCallback) throws Exception {
        Thread testThread = new Thread(){

            @Override
            public void run() {
                try {
                    Looper.prepare();
                    pRequest.executeAsync(new FHActCallback(){

                        public void success(FHResponse pResponse) {
                            System.out.println("Got response " + pResponse.getRawResponse());
                            pCallback.success(pResponse);
                            Looper.myLooper().quit();
                        }

                        public void fail(FHResponse pResponse) {
                            System.out.println("Got error response : " + pResponse.getRawResponse());
                            pCallback.fail(pResponse);
                            Looper.myLooper().quit();
                        }
                    });
                    Looper.loop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        testThread.start();
        testThread.join();
    }
}

