/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.api;

import android.content.Context;
import android.test.AndroidTestCase;
import com.feedhenry.sdk.FH;
import com.feedhenry.sdk.FHResponse;
import com.feedhenry.sdk.api.FHAuthSession;
import com.feedhenry.sdk.utils.DataManager;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;

public class FHAuthSessionTest
extends AndroidTestCase {
    private MockWebServer mockWebServer = null;
    private boolean valid = false;
    private static final String TEST_TOKEN = "testSessionToken";

    public void setUp() throws Exception {
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.play(9000);
        FH.init((Context)this.getContext(), null);
        DataManager.getInstance().save("sessionToken", TEST_TOKEN);
    }

    public void tearDown() throws Exception {
        DataManager.getInstance().remove("sessionToken");
        this.mockWebServer.shutdown();
        Thread.sleep(100L);
    }

    public void testExists() throws Exception {
        FHAuthSessionTest.assertTrue((boolean)FHAuthSession.exists());
    }

    public void testVerify() throws Exception {
        MockResponse cloudSuccessResponse = new MockResponse();
        cloudSuccessResponse.addHeader("Content-Type", (Object)"application/json");
        cloudSuccessResponse.setBody("{'status':'ok', 'isValid': true}");
        this.mockWebServer.enqueue(cloudSuccessResponse);
        FHAuthSession.verify((FHAuthSession.Callback)new FHAuthSession.Callback(){

            public void handleSuccess(boolean isValid) {
                FHAuthSessionTest.this.valid = isValid;
            }

            public void handleError(FHResponse pRes) {
            }
        }, (boolean)true);
        FHAuthSessionTest.assertTrue((boolean)this.valid);
        FHAuthSessionTest.assertEquals((String)TEST_TOKEN, (String)FHAuthSession.getToken());
    }

    public void testClear() throws Exception {
        MockResponse cloudSuccessResponse = new MockResponse();
        cloudSuccessResponse.addHeader("Content-Type", (Object)"application/json");
        cloudSuccessResponse.setBody("{'status':'ok'}");
        this.mockWebServer.enqueue(cloudSuccessResponse);
        FHAuthSession.clear((boolean)true);
        FHAuthSessionTest.assertFalse((boolean)FHAuthSession.exists());
    }
}

