/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.faunadb.client.query.Expr;
import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Decoder;
import com.faunadb.client.types.Deserializer;
import com.faunadb.client.types.Encoder;
import com.faunadb.client.types.Field;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Types;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@JsonDeserialize(using=Deserializer.ValueDeserializer.class)
public abstract class Value
extends Expr {
    private static Supplier<Value> NULL_SUPPLIER = () -> NullV.NULL;

    private Value() {
    }

    public final <T> Result<T> to(Codec<T> codec) {
        return codec.decode(this);
    }

    public final <T> Result<T> to(Class<T> clazz) {
        return Decoder.decode(this, Types.of(clazz));
    }

    public static <T> Result<Value> from(T t) {
        return Encoder.encode(t);
    }

    public final <T> Result<Map<String, T>> asMapOf(Class<T> clazz) {
        return Decoder.decode(this, Types.hashMapOf(clazz));
    }

    public final <T> Map<String, T> toMap(Class<T> clazz) {
        return this.asMapOf(clazz).get();
    }

    public final <T> Result<Collection<T>> asCollectionOf(Class<T> clazz) {
        return Decoder.decode(this, Types.arrayListOf(clazz));
    }

    public final <T> Collection<T> collect(Class<T> clazz) {
        return this.asCollectionOf(clazz).get();
    }

    public final <T> T get(Field<T> field) {
        return field.get(this).get();
    }

    public final <T> T get(Class<T> clazz) {
        return this.to(clazz).get();
    }

    public final <T> Optional<T> getOptional(Field<T> field) {
        return field.get(this).getOptional();
    }

    @JsonIgnore
    public Optional<Value> getOptional() {
        return Optional.of(this);
    }

    public final Value orNull() {
        return this.getOptional().orElse(null);
    }

    public final <T> List<T> collect(Field<T> field) {
        return Field.root().collect(field).get(this).get();
    }

    public final Value at(String ... stringArray) {
        return Field.at(stringArray).get(this).getOrElse(NULL_SUPPLIER);
    }

    public final Value at(int ... nArray) {
        return Field.at(nArray).get(this).getOrElse(NULL_SUPPLIER);
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    public static final class QueryV
    extends Value {
        private Map<String, Object> lambda;

        private QueryV(@JsonProperty(value="@query") Map<String, Object> map) {
            this.lambda = map;
        }

        @Override
        @JsonProperty(value="@query")
        protected Map<String, Object> toJson() {
            return this.lambda;
        }

        public boolean equals(Object object) {
            return object instanceof QueryV && this.lambda.equals(((QueryV)object).lambda);
        }

        public int hashCode() {
            return this.lambda.hashCode();
        }
    }

    public static final class BytesV
    extends ScalarValue<byte[]> {
        public BytesV(byte[] byArray) {
            super(byArray);
        }

        @JsonCreator
        public BytesV(@JsonProperty(value="@bytes") String string) {
            super(Base64.getUrlDecoder().decode(string));
        }

        @Override
        @JsonProperty(value="@bytes")
        protected Object toJson() {
            return Base64.getUrlEncoder().encodeToString((byte[])this.value);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof BytesV && Arrays.equals((byte[])this.value, (byte[])((BytesV)object).value);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode((byte[])this.value);
        }

        @Override
        public String toString() {
            return IntStream.range(0, ((byte[])this.value).length).mapToObj(n -> String.format("0x%02x", ((byte[])this.value)[n])).collect(Collectors.joining(" ", "[", "]"));
        }
    }

    public static final class Native {
        public static final RefV ACCESS_PROVIDERS = new RefV("access_providers", null, null);
        public static final RefV COLLECTIONS = new RefV("collections", null, null);
        public static final RefV INDEXES = new RefV("indexes", null, null);
        public static final RefV DATABASES = new RefV("databases", null, null);
        public static final RefV KEYS = new RefV("keys", null, null);
        public static final RefV FUNCTIONS = new RefV("functions", null, null);
        public static final RefV ROLES = new RefV("roles", null, null);

        private Native() {
        }

        public static RefV fromName(String string) {
            switch (string) {
                case "collections": {
                    return COLLECTIONS;
                }
                case "indexes": {
                    return INDEXES;
                }
                case "databases": {
                    return DATABASES;
                }
                case "keys": {
                    return KEYS;
                }
                case "functions": {
                    return FUNCTIONS;
                }
                case "roles": {
                    return ROLES;
                }
            }
            return new RefV(string, null, null);
        }
    }

    public static final class RefV
    extends ScalarValue<RefID> {
        public RefV(String string, RefV refV, RefV refV2) {
            super(new RefID(string, refV, refV2));
        }

        public RefV(String string, RefV refV) {
            this(string, refV, null);
        }

        @JsonIgnore
        public String getId() {
            return ((RefID)this.value).id;
        }

        @JsonIgnore
        @Deprecated
        public Optional<RefV> getClazz() {
            return this.getCollection();
        }

        @JsonIgnore
        public Optional<RefV> getCollection() {
            return Optional.ofNullable(((RefID)this.value).collection);
        }

        @JsonIgnore
        public Optional<RefV> getDatabase() {
            return Optional.ofNullable(((RefID)this.value).database);
        }

        @Override
        @JsonProperty(value="@ref")
        protected Object toJson() {
            return this.value;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof RefV)) {
                return false;
            }
            RefV refV = (RefV)object;
            return Objects.equals(this.value, refV.value);
        }

        @Override
        public int hashCode() {
            return ((RefID)this.value).hashCode();
        }

        @Override
        public String toString() {
            String string = ((RefID)this.value).collection != null ? String.format(", collection = %s", ((RefID)this.value).collection) : "";
            String string2 = ((RefID)this.value).database != null ? String.format(", database = %s", ((RefID)this.value).database) : "";
            return String.format("ref(id = \"%s\"%s%s)", ((RefID)this.value).id, string, string2);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public static class RefID {
        @JsonProperty(value="id")
        private final String id;
        @JsonProperty(value="collection")
        private final RefV collection;
        @JsonProperty(value="database")
        private final RefV database;

        private RefID(String string, RefV refV, RefV refV2) {
            this.id = string;
            this.collection = refV;
            this.database = refV2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RefID)) {
                return false;
            }
            RefID refID = (RefID)object;
            return Objects.equals(this.id, refID.id) && Objects.equals(this.collection, refID.collection) && Objects.equals(this.database, refID.database);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.collection, this.database);
        }
    }

    public static final class SetRefV
    extends ScalarValue<Map<String, Value>> {
        public SetRefV(@JsonProperty(value="@set") Map<String, Value> map) {
            super(map);
        }

        public Map<String, Value> parameters() {
            return (Map)this.value;
        }

        @Override
        @JsonProperty(value="@set")
        protected Map<String, Value> toJson() {
            return (Map)this.value;
        }

        @Override
        public String toString() {
            String string = ((Map)this.value).entrySet().stream().map(entry -> String.join((CharSequence)": ", Arrays.asList((String)entry.getKey(), String.valueOf(entry.getValue())))).collect(Collectors.joining(", ", "{", "}"));
            return String.format("{@set = %s}", string);
        }
    }

    public static final class DateV
    extends ScalarValue<LocalDate> {
        public DateV(LocalDate localDate) {
            super(localDate);
        }

        @JsonCreator
        private DateV(@JsonProperty(value="@date") String string) {
            super(LocalDate.parse(string));
        }

        @Override
        @JsonProperty(value="@date")
        protected String toJson() {
            return ((LocalDate)this.value).toString();
        }
    }

    public static final class TimeV
    extends ScalarValue<Instant> {
        public TimeV(Instant instant) {
            super(instant);
        }

        @JsonCreator
        private TimeV(@JsonProperty(value="@ts") String string) {
            this(Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(string)));
        }

        Instant truncated() {
            return (Instant)this.value;
        }

        @Override
        @JsonProperty(value="@ts")
        protected String toJson() {
            return ((Instant)this.value).toString();
        }
    }

    public static final class NullV
    extends Value {
        public static final NullV NULL = new NullV();

        private NullV() {
        }

        @Override
        @JsonIgnore
        public Optional<Value> getOptional() {
            return Optional.empty();
        }

        @JsonValue
        protected NullNode toJson() {
            return NullNode.getInstance();
        }

        public boolean equals(Object object) {
            return object instanceof NullV;
        }

        public int hashCode() {
            return -1;
        }

        @Override
        public String toString() {
            return "null";
        }
    }

    public static final class StringV
    extends ScalarValue<String> {
        public StringV(String string) {
            super(string);
        }

        @Override
        @JsonValue
        protected String toJson() {
            return (String)this.value;
        }

        @Override
        public String toString() {
            return String.format("\"%s\"", this.value);
        }
    }

    public static final class LongV
    extends ScalarValue<Long> {
        public LongV(long l) {
            super(l);
        }

        @Override
        @JsonValue
        protected Long toJson() {
            return (Long)this.value;
        }
    }

    public static final class DoubleV
    extends ScalarValue<Double> {
        public DoubleV(double d) {
            super(d);
        }

        @Override
        @JsonValue
        protected Double toJson() {
            return (Double)this.value;
        }
    }

    public static final class BooleanV
    extends ScalarValue<Boolean> {
        public static final BooleanV TRUE = new BooleanV(true);
        public static final BooleanV FALSE = new BooleanV(false);

        public static BooleanV valueOf(boolean bl) {
            return bl ? TRUE : FALSE;
        }

        private BooleanV(Boolean bl) {
            super(bl);
        }

        @Override
        @JsonValue
        protected Boolean toJson() {
            return (Boolean)this.value;
        }
    }

    @JsonDeserialize(using=Deserializer.ArrayDeserializer.class)
    public static final class ArrayV
    extends Value {
        final List<Value> values;

        public ArrayV(List<? extends Value> list) {
            this.values = Collections.unmodifiableList(list);
        }

        @Override
        @JsonValue
        protected List<Value> toJson() {
            return this.values;
        }

        public boolean equals(Object object) {
            return object instanceof ArrayV && this.values.equals(((ArrayV)object).values);
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        @Override
        public String toString() {
            Iterable iterable = this.values.stream().map(String::valueOf).collect(Collectors.toList());
            return String.format("[%s]", String.join((CharSequence)", ", iterable));
        }
    }

    @JsonDeserialize(using=Deserializer.ObjectDeserializer.class)
    public static final class ObjectV
    extends Value {
        final Map<String, Value> values;

        public ObjectV(Map<String, ? extends Value> map) {
            this.values = Collections.unmodifiableMap(map);
        }

        @Override
        @JsonValue
        protected Map<String, Map<String, Value>> toJson() {
            return Collections.singletonMap("object", this.values);
        }

        public boolean equals(Object object) {
            return object instanceof ObjectV && this.values.equals(((ObjectV)object).values);
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        @Override
        public String toString() {
            return this.values.entrySet().stream().map(entry -> String.join((CharSequence)": ", Arrays.asList((String)entry.getKey(), String.valueOf(entry.getValue())))).collect(Collectors.joining(", ", "{", "}"));
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    static abstract class ScalarValue<T>
    extends Value {
        @JsonIgnore
        final T value;

        ScalarValue(T t) {
            this.value = Objects.requireNonNull(t);
        }

        public boolean equals(Object object) {
            return object instanceof ScalarValue && this.value.equals(((ScalarValue)object).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

