/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

final class Path {
    private final List<Segment> segments;

    static Path empty() {
        return new Path(Collections.emptyList());
    }

    static Path from(String ... stringArray) {
        ArrayList<ObjectKey> arrayList = new ArrayList<ObjectKey>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(new ObjectKey(string));
        }
        return new Path(Collections.unmodifiableList(arrayList));
    }

    static Path from(int ... nArray) {
        ArrayList<ArrayIndex> arrayList = new ArrayList<ArrayIndex>(nArray.length);
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray2[i];
            arrayList.add(new ArrayIndex(n2));
        }
        return new Path(Collections.unmodifiableList(arrayList));
    }

    private Path(List<Segment> list) {
        this.segments = list;
    }

    Path subPath(Path path) {
        ArrayList<Segment> arrayList = new ArrayList<Segment>(this.segments.size() + path.segments.size());
        arrayList.addAll(this.segments);
        arrayList.addAll(path.segments);
        return new Path(Collections.unmodifiableList(arrayList));
    }

    Result<Value> get(Value value) {
        Result<Value> result = Result.success(value);
        for (Segment segment : this.segments) {
            result = segment.get(result.get());
            if (!result.isFailure()) continue;
            return Result.fail(String.format("Can not find path \"%s\". %s", this, result));
        }
        return result;
    }

    public boolean equals(Object object) {
        return object instanceof Path && this.segments.equals(((Path)object).segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return this.segments.stream().map(Segment::toString).collect(Collectors.joining("/"));
    }

    private static final class ArrayIndex
    extends Segment<Integer> {
        private ArrayIndex(Integer n) {
            super(n);
        }

        @Override
        public Result<Value> get(Value value) {
            return value.to(Codec.ARRAY).flatMap(list -> {
                try {
                    return Result.success((Value)list.get((Integer)this.segment));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return Result.fail(String.format("Array index \"%s\" not found", this.segment));
                }
            });
        }
    }

    private static final class ObjectKey
    extends Segment<String> {
        private ObjectKey(String string) {
            super(string);
        }

        @Override
        public Result<Value> get(Value value) {
            return value.to(Codec.OBJECT).flatMap(map -> {
                Value value = (Value)map.get(this.segment);
                if (value != null) {
                    return Result.success(value);
                }
                return Result.fail(String.format("Object key \"%s\" not found", this.segment));
            });
        }
    }

    private static abstract class Segment<T> {
        final T segment;

        private Segment(T t) {
            this.segment = t;
        }

        abstract Result<Value> get(Value var1);

        public boolean equals(Object object) {
            return object instanceof Segment && this.segment.equals(((Segment)object).segment);
        }

        public int hashCode() {
            return this.segment.hashCode();
        }

        public String toString() {
            return this.segment.toString();
        }
    }
}

