/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.types.Value;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MetricsResponse {
    private final Map<Metrics, String> metricsMap;
    private final Value value;

    private MetricsResponse(Value value, Map<Metrics, String> map) {
        this.value = value;
        this.metricsMap = map;
    }

    public static MetricsResponse of(Value value, Map<Metrics, String> map) {
        return new MetricsResponse(value, map);
    }

    public Value getValue() {
        return this.value;
    }

    public Optional<String> getMetric(Metrics metrics) {
        return Optional.ofNullable(this.metricsMap.get((Object)metrics));
    }

    public static enum Metrics {
        BYTE_READ_OPS("x-byte-read-ops"),
        BYTE_WRITE_OPS("x-byte-write-ops"),
        COMPUTE_OPS("x-compute-ops"),
        FAUNADB_BUILD("x-faunadb-build"),
        QUERY_BYTES_IN("x-query-bytes-in"),
        QUERY_BYTES_OUT("x-query-bytes-out"),
        QUERY_TIME("x-query-time"),
        READ_OPS("x-read-ops"),
        STORAGE_BYTES_READ("x-storage-bytes-read"),
        STORAGE_BYTES_WRITE("x-storage-bytes-write"),
        TXN_RETRIES("x-txn-retries"),
        TXN_TIME("x-txn-time"),
        WRITE_OPS("x-write-ops");

        private final String metric;

        private Metrics(String string2) {
            this.metric = string2;
        }

        public String getMetric() {
            return this.metric;
        }

        public static List<Metrics> vals() {
            return Arrays.asList(Metrics.values());
        }
    }
}

