/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Decoder;
import com.faunadb.client.types.Encoder;
import com.faunadb.client.types.Path;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Value;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class Field<T> {
    private final Path path;
    private final Codec<T> codec;
    private final Function<Value, Result<T>> codecFn = new Function<Value, Result<T>>(){

        @Override
        public Result<T> apply(Value value) {
            return Field.this.codec.decode(value);
        }
    };

    public static Field<Value> at(String ... stringArray) {
        return new Field<Value>(Path.from(stringArray), Codec.VALUE);
    }

    public static Field<Value> at(int ... nArray) {
        return new Field<Value>(Path.from(nArray), Codec.VALUE);
    }

    public static <T> Field<T> as(Codec<T> codec) {
        return new Field<T>(Path.empty(), codec);
    }

    public static <T> Field<T> as(Class<T> clazz) {
        return Field.root().to(clazz);
    }

    public static <A> Field<List<A>> asListOf(Field<A> field) {
        return new Field<List<A>>(Path.empty(), new CollectionCodec<A>(Path.empty(), field));
    }

    public static <A> Field<Map<String, A>> asMapOf(Field<A> field) {
        return new Field<Map<String, A>>(Path.empty(), new MapCodec<A>(Path.empty(), field));
    }

    static Field<Value> root() {
        return new Field<Value>(Path.empty(), Codec.VALUE);
    }

    private Field(Path path, Codec<T> codec) {
        this.path = path;
        this.codec = codec;
    }

    public <A> Field<A> at(Field<A> field) {
        return new Field<T>(this.path.subPath(field.path), field.codec);
    }

    public <A> Field<A> to(Codec<A> codec) {
        return new Field<A>(this.path, codec);
    }

    public <A> Field<A> to(final Class<A> clazz) {
        return new Field<T>(this.path, new Codec<A>(){

            @Override
            public Result<A> decode(Value value) {
                return Decoder.decode(value, clazz);
            }

            @Override
            public Result<Value> encode(A a) {
                return Encoder.encode(a);
            }
        });
    }

    public <A> Field<List<A>> collect(Field<A> field) {
        return new Field<List<A>>(this.path, new CollectionCodec<A>(this.path, field));
    }

    Result<T> get(Value value) {
        return this.path.get(value).flatMap(this.codecFn);
    }

    public boolean equals(Object object) {
        return object instanceof Field && this.path.equals(((Field)object).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path.toString();
    }

    private static final class MapCodec<A>
    implements Codec<Map<String, A>> {
        private final Path path;
        private final Field<A> field;
        private final Function<Map<String, Value>, Result<Map<String, A>>> toMap = new Function<Map<String, Value>, Result<Map<String, A>>>(){

            @Override
            public Result<Map<String, A>> apply(Map<String, Value> map) {
                LinkedHashMap linkedHashMap = new LinkedHashMap();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Map.Entry<String, Value> entry : map.entrySet()) {
                    Result result = field.get(entry.getValue());
                    if (result.isSuccess()) {
                        linkedHashMap.put(entry.getKey(), result.get());
                        continue;
                    }
                    Path path = path.subPath(Path.from(entry.getKey())).subPath(field.path);
                    arrayList.add(String.format("\"%s\" %s", path, result));
                }
                if (!arrayList.isEmpty()) {
                    return Result.fail(String.format("Failed to collect values: %s", String.join((CharSequence)", ", arrayList)));
                }
                return Result.success(linkedHashMap);
            }
        };

        public MapCodec(Path path, Field<A> field) {
            this.path = path;
            this.field = field;
        }

        @Override
        public Result<Map<String, A>> decode(Value value) {
            return value.to(OBJECT).flatMap(this.toMap);
        }

        @Override
        public Result<Value> encode(Map<String, A> map) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static final class CollectionCodec<A>
    implements Codec<List<A>> {
        private final Path path;
        private final Field<A> field;
        private final Function<List<Value>, Result<List<A>>> toList = new Function<List<Value>, Result<List<A>>>(){

            @Override
            public Result<List<A>> apply(List<Value> list) {
                ArrayList arrayList = new ArrayList();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 0; i < list.size(); ++i) {
                    Result result = field.get(list.get(i));
                    if (result.isSuccess()) {
                        arrayList.add(result.get());
                        continue;
                    }
                    Path path = path.subPath(Path.from(i)).subPath(field.path);
                    arrayList2.add(String.format("\"%s\" %s", path, result));
                }
                if (!arrayList2.isEmpty()) {
                    return Result.fail(String.format("Failed to collect values: %s", String.join((CharSequence)", ", arrayList2)));
                }
                return Result.success(arrayList);
            }
        };

        public CollectionCodec(Path path, Field<A> field) {
            this.path = path;
            this.field = field;
        }

        @Override
        public Result<List<A>> decode(Value value) {
            return value.to(ARRAY).flatMap(this.toList);
        }

        @Override
        public Result<Value> encode(List<A> list) {
            throw new IllegalArgumentException("not implemented");
        }
    }
}

