/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.errors.FaunaException;
import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Constructors;
import com.faunadb.client.types.Encoder;
import com.faunadb.client.types.Properties;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Value;
import java.time.Instant;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

final class Codecs {
    private static final Map<Class<?>, Codec<?>> CODECS = new HashMap();
    private static final ConcurrentHashMap<Class<?>, EncoderEntryCache> ENCODERS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Function<Value, Object>> DECODERS = new ConcurrentHashMap();

    private Codecs() {
    }

    public static Codec<Object> getDecoder(Class<?> clazz) {
        Codec<Object> codec = CODECS.get(clazz);
        if (codec != null) {
            return codec;
        }
        Function<Value, Object> function = DECODERS.get(clazz);
        if (function == null) {
            function = Constructors.createDecoder(clazz);
            DECODERS.put(clazz, function);
        }
        return new ObjectDecoder(function);
    }

    public static Codec<Object> getEncoder(Encoder encoder, Class<?> clazz) {
        Codec<Object> codec = CODECS.get(clazz);
        if (codec != null) {
            return codec;
        }
        return new ObjectEncoder(encoder, ENCODERS.computeIfAbsent(clazz, Codecs::createEncoder));
    }

    private static EncoderEntryCache createEncoder(Class<?> clazz) {
        Properties.Property[] propertyArray = Properties.getReadProperties(clazz);
        return (encoder, object) -> {
            HashMap<String, Value> hashMap = new HashMap<String, Value>();
            for (Properties.Property property : propertyArray) {
                try {
                    hashMap.put(property.getName(), encoder.encodeImpl(property.get(object)));
                }
                catch (Exception exception) {
                    throw new FaunaException(String.format("Could not encode field \"%s\". Reason: %s", property.getName(), exception.getMessage()));
                }
            }
            return new Value.ObjectV(hashMap);
        };
    }

    static {
        CODECS.put(String.class, Codec.STRING);
        CODECS.put(Boolean.class, Codec.BOOLEAN);
        CODECS.put(Boolean.TYPE, Codec.BOOLEAN);
        CODECS.put(Long.class, Codec.LONG);
        CODECS.put(Long.TYPE, Codec.LONG);
        CODECS.put(Integer.class, Codec.INTEGER);
        CODECS.put(Integer.TYPE, Codec.INTEGER);
        CODECS.put(Short.class, Codec.SHORT);
        CODECS.put(Short.TYPE, Codec.SHORT);
        CODECS.put(Byte.class, Codec.BYTE);
        CODECS.put(Byte.TYPE, Codec.BYTE);
        CODECS.put(Character.class, Codec.CHAR);
        CODECS.put(Character.TYPE, Codec.CHAR);
        CODECS.put(Float.class, Codec.FLOAT);
        CODECS.put(Float.TYPE, Codec.FLOAT);
        CODECS.put(Double.class, Codec.DOUBLE);
        CODECS.put(Double.TYPE, Codec.DOUBLE);
        CODECS.put(LocalDate.class, Codec.DATE);
        CODECS.put(Instant.class, Codec.TIME);
    }

    private static class ObjectEncoder
    implements Codec<Object> {
        private final Encoder encoder;
        private final EncoderEntryCache encoderEntryCache;

        ObjectEncoder(Encoder encoder, EncoderEntryCache encoderEntryCache) {
            this.encoder = encoder;
            this.encoderEntryCache = encoderEntryCache;
        }

        @Override
        public Result<Object> decode(Value value) {
            throw new FaunaException("Operation not permitted: calling decode() in an encoding only codec.");
        }

        @Override
        public Result<Value> encode(Object object) {
            return Result.success(this.encoderEntryCache.encode(this.encoder, object));
        }
    }

    private static class ObjectDecoder
    implements Codec<Object> {
        private final Function<Value, Object> decoder;

        ObjectDecoder(Function<Value, Object> function) {
            this.decoder = function;
        }

        @Override
        public Result<Object> decode(Value value) {
            return Result.success(this.decoder.apply(value));
        }

        @Override
        public Result<Value> encode(Object object) {
            throw new FaunaException("Operation not permitted: calling encode() in a decoding only codec.");
        }
    }

    static interface EncoderEntryCache {
        public Value encode(Encoder var1, Object var2);
    }
}

