/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.query;

import com.faunadb.client.query.Expr;
import com.faunadb.client.query.Fn;
import com.faunadb.client.query.Pagination;
import com.faunadb.client.types.Encoder;
import com.faunadb.client.types.Value;
import com.faunadb.client.util.SymbolGenerator;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

public final class Language {
    private Language() {
    }

    private static Expr varargs(List<? extends Expr> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        return Language.Arr(list);
    }

    public static Expr Ref(String string) {
        return Fn.apply("@ref", Language.Value(string));
    }

    public static Expr Ref(Expr expr, Expr expr2) {
        return Fn.apply("ref", expr, "id", expr2);
    }

    public static Expr Ref(Expr expr, String string) {
        return Language.Ref(expr, Language.Value(string));
    }

    @Deprecated
    public static Expr Classes() {
        return Language.Classes(Language.Null());
    }

    public static Expr Collections() {
        return Language.Collections(Language.Null());
    }

    @Deprecated
    public static Expr Classes(Expr expr) {
        return Fn.apply("classes", expr);
    }

    public static Expr Collections(Expr expr) {
        return Fn.apply("collections", expr);
    }

    public static Expr Databases() {
        return Language.Databases(Language.Null());
    }

    public static Expr Databases(Expr expr) {
        return Fn.apply("databases", expr);
    }

    public static Expr Indexes() {
        return Language.Indexes(Language.Null());
    }

    public static Expr Indexes(Expr expr) {
        return Fn.apply("indexes", expr);
    }

    public static Expr Functions() {
        return Language.Functions(Language.Null());
    }

    public static Expr Functions(Expr expr) {
        return Fn.apply("functions", expr);
    }

    public static Expr Keys() {
        return Language.Keys(Language.Null());
    }

    public static Expr Keys(Expr expr) {
        return Fn.apply("keys", expr);
    }

    public static Expr Tokens() {
        return Language.Tokens(Language.Null());
    }

    public static Expr Tokens(Expr expr) {
        return Fn.apply("tokens", expr);
    }

    public static Expr Credentials() {
        return Language.Credentials(Language.Null());
    }

    public static Expr Credentials(Expr expr) {
        return Fn.apply("credentials", expr);
    }

    public static Expr Roles() {
        return Language.Roles(Language.Null());
    }

    public static Expr Roles(Expr expr) {
        return Fn.apply("roles", expr);
    }

    public static Expr Documents(Expr expr) {
        return Fn.apply("documents", expr);
    }

    public static Expr Value(Object object) {
        return Encoder.encode(object).get();
    }

    public static Expr Value(String string) {
        return new Value.StringV(string);
    }

    public static Expr Value(long l) {
        return new Value.LongV(l);
    }

    public static Expr Value(double d) {
        return new Value.DoubleV(d);
    }

    public static Expr Value(boolean bl) {
        return Value.BooleanV.valueOf(bl);
    }

    public static Expr Value(Instant instant) {
        return new Value.TimeV(instant);
    }

    public static Expr Value(LocalDate localDate) {
        return new Value.DateV(localDate);
    }

    public static Expr Value(byte[] byArray) {
        return new Value.BytesV(byArray);
    }

    public static Expr Null() {
        return Value.NullV.NULL;
    }

    public static Expr Obj(Map<String, ? extends Expr> map) {
        return Fn.apply("object", Fn.apply(map));
    }

    public static Expr Obj() {
        return Language.Obj(Collections.emptyMap());
    }

    public static Expr Obj(String string, Expr expr) {
        return Language.Obj(Collections.singletonMap(string, expr));
    }

    public static Expr Obj(String string, Expr expr, String string2, Expr expr2) {
        LinkedHashMap<String, Expr> linkedHashMap = new LinkedHashMap<String, Expr>();
        linkedHashMap.put(string, expr);
        linkedHashMap.put(string2, expr2);
        return Language.Obj(Collections.unmodifiableMap(linkedHashMap));
    }

    public static Expr Obj(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3) {
        LinkedHashMap<String, Expr> linkedHashMap = new LinkedHashMap<String, Expr>();
        linkedHashMap.put(string, expr);
        linkedHashMap.put(string2, expr2);
        linkedHashMap.put(string3, expr3);
        return Language.Obj(Collections.unmodifiableMap(linkedHashMap));
    }

    public static Expr Obj(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4) {
        LinkedHashMap<String, Expr> linkedHashMap = new LinkedHashMap<String, Expr>();
        linkedHashMap.put(string, expr);
        linkedHashMap.put(string2, expr2);
        linkedHashMap.put(string3, expr3);
        linkedHashMap.put(string4, expr4);
        return Language.Obj(Collections.unmodifiableMap(linkedHashMap));
    }

    public static Expr Obj(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4, String string5, Expr expr5) {
        LinkedHashMap<String, Expr> linkedHashMap = new LinkedHashMap<String, Expr>();
        linkedHashMap.put(string, expr);
        linkedHashMap.put(string2, expr2);
        linkedHashMap.put(string3, expr3);
        linkedHashMap.put(string4, expr4);
        linkedHashMap.put(string5, expr5);
        return Language.Obj(Collections.unmodifiableMap(linkedHashMap));
    }

    public static Expr Arr(List<? extends Expr> list) {
        return Fn.apply(list);
    }

    public static Expr Arr(Expr ... exprArray) {
        return Language.Arr(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Abort(String string) {
        return Language.Abort(Language.Value(string));
    }

    public static Expr Abort(Expr expr) {
        return Fn.apply("abort", expr);
    }

    public static Expr Call(Expr expr, List<? extends Expr> list) {
        return Fn.apply("call", expr, "arguments", Language.varargs(list));
    }

    public static Expr Call(Expr expr, Expr ... exprArray) {
        return Language.Call(expr, Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Query(Expr expr) {
        return Fn.apply("query", expr);
    }

    public static Expr At(Expr expr, Expr expr2) {
        return Fn.apply("at", expr, "expr", expr2);
    }

    public static Expr At(Instant instant, Expr expr) {
        return Language.At(new Value.TimeV(instant), expr);
    }

    @Deprecated
    public static LetBinding Let(Map<String, ? extends Expr> map) {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        for (Map.Entry<String, ? extends Expr> entry : map.entrySet()) {
            arrayList.add(Fn.apply(entry.getKey(), entry.getValue()));
        }
        return new LetBinding(arrayList);
    }

    public static LetBinding Let(String string, Expr expr) {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        arrayList.add(Fn.apply(string, expr));
        return new LetBinding(arrayList);
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2) {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        arrayList.add(Fn.apply(string, expr));
        arrayList.add(Fn.apply(string2, expr2));
        return new LetBinding(arrayList);
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3) {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        arrayList.add(Fn.apply(string, expr));
        arrayList.add(Fn.apply(string2, expr2));
        arrayList.add(Fn.apply(string3, expr3));
        return new LetBinding(arrayList);
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4) {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        arrayList.add(Fn.apply(string, expr));
        arrayList.add(Fn.apply(string2, expr2));
        arrayList.add(Fn.apply(string3, expr3));
        arrayList.add(Fn.apply(string4, expr4));
        return new LetBinding(arrayList);
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4, String string5, Expr expr5) {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        arrayList.add(Fn.apply(string, expr));
        arrayList.add(Fn.apply(string2, expr2));
        arrayList.add(Fn.apply(string3, expr3));
        arrayList.add(Fn.apply(string4, expr4));
        arrayList.add(Fn.apply(string5, expr5));
        return new LetBinding(arrayList);
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4, String string5, Expr expr5, String string6, Expr expr6) {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        arrayList.add(Fn.apply(string, expr));
        arrayList.add(Fn.apply(string2, expr2));
        arrayList.add(Fn.apply(string3, expr3));
        arrayList.add(Fn.apply(string4, expr4));
        arrayList.add(Fn.apply(string5, expr5));
        arrayList.add(Fn.apply(string6, expr6));
        return new LetBinding(arrayList);
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4, String string5, Expr expr5, String string6, Expr expr6, String string7, Expr expr7) {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        arrayList.add(Fn.apply(string, expr));
        arrayList.add(Fn.apply(string2, expr2));
        arrayList.add(Fn.apply(string3, expr3));
        arrayList.add(Fn.apply(string4, expr4));
        arrayList.add(Fn.apply(string5, expr5));
        arrayList.add(Fn.apply(string6, expr6));
        arrayList.add(Fn.apply(string7, expr7));
        return new LetBinding(arrayList);
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4, String string5, Expr expr5, String string6, Expr expr6, String string7, Expr expr7, String string8, Expr expr8) {
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        arrayList.add(Fn.apply(string, expr));
        arrayList.add(Fn.apply(string2, expr2));
        arrayList.add(Fn.apply(string3, expr3));
        arrayList.add(Fn.apply(string4, expr4));
        arrayList.add(Fn.apply(string5, expr5));
        arrayList.add(Fn.apply(string6, expr6));
        arrayList.add(Fn.apply(string7, expr7));
        arrayList.add(Fn.apply(string8, expr8));
        return new LetBinding(arrayList);
    }

    public static Expr Var(String string) {
        return Fn.apply("var", Language.Value(string));
    }

    public static Expr If(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("if", expr, "then", expr2, "else", expr3);
    }

    public static Expr Do(List<? extends Expr> list) {
        return Fn.apply("do", Fn.apply(list));
    }

    public static Expr Do(Expr ... exprArray) {
        return Language.Do(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Lambda(Expr expr, Expr expr2) {
        return Fn.apply("lambda", expr, "expr", expr2);
    }

    public static Expr Lambda(String string, Expr expr) {
        return Language.Lambda(new Value.StringV(string), expr);
    }

    public static Expr Map(Expr expr, Expr expr2) {
        return Fn.apply("map", expr2, "collection", expr);
    }

    public static Expr Map(Expr expr, UnaryOperator<Expr> unaryOperator) {
        String string = SymbolGenerator.genSym("map");
        return Language.Map(expr, Language.Lambda(string, (Expr)unaryOperator.apply(Language.Var(string))));
    }

    public static Expr Foreach(Expr expr, Expr expr2) {
        return Fn.apply("foreach", expr2, "collection", expr);
    }

    public static Expr Foreach(Expr expr, UnaryOperator<Expr> unaryOperator) {
        String string = SymbolGenerator.genSym("foreach");
        return Language.Foreach(expr, Language.Lambda(string, (Expr)unaryOperator.apply(Language.Var(string))));
    }

    public static Expr Filter(Expr expr, Expr expr2) {
        return Fn.apply("filter", expr2, "collection", expr);
    }

    public static Expr Filter(Expr expr, UnaryOperator<Expr> unaryOperator) {
        String string = SymbolGenerator.genSym("filter");
        return Language.Filter(expr, Language.Lambda(string, (Expr)unaryOperator.apply(Language.Var(string))));
    }

    public static Expr Take(Expr expr, Expr expr2) {
        return Fn.apply("take", expr, "collection", expr2);
    }

    public static Expr Take(long l, Expr expr) {
        return Language.Take(new Value.LongV(l), expr);
    }

    public static Expr Drop(Expr expr, Expr expr2) {
        return Fn.apply("drop", expr, "collection", expr2);
    }

    public static Expr Drop(long l, Expr expr) {
        return Language.Drop(new Value.LongV(l), expr);
    }

    public static Expr Prepend(Expr expr, Expr expr2) {
        return Fn.apply("prepend", expr, "collection", expr2);
    }

    public static Expr Append(Expr expr, Expr expr2) {
        return Fn.apply("append", expr, "collection", expr2);
    }

    public static Expr IsEmpty(Expr expr) {
        return Fn.apply("is_empty", expr);
    }

    public static Expr IsNonEmpty(Expr expr) {
        return Fn.apply("is_nonempty", expr);
    }

    public static Expr Get(Expr expr) {
        return Fn.apply("get", expr);
    }

    public static Expr Get(Expr expr, Expr expr2) {
        return Fn.apply("get", expr, "ts", expr2);
    }

    public static Expr Get(Expr expr, Instant instant) {
        return Language.Get(expr, new Value.TimeV(instant));
    }

    public static Expr KeyFromSecret(Expr expr) {
        return Fn.apply("key_from_secret", expr);
    }

    public static Expr KeyFromSecret(String string) {
        return Language.KeyFromSecret(new Value.StringV(string));
    }

    public static Expr Reduce(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("reduce", expr, "initial", expr2, "collection", expr3);
    }

    public static Expr Reverse(Expr expr) {
        return Fn.apply("reverse", expr);
    }

    public static Pagination Paginate(Expr expr) {
        return new Pagination(expr);
    }

    public static Expr Exists(Expr expr) {
        return Fn.apply("exists", expr);
    }

    public static Expr Exists(Expr expr, Expr expr2) {
        return Fn.apply("exists", expr, "ts", expr2);
    }

    public static Expr Create(Expr expr, Expr expr2) {
        return Fn.apply("create", expr, "params", expr2);
    }

    public static Expr Update(Expr expr, Expr expr2) {
        return Fn.apply("update", expr, "params", expr2);
    }

    public static Expr Replace(Expr expr, Expr expr2) {
        return Fn.apply("replace", expr, "params", expr2);
    }

    public static Expr Delete(Expr expr) {
        return Fn.apply("delete", expr);
    }

    public static Expr Insert(Expr expr, Expr expr2, Expr expr3, Expr expr4) {
        return Fn.apply("insert", expr, "ts", expr2, "action", expr3, "params", expr4);
    }

    public static Expr Insert(Expr expr, Expr expr2, Action action, Expr expr3) {
        return Language.Insert(expr, expr2, action.value, expr3);
    }

    public static Expr Remove(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("remove", expr, "ts", expr2, "action", expr3);
    }

    public static Expr Remove(Expr expr, Expr expr2, Action action) {
        return Language.Remove(expr, expr2, action.value);
    }

    @Deprecated
    public static Expr CreateClass(Expr expr) {
        return Fn.apply("create_class", expr);
    }

    public static Expr CreateCollection(Expr expr) {
        return Fn.apply("create_collection", expr);
    }

    public static Expr CreateDatabase(Expr expr) {
        return Fn.apply("create_database", expr);
    }

    public static Expr CreateKey(Expr expr) {
        return Fn.apply("create_key", expr);
    }

    public static Expr CreateIndex(Expr expr) {
        return Fn.apply("create_index", expr);
    }

    public static Expr CreateFunction(Expr expr) {
        return Fn.apply("create_function", expr);
    }

    public static Expr CreateRole(Expr expr) {
        return Fn.apply("create_role", expr);
    }

    public static Expr MoveDatabase(Expr expr, Expr expr2) {
        return Fn.apply("move_database", expr, "to", expr2);
    }

    public static Expr Singleton(Expr expr) {
        return Fn.apply("singleton", expr);
    }

    public static Expr Events(Expr expr) {
        return Fn.apply("events", expr);
    }

    public static Expr Match(Expr expr) {
        return Fn.apply("match", expr);
    }

    public static Expr Match(Expr expr, Expr expr2) {
        return Fn.apply("match", expr, "terms", expr2);
    }

    public static Expr Union(List<? extends Expr> list) {
        return Fn.apply("union", Language.varargs(list));
    }

    public static Expr Union(Expr ... exprArray) {
        return Language.Union(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Intersection(List<? extends Expr> list) {
        return Fn.apply("intersection", Language.varargs(list));
    }

    public static Expr Intersection(Expr ... exprArray) {
        return Language.Intersection(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Difference(List<? extends Expr> list) {
        return Fn.apply("difference", Language.varargs(list));
    }

    public static Expr Difference(Expr ... exprArray) {
        return Language.Difference(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Distinct(Expr expr) {
        return Fn.apply("distinct", expr);
    }

    public static Expr Join(Expr expr, Expr expr2) {
        return Fn.apply("join", expr, "with", expr2);
    }

    public static Expr Join(Expr expr, UnaryOperator<Expr> unaryOperator) {
        String string = SymbolGenerator.genSym("join");
        return Language.Join(expr, Language.Lambda(string, (Expr)unaryOperator.apply(Language.Var(string))));
    }

    public static Expr Range(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("range", expr, "from", expr2, "to", expr3);
    }

    public static Expr Login(Expr expr, Expr expr2) {
        return Fn.apply("login", expr, "params", expr2);
    }

    public static Expr Logout(Expr expr) {
        return Fn.apply("logout", expr);
    }

    public static Expr Logout(boolean bl) {
        return Language.Logout(Value.BooleanV.valueOf(bl));
    }

    public static Expr Identify(Expr expr, Expr expr2) {
        return Fn.apply("identify", expr, "password", expr2);
    }

    public static Expr Identify(Expr expr, String string) {
        return Language.Identify(expr, new Value.StringV(string));
    }

    @Deprecated
    public static Expr Identity() {
        return Fn.apply("identity", Language.Null());
    }

    public static Expr CurrentIdentity() {
        return Fn.apply("current_identity", Language.Null());
    }

    @Deprecated
    public static Expr HasIdentity() {
        return Fn.apply("has_identity", Language.Null());
    }

    public static Expr AccessProviders(Expr expr) {
        return Fn.apply("access_providers", expr);
    }

    public static Expr AccessProviders() {
        return Language.AccessProviders(Language.Null());
    }

    public static Expr AccessProvider(Expr expr) {
        return Fn.apply("access_provider", expr);
    }

    public static Expr AccessProvider(String string) {
        return Language.AccessProvider(Language.Value(string));
    }

    public static Expr AccessProvider(Expr expr, Expr expr2) {
        return Fn.apply("access_provider", expr, "scope", expr2);
    }

    public static Expr AccessProvider(String string, Expr expr) {
        return Language.AccessProvider(Language.Value(string), expr);
    }

    public static Expr CreateAccessProvider(Expr expr) {
        return Fn.apply("create_access_provider", expr);
    }

    public static Expr CurrentToken() {
        return Fn.apply("current_token", Language.Null());
    }

    public static Expr HasCurrentToken() {
        return Fn.apply("has_current_token", Language.Null());
    }

    public static Expr HasCurrentIdentity() {
        return Fn.apply("has_current_identity", Language.Null());
    }

    public static Expr Concat(Expr expr) {
        return Fn.apply("concat", expr);
    }

    public static Expr Concat(Expr expr, Expr expr2) {
        return Fn.apply("concat", expr, "separator", expr2);
    }

    public static Expr Casefold(Expr expr) {
        return Fn.apply("casefold", expr);
    }

    public static Expr Casefold(String string) {
        return Language.Casefold(new Value.StringV(string));
    }

    public static Expr Casefold(Expr expr, Expr expr2) {
        return Fn.apply("casefold", expr, "normalizer", expr2);
    }

    public static Expr Casefold(String string, Expr expr) {
        return Language.Casefold((Expr)new Value.StringV(string), expr);
    }

    public static Expr Casefold(Expr expr, Normalizer normalizer) {
        return Language.Casefold(expr, normalizer.value);
    }

    public static Expr Casefold(String string, Normalizer normalizer) {
        return Language.Casefold((Expr)new Value.StringV(string), normalizer.value);
    }

    public static Expr ContainsStr(Expr expr, Expr expr2) {
        return Fn.apply("containsstr", expr, "search", expr2);
    }

    public static Expr ContainsStr(String string, Expr expr) {
        return Language.ContainsStr((Expr)new Value.StringV(string), expr);
    }

    public static Expr ContainsStr(Expr expr, String string) {
        return Language.ContainsStr(expr, (Expr)new Value.StringV(string));
    }

    public static Expr ContainsStr(String string, String string2) {
        return Language.ContainsStr((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2));
    }

    public static Expr ContainsStrRegex(Expr expr, Expr expr2) {
        return Fn.apply("containsstrregex", expr, "pattern", expr2);
    }

    public static Expr ContainsStrRegex(String string, Expr expr) {
        return Language.ContainsStrRegex((Expr)new Value.StringV(string), expr);
    }

    public static Expr ContainsStrRegex(Expr expr, String string) {
        return Language.ContainsStrRegex(expr, (Expr)new Value.StringV(string));
    }

    public static Expr ContainsStrRegex(String string, String string2) {
        return Language.ContainsStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2));
    }

    public static Expr EndsWith(Expr expr, Expr expr2) {
        return Fn.apply("endswith", expr, "search", expr2);
    }

    public static Expr EndsWith(String string, Expr expr) {
        return Language.EndsWith((Expr)new Value.StringV(string), expr);
    }

    public static Expr EndsWith(Expr expr, String string) {
        return Language.EndsWith(expr, (Expr)new Value.StringV(string));
    }

    public static Expr EndsWith(String string, String string2) {
        return Language.EndsWith((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2));
    }

    public static Expr FindStr(Expr expr, Expr expr2) {
        return Fn.apply("findstr", expr, "find", expr2);
    }

    public static Expr FindStr(String string, Expr expr) {
        return Language.FindStr((Expr)new Value.StringV(string), expr);
    }

    public static Expr FindStr(Expr expr, String string) {
        return Language.FindStr(expr, (Expr)new Value.StringV(string));
    }

    public static Expr FindStr(String string, String string2) {
        return Language.FindStr((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2));
    }

    public static Expr FindStr(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("findstr", expr, "find", expr2, "start", expr3);
    }

    public static Expr FindStr(Expr expr, Expr expr2, long l) {
        return Language.FindStr(expr, expr2, (Expr)new Value.LongV(l));
    }

    public static Expr FindStr(Expr expr, String string, Expr expr2) {
        return Language.FindStr(expr, (Expr)new Value.StringV(string), expr2);
    }

    public static Expr FindStr(String string, Expr expr, long l) {
        return Language.FindStr((Expr)new Value.StringV(string), expr, (Expr)new Value.LongV(l));
    }

    public static Expr FindStr(String string, String string2, Expr expr) {
        return Language.FindStr((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), expr);
    }

    public static Expr FindStr(String string, String string2, long l) {
        return Language.FindStr((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), (Expr)new Value.LongV(l));
    }

    public static Expr FindStrRegex(Expr expr, Expr expr2) {
        return Fn.apply("findstrregex", expr, "pattern", expr2);
    }

    public static Expr FindStrRegex(Expr expr, String string) {
        return Language.FindStrRegex(expr, (Expr)new Value.StringV(string));
    }

    public static Expr FindStrRegex(String string, Expr expr) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), expr);
    }

    public static Expr FindStrRegex(String string, String string2) {
        return Language.FindStrRegex(new String(string), (Expr)new Value.StringV(string2));
    }

    public static Expr FindStrRegex(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("findstrregex", expr, "pattern", expr2, "start", expr3);
    }

    public static Expr FindStrRegex(String string, Expr expr, Expr expr2) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), expr, expr2);
    }

    public static Expr FindStrRegex(Expr expr, String string, Expr expr2) {
        return Language.FindStrRegex(expr, (Expr)new Value.StringV(string), expr2);
    }

    public static Expr FindStrRegex(String string, String string2, Expr expr) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), expr);
    }

    public static Expr FindStrRegex(Expr expr, Expr expr2, long l) {
        return Language.FindStrRegex(expr, expr2, (Expr)new Value.LongV(l));
    }

    public static Expr FindStrRegex(String string, Expr expr, long l) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), expr, (Expr)new Value.LongV(l));
    }

    public static Expr FindStrRegex(Expr expr, String string, long l) {
        return Language.FindStrRegex(expr, (Expr)new Value.StringV(string), (Expr)new Value.LongV(l));
    }

    public static Expr FindStrRegex(String string, String string2, long l) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), (Expr)new Value.LongV(l));
    }

    public static Expr FindStrRegex(Expr expr, Expr expr2, Expr expr3, Expr expr4) {
        return Fn.apply("findstrregex", expr, "pattern", expr2, "start", expr3, "num_results", expr4);
    }

    public static Expr FindStrRegex(String string, Expr expr, Expr expr2, Expr expr3) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), expr, expr2, expr3);
    }

    public static Expr FindStrRegex(Expr expr, String string, Expr expr2, Expr expr3) {
        return Language.FindStrRegex(expr, (Expr)new Value.StringV(string), expr2, expr3);
    }

    public static Expr FindStrRegex(String string, String string2, Expr expr, Expr expr2) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), expr, expr2);
    }

    public static Expr FindStrRegex(Expr expr, Expr expr2, long l, Expr expr3) {
        return Language.FindStrRegex(expr, expr2, (Expr)new Value.LongV(l), expr3);
    }

    public static Expr FindStrRegex(String string, Expr expr, long l, Expr expr2) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), expr, (Expr)new Value.LongV(l), expr2);
    }

    public static Expr FindStrRegex(Expr expr, String string, long l, Expr expr2) {
        return Language.FindStrRegex(expr, (Expr)new Value.StringV(string), (Expr)new Value.LongV(l), expr2);
    }

    public static Expr FindStrRegex(String string, String string2, long l, Expr expr) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), (Expr)new Value.LongV(l), expr);
    }

    public static Expr FindStrRegex(Expr expr, Expr expr2, Expr expr3, long l) {
        return Language.FindStrRegex(expr, expr2, expr3, (Expr)new Value.LongV(l));
    }

    public static Expr FindStrRegex(String string, Expr expr, Expr expr2, long l) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), expr, expr2, (Expr)new Value.LongV(l));
    }

    public static Expr FindStrRegex(Expr expr, String string, Expr expr2, long l) {
        return Language.FindStrRegex(expr, (Expr)new Value.StringV(string), expr2, (Expr)new Value.LongV(l));
    }

    public static Expr FindStrRegex(String string, String string2, Expr expr, long l) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), expr, (Expr)new Value.LongV(l));
    }

    public static Expr FindStrRegex(Expr expr, Expr expr2, long l, long l2) {
        return Language.FindStrRegex(expr, expr2, (Expr)new Value.LongV(l), (Expr)new Value.LongV(l2));
    }

    public static Expr FindStrRegex(String string, Expr expr, long l, long l2) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), expr, (Expr)new Value.LongV(l), (Expr)new Value.LongV(l2));
    }

    public static Expr FindStrRegex(Expr expr, String string, long l, long l2) {
        return Language.FindStrRegex(expr, (Expr)new Value.StringV(string), (Expr)new Value.LongV(l), (Expr)new Value.LongV(l2));
    }

    public static Expr FindStrRegex(String string, String string2, long l, long l2) {
        return Language.FindStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), (Expr)new Value.LongV(l), (Expr)new Value.LongV(l2));
    }

    public static Expr Length(Expr expr) {
        return Fn.apply("length", expr);
    }

    public static Expr Length(String string) {
        return Language.Length(new Value.StringV(string));
    }

    public static Expr LowerCase(Expr expr) {
        return Fn.apply("lowercase", expr);
    }

    public static Expr LowerCase(String string) {
        return Language.LowerCase(new Value.StringV(string));
    }

    public static Expr LTrim(Expr expr) {
        return Fn.apply("ltrim", expr);
    }

    public static Expr LTrim(String string) {
        return Language.LTrim(new Value.StringV(string));
    }

    public static Expr NGram(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("ngram", expr, "min", expr2, "max", expr3);
    }

    public static Expr NGram(String string, Expr expr, Expr expr2) {
        return Language.NGram((Expr)new Value.StringV(string), expr, expr2);
    }

    public static Expr NGram(Expr expr, long l, Expr expr2) {
        return Language.NGram(expr, (Expr)new Value.LongV(l), expr2);
    }

    public static Expr NGram(String string, long l, Expr expr) {
        return Language.NGram(string, (Expr)new Value.LongV(l), expr);
    }

    public static Expr NGram(Expr expr, Expr expr2, long l) {
        return Language.NGram(expr, expr2, (Expr)new Value.LongV(l));
    }

    public static Expr NGram(String string, Expr expr, long l) {
        return Language.NGram(string, expr, (Expr)new Value.LongV(l));
    }

    public static Expr NGram(Expr expr, long l, long l2) {
        return Language.NGram(expr, (Expr)new Value.LongV(l), (Expr)new Value.LongV(l2));
    }

    public static Expr NGram(String string, long l, long l2) {
        return Language.NGram(string, (Expr)new Value.LongV(l), (Expr)new Value.LongV(l2));
    }

    public static Expr NGram(List<Expr> list, Expr expr, Expr expr2) {
        return Language.NGram(Language.varargs(list), expr, expr2);
    }

    public static Expr NGram(List<Expr> list) {
        return Language.NGram(Language.varargs(list));
    }

    public static Expr NGram(Expr expr) {
        return Fn.apply("ngram", expr);
    }

    public static Expr NGram(String string) {
        return Language.NGram(new Value.StringV(string));
    }

    public static Expr RegexEscape(Expr expr) {
        return Fn.apply("regexescape", expr);
    }

    public static Expr RegexEscape(String string) {
        return Language.RegexEscape(new Value.StringV(string));
    }

    public static Expr Repeat(Expr expr) {
        return Fn.apply("repeat", expr);
    }

    public static Expr Repeat(String string) {
        return Language.Repeat(new Value.StringV(string));
    }

    public static Expr Repeat(Expr expr, Expr expr2) {
        return Fn.apply("repeat", expr, "number", expr2);
    }

    public static Expr Repeat(String string, Expr expr) {
        return Language.Repeat((Expr)new Value.StringV(string), expr);
    }

    public static Expr Repeat(Expr expr, long l) {
        return Language.Repeat(expr, (Expr)new Value.LongV(l));
    }

    public static Expr Repeat(String string, long l) {
        return Language.Repeat((Expr)new Value.StringV(string), (Expr)new Value.LongV(l));
    }

    public static Expr ReplaceStr(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("replacestr", expr, "find", expr2, "replace", expr3);
    }

    public static Expr ReplaceStr(String string, Expr expr, Expr expr2) {
        return Language.ReplaceStr((Expr)new Value.StringV(string), expr, expr2);
    }

    public static Expr ReplaceStr(Expr expr, String string, Expr expr2) {
        return Language.ReplaceStr(expr, (Expr)new Value.StringV(string), expr2);
    }

    public static Expr ReplaceStr(String string, String string2, Expr expr) {
        return Language.ReplaceStr((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), expr);
    }

    public static Expr ReplaceStr(Expr expr, Expr expr2, String string) {
        return Language.ReplaceStr(expr, expr2, (Expr)new Value.StringV(string));
    }

    public static Expr ReplaceStr(String string, Expr expr, String string2) {
        return Language.ReplaceStr((Expr)new Value.StringV(string), expr, (Expr)new Value.StringV(string2));
    }

    public static Expr ReplaceStr(Expr expr, String string, String string2) {
        return Language.ReplaceStr(expr, (Expr)new Value.StringV(string), (Expr)new Value.StringV(string2));
    }

    public static Expr ReplaceStr(String string, String string2, String string3) {
        return Language.ReplaceStr((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), (Expr)new Value.StringV(string3));
    }

    public static Expr ReplaceStrRegex(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("replacestrregex", expr, "pattern", expr2, "replace", expr3);
    }

    public static Expr ReplaceStrRegex(String string, Expr expr, Expr expr2) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), expr, expr2);
    }

    public static Expr ReplaceStrRegex(Expr expr, String string, Expr expr2) {
        return Language.ReplaceStrRegex(expr, (Expr)new Value.StringV(string), expr2);
    }

    public static Expr ReplaceStrRegex(String string, String string2, Expr expr) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), expr);
    }

    public static Expr ReplaceStrRegex(Expr expr, Expr expr2, String string) {
        return Language.ReplaceStrRegex(expr, expr2, (Expr)new Value.StringV(string));
    }

    public static Expr ReplaceStrRegex(String string, Expr expr, String string2) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), expr, (Expr)new Value.StringV(string2));
    }

    public static Expr ReplaceStrRegex(Expr expr, String string, String string2) {
        return Language.ReplaceStrRegex(expr, (Expr)new Value.StringV(string), string2);
    }

    public static Expr ReplaceStrRegex(String string, String string2, String string3) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), string3);
    }

    public static Expr ReplaceStrRegex(Expr expr, Expr expr2, Expr expr3, Expr expr4) {
        return Fn.apply("replacestrregex", expr, "pattern", expr2, "replace", expr3, "first", expr4);
    }

    public static Expr ReplaceStrRegex(String string, Expr expr, Expr expr2, Expr expr3) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), expr, expr2, expr3);
    }

    public static Expr ReplaceStrRegex(Expr expr, String string, Expr expr2, Expr expr3) {
        return Language.ReplaceStrRegex(expr, (Expr)new Value.StringV(string), expr2, expr3);
    }

    public static Expr ReplaceStrRegex(String string, String string2, Expr expr, Expr expr2) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), expr, expr2);
    }

    public static Expr ReplaceStrRegex(Expr expr, Expr expr2, String string, Expr expr3) {
        return Language.ReplaceStrRegex(expr, expr2, (Expr)new Value.StringV(string), expr3);
    }

    public static Expr ReplaceStrRegex(String string, Expr expr, String string2, Expr expr2) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), expr, (Expr)new Value.StringV(string2), expr2);
    }

    public static Expr ReplaceStrRegex(Expr expr, String string, String string2, Expr expr2) {
        return Language.ReplaceStrRegex(expr, (Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), expr2);
    }

    public static Expr ReplaceStrRegex(String string, String string2, String string3, Expr expr) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), (Expr)new Value.StringV(string3), expr);
    }

    public static Expr ReplaceStrRegex(Expr expr, Expr expr2, Expr expr3, Boolean bl) {
        return Language.ReplaceStrRegex(expr, expr2, expr3, (Expr)Value.BooleanV.valueOf(bl));
    }

    public static Expr ReplaceStrRegex(String string, Expr expr, Expr expr2, boolean bl) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), expr, expr2, (Expr)Value.BooleanV.valueOf(bl));
    }

    public static Expr ReplaceStrRegex(Expr expr, String string, Expr expr2, boolean bl) {
        return Language.ReplaceStrRegex(expr, (Expr)new Value.StringV(string), expr2, (Expr)Value.BooleanV.valueOf(bl));
    }

    public static Expr ReplaceStrRegex(String string, String string2, Expr expr, boolean bl) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), expr, (Expr)Value.BooleanV.valueOf(bl));
    }

    public static Expr ReplaceStrRegex(Expr expr, Expr expr2, String string, boolean bl) {
        return Language.ReplaceStrRegex(expr, expr2, (Expr)new Value.StringV(string), (Expr)Value.BooleanV.valueOf(bl));
    }

    public static Expr ReplaceStrRegex(String string, Expr expr, String string2, boolean bl) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), expr, (Expr)new Value.StringV(string2), (Expr)Value.BooleanV.valueOf(bl));
    }

    public static Expr ReplaceStrRegex(Expr expr, String string, String string2, boolean bl) {
        return Language.ReplaceStrRegex(expr, (Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), (Expr)Value.BooleanV.valueOf(bl));
    }

    public static Expr ReplaceStrRegex(String string, String string2, String string3, boolean bl) {
        return Language.ReplaceStrRegex((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2), (Expr)new Value.StringV(string3), (Expr)Value.BooleanV.valueOf(bl));
    }

    public static Expr RTrim(Expr expr) {
        return Fn.apply("rtrim", expr);
    }

    public static Expr RTrim(String string) {
        return Language.RTrim(new Value.StringV(string));
    }

    public static Expr Space(Expr expr) {
        return Fn.apply("space", expr);
    }

    public static Expr Space(Long l) {
        return Language.Space(new Value.LongV(l));
    }

    public static Expr Space(Integer n) {
        return Language.Space(new Value.LongV(n.intValue()));
    }

    public static Expr SubString(Expr expr) {
        return Fn.apply("substring", expr);
    }

    public static Expr SubString(String string) {
        return Language.SubString(new Value.StringV(string));
    }

    public static Expr SubString(Expr expr, Expr expr2) {
        return Fn.apply("substring", expr, "start", expr2);
    }

    public static Expr SubString(String string, Expr expr) {
        return Language.SubString((Expr)new Value.StringV(string), expr);
    }

    public static Expr SubString(Expr expr, long l) {
        return Language.SubString(expr, (Expr)new Value.LongV(l));
    }

    public static Expr SubString(String string, long l) {
        return Language.SubString((Expr)new Value.StringV(string), (Expr)new Value.LongV(l));
    }

    public static Expr SubString(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("substring", expr, "start", expr2, "length", expr3);
    }

    public static Expr SubString(String string, Expr expr, Expr expr2) {
        return Language.SubString((Expr)new Value.StringV(string), expr, expr2);
    }

    public static Expr SubString(Expr expr, long l, Expr expr2) {
        return Language.SubString(expr, (Expr)new Value.LongV(l), expr2);
    }

    public static Expr SubString(String string, long l, Expr expr) {
        return Language.SubString((Expr)new Value.StringV(string), (Expr)new Value.LongV(l), expr);
    }

    public static Expr SubString(Expr expr, long l, long l2) {
        return Language.SubString(expr, (Expr)new Value.LongV(l), (Expr)new Value.LongV(l2));
    }

    public static Expr SubString(Expr expr, Expr expr2, long l) {
        return Language.SubString(expr, expr2, (Expr)new Value.LongV(l));
    }

    public static Expr SubString(String string, Expr expr, long l) {
        return Language.SubString((Expr)new Value.StringV(string), expr, (Expr)new Value.LongV(l));
    }

    public static Expr SubString(String string, long l, long l2) {
        return Language.SubString((Expr)new Value.StringV(string), (Expr)new Value.LongV(l), (Expr)new Value.LongV(l2));
    }

    public static Expr TitleCase(Expr expr) {
        return Fn.apply("titlecase", expr);
    }

    public static Expr TitleCase(String string) {
        return Language.TitleCase(new Value.StringV(string));
    }

    public static Expr Trim(Expr expr) {
        return Fn.apply("trim", expr);
    }

    public static Expr Trim(String string) {
        return Language.Trim(new Value.StringV(string));
    }

    public static Expr UpperCase(Expr expr) {
        return Fn.apply("uppercase", expr);
    }

    public static Expr UpperCase(String string) {
        return Language.UpperCase(new Value.StringV(string));
    }

    public static Expr Format(Expr expr, Expr ... exprArray) {
        return Fn.apply("format", expr, "values", Language.varargs(Arrays.asList(exprArray)));
    }

    public static Expr Format(String string, Expr ... exprArray) {
        return Language.Format(new Value.StringV(string), exprArray);
    }

    public static Expr StartsWith(Expr expr, Expr expr2) {
        return Fn.apply("startswith", expr, "search", expr2);
    }

    public static Expr StartsWith(String string, Expr expr) {
        return Language.StartsWith((Expr)new Value.StringV(string), expr);
    }

    public static Expr StartsWith(Expr expr, String string) {
        return Language.StartsWith(expr, (Expr)new Value.StringV(string));
    }

    public static Expr StartsWith(String string, String string2) {
        return Language.StartsWith((Expr)new Value.StringV(string), (Expr)new Value.StringV(string2));
    }

    public static Expr Time(Expr expr) {
        return Fn.apply("time", expr);
    }

    public static Expr Time(String string) {
        return Language.Time(new Value.StringV(string));
    }

    public static Expr Epoch(Expr expr, TimeUnit timeUnit) {
        return Language.Epoch(expr, timeUnit.value);
    }

    public static Expr Epoch(long l, TimeUnit timeUnit) {
        return Language.Epoch((Expr)new Value.LongV(l), timeUnit);
    }

    public static Expr Epoch(Expr expr, Expr expr2) {
        return Fn.apply("epoch", expr, "unit", expr2);
    }

    public static Expr Epoch(Expr expr, String string) {
        return Language.Epoch(expr, (Expr)new Value.StringV(string));
    }

    public static Expr Epoch(long l, Expr expr) {
        return Language.Epoch((Expr)new Value.LongV(l), expr);
    }

    public static Expr Epoch(long l, String string) {
        return Language.Epoch((Expr)new Value.LongV(l), (Expr)new Value.StringV(string));
    }

    public static Expr TimeAdd(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("time_add", expr, "offset", expr2, "unit", expr3);
    }

    public static Expr TimeAdd(Expr expr, Expr expr2, TimeUnit timeUnit) {
        return Language.TimeAdd(expr, expr2, timeUnit.value);
    }

    public static Expr TimeAdd(Expr expr, Expr expr2, String string) {
        return Language.TimeAdd(expr, expr2, Language.Value(string));
    }

    public static Expr TimeAdd(Expr expr, long l, Expr expr2) {
        return Language.TimeAdd(expr, (Expr)new Value.LongV(l), expr2);
    }

    public static Expr TimeAdd(Expr expr, long l, TimeUnit timeUnit) {
        return Language.TimeAdd(expr, (Expr)new Value.LongV(l), timeUnit.value);
    }

    public static Expr TimeAdd(Expr expr, long l, String string) {
        return Language.TimeAdd(expr, (Expr)new Value.LongV(l), Language.Value(string));
    }

    public static Expr TimeAdd(Instant instant, Expr expr, Expr expr2) {
        return Language.TimeAdd((Expr)new Value.TimeV(instant), expr, expr2);
    }

    public static Expr TimeAdd(Instant instant, Expr expr, TimeUnit timeUnit) {
        return Language.TimeAdd((Expr)new Value.TimeV(instant), expr, timeUnit.value);
    }

    public static Expr TimeAdd(Instant instant, Expr expr, String string) {
        return Language.TimeAdd((Expr)new Value.TimeV(instant), expr, Language.Value(string));
    }

    public static Expr TimeAdd(Instant instant, long l, Expr expr) {
        return Language.TimeAdd((Expr)new Value.TimeV(instant), (Expr)new Value.LongV(l), expr);
    }

    public static Expr TimeAdd(Instant instant, long l, TimeUnit timeUnit) {
        return Language.TimeAdd((Expr)new Value.TimeV(instant), (Expr)new Value.LongV(l), timeUnit.value);
    }

    public static Expr TimeAdd(Instant instant, long l, String string) {
        return Language.TimeAdd((Expr)new Value.TimeV(instant), (Expr)new Value.LongV(l), Language.Value(string));
    }

    public static Expr TimeAdd(LocalDate localDate, Expr expr, Expr expr2) {
        return Language.TimeAdd((Expr)new Value.DateV(localDate), expr, expr2);
    }

    public static Expr TimeAdd(LocalDate localDate, long l, Expr expr) {
        return Language.TimeAdd((Expr)new Value.DateV(localDate), (Expr)new Value.LongV(l), expr);
    }

    public static Expr TimeAdd(LocalDate localDate, long l, TimeUnit timeUnit) {
        return Language.TimeAdd((Expr)new Value.DateV(localDate), (Expr)new Value.LongV(l), timeUnit.value);
    }

    public static Expr TimeAdd(LocalDate localDate, long l, String string) {
        return Language.TimeAdd((Expr)new Value.DateV(localDate), (Expr)new Value.LongV(l), Language.Value(string));
    }

    public static Expr TimeAdd(LocalDate localDate, Expr expr, TimeUnit timeUnit) {
        return Language.TimeAdd((Expr)new Value.DateV(localDate), expr, timeUnit.value);
    }

    public static Expr TimeAdd(LocalDate localDate, Expr expr, String string) {
        return Language.TimeAdd((Expr)new Value.DateV(localDate), expr, Language.Value(string));
    }

    public static Expr TimeSubtract(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("time_subtract", expr, "offset", expr2, "unit", expr3);
    }

    public static Expr TimeSubtract(Expr expr, Expr expr2, TimeUnit timeUnit) {
        return Language.TimeSubtract(expr, expr2, timeUnit.value);
    }

    public static Expr TimeSubtract(Expr expr, Expr expr2, String string) {
        return Language.TimeSubtract(expr, expr2, Language.Value(string));
    }

    public static Expr TimeSubtract(Expr expr, long l, Expr expr2) {
        return Language.TimeSubtract(expr, (Expr)new Value.LongV(l), expr2);
    }

    public static Expr TimeSubtract(Expr expr, long l, TimeUnit timeUnit) {
        return Language.TimeSubtract(expr, (Expr)new Value.LongV(l), timeUnit.value);
    }

    public static Expr TimeSubtract(Expr expr, long l, String string) {
        return Language.TimeSubtract(expr, (Expr)new Value.LongV(l), Language.Value(string));
    }

    public static Expr TimeSubtract(Instant instant, Expr expr, Expr expr2) {
        return Language.TimeSubtract((Expr)new Value.TimeV(instant), expr, expr2);
    }

    public static Expr TimeSubtract(Instant instant, Expr expr, TimeUnit timeUnit) {
        return Language.TimeSubtract((Expr)new Value.TimeV(instant), expr, timeUnit.value);
    }

    public static Expr TimeSubtract(Instant instant, Expr expr, String string) {
        return Language.TimeSubtract((Expr)new Value.TimeV(instant), expr, Language.Value(string));
    }

    public static Expr TimeSubtract(Instant instant, long l, Expr expr) {
        return Language.TimeSubtract((Expr)new Value.TimeV(instant), (Expr)new Value.LongV(l), expr);
    }

    public static Expr TimeSubtract(Instant instant, long l, TimeUnit timeUnit) {
        return Language.TimeSubtract((Expr)new Value.TimeV(instant), (Expr)new Value.LongV(l), timeUnit.value);
    }

    public static Expr TimeSubtract(Instant instant, long l, String string) {
        return Language.TimeSubtract((Expr)new Value.TimeV(instant), (Expr)new Value.LongV(l), Language.Value(string));
    }

    public static Expr TimeSubtract(LocalDate localDate, Expr expr, Expr expr2) {
        return Language.TimeSubtract((Expr)new Value.DateV(localDate), expr, expr2);
    }

    public static Expr TimeSubtract(LocalDate localDate, Expr expr, TimeUnit timeUnit) {
        return Language.TimeSubtract((Expr)new Value.DateV(localDate), expr, timeUnit.value);
    }

    public static Expr TimeSubtract(LocalDate localDate, Expr expr, String string) {
        return Language.TimeSubtract((Expr)new Value.DateV(localDate), expr, Language.Value(string));
    }

    public static Expr TimeSubtract(LocalDate localDate, long l, Expr expr) {
        return Language.TimeSubtract((Expr)new Value.DateV(localDate), (Expr)new Value.LongV(l), expr);
    }

    public static Expr TimeSubtract(LocalDate localDate, long l, TimeUnit timeUnit) {
        return Language.TimeSubtract((Expr)new Value.DateV(localDate), (Expr)new Value.LongV(l), timeUnit.value);
    }

    public static Expr TimeSubtract(LocalDate localDate, long l, String string) {
        return Language.TimeSubtract((Expr)new Value.DateV(localDate), (Expr)new Value.LongV(l), Language.Value(string));
    }

    public static Expr TimeDiff(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("time_diff", expr, "other", expr2, "unit", expr3);
    }

    public static Expr TimeDiff(Expr expr, Expr expr2, TimeUnit timeUnit) {
        return Language.TimeDiff(expr, expr2, timeUnit.value);
    }

    public static Expr TimeDiff(Expr expr, Expr expr2, String string) {
        return Language.TimeDiff(expr, expr2, Language.Value(string));
    }

    public static Expr TimeDiff(Instant instant, Expr expr, Expr expr2) {
        return Language.TimeDiff((Expr)new Value.TimeV(instant), expr, expr2);
    }

    public static Expr TimeDiff(Instant instant, Expr expr, TimeUnit timeUnit) {
        return Language.TimeDiff((Expr)new Value.TimeV(instant), expr, timeUnit.value);
    }

    public static Expr TimeDiff(Instant instant, Expr expr, String string) {
        return Language.TimeDiff((Expr)new Value.TimeV(instant), expr, Language.Value(string));
    }

    public static Expr TimeDiff(Instant instant, Instant instant2, Expr expr) {
        return Language.TimeDiff((Expr)new Value.TimeV(instant), (Expr)new Value.TimeV(instant2), expr);
    }

    public static Expr TimeDiff(Instant instant, Instant instant2, TimeUnit timeUnit) {
        return Language.TimeDiff((Expr)new Value.TimeV(instant), (Expr)new Value.TimeV(instant2), timeUnit.value);
    }

    public static Expr TimeDiff(Instant instant, Instant instant2, String string) {
        return Language.TimeDiff((Expr)new Value.TimeV(instant), (Expr)new Value.TimeV(instant2), Language.Value(string));
    }

    public static Expr TimeDiff(LocalDate localDate, Expr expr, Expr expr2) {
        return Language.TimeDiff((Expr)new Value.DateV(localDate), expr, expr2);
    }

    public static Expr TimeDiff(LocalDate localDate, Expr expr, TimeUnit timeUnit) {
        return Language.TimeDiff((Expr)new Value.DateV(localDate), expr, timeUnit.value);
    }

    public static Expr TimeDiff(LocalDate localDate, Expr expr, String string) {
        return Language.TimeDiff((Expr)new Value.DateV(localDate), expr, Language.Value(string));
    }

    public static Expr TimeDiff(LocalDate localDate, LocalDate localDate2, Expr expr) {
        return Language.TimeDiff((Expr)new Value.DateV(localDate), (Expr)new Value.DateV(localDate2), expr);
    }

    public static Expr TimeDiff(LocalDate localDate, LocalDate localDate2, TimeUnit timeUnit) {
        return Language.TimeDiff((Expr)new Value.DateV(localDate), (Expr)new Value.DateV(localDate2), timeUnit.value);
    }

    public static Expr TimeDiff(LocalDate localDate, LocalDate localDate2, String string) {
        return Language.TimeDiff((Expr)new Value.DateV(localDate), (Expr)new Value.DateV(localDate2), Language.Value(string));
    }

    public static Expr Date(Expr expr) {
        return Fn.apply("date", expr);
    }

    public static Expr Date(String string) {
        return Language.Date(new Value.StringV(string));
    }

    public static Expr Now() {
        return Fn.apply("now", Language.Null());
    }

    @Deprecated
    public static Expr NextId() {
        return Fn.apply("next_id", Value.NullV.NULL);
    }

    public static Expr NewId() {
        return Fn.apply("new_id", Value.NullV.NULL);
    }

    @Deprecated
    public static Expr Class(Expr expr) {
        return Fn.apply("class", expr);
    }

    @Deprecated
    public static Expr Class(String string) {
        return Language.Class(Language.Value(string));
    }

    @Deprecated
    public static Expr Class(Expr expr, Expr expr2) {
        return Fn.apply("class", expr, "scope", expr2);
    }

    public static Expr Collection(Expr expr) {
        return Fn.apply("collection", expr);
    }

    public static Expr Collection(String string) {
        return Language.Collection(Language.Value(string));
    }

    public static Expr Collection(Expr expr, Expr expr2) {
        return Fn.apply("collection", expr, "scope", expr2);
    }

    @Deprecated
    public static Expr Class(String string, Expr expr) {
        return Language.Class(Language.Value(string), expr);
    }

    public static Expr Collection(String string, Expr expr) {
        return Language.Collection(Language.Value(string), expr);
    }

    public static Expr Database(Expr expr) {
        return Fn.apply("database", expr);
    }

    public static Expr Database(String string) {
        return Language.Database(Language.Value(string));
    }

    public static Expr Database(Expr expr, Expr expr2) {
        return Fn.apply("database", expr, "scope", expr2);
    }

    public static Expr Database(String string, Expr expr) {
        return Language.Database(Language.Value(string), expr);
    }

    public static Expr Index(Expr expr) {
        return Fn.apply("index", expr);
    }

    public static Expr Index(String string) {
        return Language.Index(Language.Value(string));
    }

    public static Expr Index(Expr expr, Expr expr2) {
        return Fn.apply("index", expr, "scope", expr2);
    }

    public static Expr Index(String string, Expr expr) {
        return Language.Index(Language.Value(string), expr);
    }

    public static Expr Function(Expr expr) {
        return Fn.apply("function", expr);
    }

    public static Expr Function(String string) {
        return Language.Function(Language.Value(string));
    }

    public static Expr Function(Expr expr, Expr expr2) {
        return Fn.apply("function", expr, "scope", expr2);
    }

    public static Expr Function(String string, Expr expr) {
        return Language.Function(Language.Value(string), expr);
    }

    public static Expr Role(Expr expr) {
        return Fn.apply("role", expr);
    }

    public static Expr Role(String string) {
        return Language.Role(Language.Value(string));
    }

    public static Expr Role(Expr expr, Expr expr2) {
        return Fn.apply("role", expr, "scope", expr2);
    }

    public static Expr Role(String string, Expr expr) {
        return Language.Role(Language.Value(string), expr);
    }

    public static Expr Equals(List<? extends Expr> list) {
        return Fn.apply("equals", Language.varargs(list));
    }

    public static Expr Equals(Expr ... exprArray) {
        return Language.Equals(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    @Deprecated
    public static Expr Contains(Expr expr, Expr expr2) {
        return Fn.apply("contains", expr, "in", expr2);
    }

    @Deprecated
    public static Expr Contains(Path path, Expr expr) {
        return Language.Contains(Language.Arr(path.segments), expr);
    }

    public static Expr ContainsField(Expr expr, Expr expr2) {
        return Fn.apply("contains_field", expr, "in", expr2);
    }

    public static Expr ContainsPath(Expr expr, Expr expr2) {
        return Fn.apply("contains_path", expr, "in", expr2);
    }

    public static Expr ContainsPath(Path path, Expr expr) {
        return Language.ContainsPath(Language.Arr(path.segments), expr);
    }

    public static Expr ContainsValue(Expr expr, Expr expr2) {
        return Fn.apply("contains_value", expr, "in", expr2);
    }

    public static Path Path(String ... stringArray) {
        return new Path().at(stringArray);
    }

    public static Path Path(int ... nArray) {
        return new Path().at(nArray);
    }

    public static Expr Select(Expr expr, Expr expr2) {
        return Fn.apply("select", expr, "from", expr2);
    }

    public static Expr Select(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("select", expr, "from", expr2, "default", expr3);
    }

    public static Expr Select(Path path, Expr expr) {
        return Language.Select(Language.Arr(path.segments), expr);
    }

    public static Expr Select(Path path, Expr expr, Expr expr2) {
        return Language.Select(Language.Arr(path.segments), expr, expr2);
    }

    @Deprecated
    public static Expr SelectAll(Expr expr, Expr expr2) {
        return Fn.apply("select_all", expr, "from", expr2);
    }

    @Deprecated
    public static Expr SelectAll(Path path, Expr expr) {
        return Language.SelectAll(Language.Arr(path.segments), expr);
    }

    public static Expr SelectAsIndex(Expr expr, Expr expr2) {
        return Fn.apply("select_as_index", expr, "from", expr2);
    }

    public static Expr SelectAsIndex(Path path, Expr expr) {
        return Language.SelectAsIndex(Language.Arr(path.segments), expr);
    }

    public static Expr Abs(Expr expr) {
        return Fn.apply("abs", expr);
    }

    public static Expr Abs(Long l) {
        return Fn.apply("abs", new Value.LongV(l));
    }

    public static Expr Abs(Double d) {
        return Fn.apply("abs", new Value.DoubleV(d));
    }

    public static Expr Acos(Expr expr) {
        return Fn.apply("acos", expr);
    }

    public static Expr Acos(Double d) {
        return Fn.apply("acos", new Value.DoubleV(d));
    }

    public static Expr Add(List<? extends Expr> list) {
        return Fn.apply("add", Language.varargs(list));
    }

    public static Expr Add(Expr ... exprArray) {
        return Language.Add(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Asin(Expr expr) {
        return Fn.apply("asin", expr);
    }

    public static Expr Asin(Double d) {
        return Fn.apply("asin", new Value.DoubleV(d));
    }

    public static Expr Atan(Expr expr) {
        return Fn.apply("atan", expr);
    }

    public static Expr Atan(Double d) {
        return Fn.apply("atan", new Value.DoubleV(d));
    }

    public static Expr BitAnd(List<? extends Expr> list) {
        return Fn.apply("bitand", Language.varargs(list));
    }

    public static Expr BitAnd(Expr ... exprArray) {
        return Language.BitAnd(Arrays.asList(exprArray));
    }

    public static Expr BitNot(Expr expr) {
        return Fn.apply("bitnot", expr);
    }

    public static Expr BitNot(Long l) {
        return Fn.apply("bitnot", new Value.LongV(l));
    }

    public static Expr BitOr(List<? extends Expr> list) {
        return Fn.apply("bitor", Language.varargs(list));
    }

    public static Expr BitOr(Expr ... exprArray) {
        return Language.BitOr(Arrays.asList(exprArray));
    }

    public static Expr BitXor(List<? extends Expr> list) {
        return Fn.apply("bitxor", Language.varargs(list));
    }

    public static Expr BitXor(Expr ... exprArray) {
        return Language.BitXor(Arrays.asList(exprArray));
    }

    public static Expr Ceil(Expr expr) {
        return Fn.apply("ceil", expr);
    }

    public static Expr Ceil(Long l) {
        return Fn.apply("ceil", new Value.LongV(l));
    }

    public static Expr Ceil(Double d) {
        return Fn.apply("ceil", new Value.DoubleV(d));
    }

    public static Expr Cos(Expr expr) {
        return Fn.apply("cos", expr);
    }

    public static Expr Cos(Double d) {
        return Fn.apply("cos", new Value.DoubleV(d));
    }

    public static Expr Cosh(Expr expr) {
        return Fn.apply("cosh", expr);
    }

    public static Expr Cosh(Double d) {
        return Fn.apply("cosh", new Value.DoubleV(d));
    }

    public static Expr Degrees(Expr expr) {
        return Fn.apply("degrees", expr);
    }

    public static Expr Degrees(Double d) {
        return Fn.apply("degrees", new Value.DoubleV(d));
    }

    public static Expr Degrees(Long l) {
        return Fn.apply("degrees", new Value.LongV(l));
    }

    public static Expr Divide(List<? extends Expr> list) {
        return Fn.apply("divide", Language.varargs(list));
    }

    public static Expr Divide(Expr ... exprArray) {
        return Language.Divide(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Exp(Expr expr) {
        return Fn.apply("exp", expr);
    }

    public static Expr Exp(Long l) {
        return Fn.apply("exp", new Value.LongV(l));
    }

    public static Expr Exp(Double d) {
        return Fn.apply("exp", new Value.DoubleV(d));
    }

    public static Expr Floor(Expr expr) {
        return Fn.apply("floor", expr);
    }

    public static Expr Floor(Long l) {
        return Fn.apply("floor", new Value.LongV(l));
    }

    public static Expr Floor(Double d) {
        return Fn.apply("floor", new Value.DoubleV(d));
    }

    public static Expr Ln(Expr expr) {
        return Fn.apply("ln", expr);
    }

    public static Expr Ln(Double d) {
        return Fn.apply("ln", new Value.DoubleV(d));
    }

    public static Expr Hypot(Expr expr, Expr expr2) {
        return Fn.apply("hypot", expr, "b", expr2);
    }

    public static Expr Hypot(Double d, Expr expr) {
        return Fn.apply("hypot", new Value.DoubleV(d), "b", expr);
    }

    public static Expr Hypot(Expr expr, Double d) {
        return Fn.apply("hypot", expr, "b", new Value.DoubleV(d));
    }

    public static Expr Hypot(Double d, Double d2) {
        return Fn.apply("hypot", new Value.DoubleV(d), "b", new Value.DoubleV(d2));
    }

    public static Expr Hypot(Expr expr) {
        return Fn.apply("hypot", expr);
    }

    public static Expr Hypot(Double d) {
        return Fn.apply("hypot", new Value.DoubleV(d));
    }

    public static Expr Log(Expr expr) {
        return Fn.apply("log", expr);
    }

    public static Expr Log(Double d) {
        return Fn.apply("log", new Value.DoubleV(d));
    }

    public static Expr Max(List<? extends Expr> list) {
        return Fn.apply("max", Language.varargs(list));
    }

    public static Expr Max(Expr ... exprArray) {
        return Language.Max(Arrays.asList(exprArray));
    }

    public static Expr Min(List<? extends Expr> list) {
        return Fn.apply("min", Language.varargs(list));
    }

    public static Expr Min(Expr ... exprArray) {
        return Language.Min(Arrays.asList(exprArray));
    }

    public static Expr Modulo(List<? extends Expr> list) {
        return Fn.apply("modulo", Language.varargs(list));
    }

    public static Expr Modulo(Expr ... exprArray) {
        return Language.Modulo(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Multiply(List<? extends Expr> list) {
        return Fn.apply("multiply", Language.varargs(list));
    }

    public static Expr Multiply(Expr ... exprArray) {
        return Language.Multiply(Arrays.asList(exprArray));
    }

    public static Expr Pow(Expr expr, Expr expr2) {
        return Fn.apply("pow", expr, "exp", expr2);
    }

    public static Expr Pow(Double d, Expr expr) {
        return Fn.apply("pow", new Value.DoubleV(d), "exp", expr);
    }

    public static Expr Pow(Expr expr, Double d) {
        return Fn.apply("pow", expr, "exp", new Value.DoubleV(d));
    }

    public static Expr Pow(Double d, Double d2) {
        return Fn.apply("pow", new Value.DoubleV(d), "exp", new Value.DoubleV(d2));
    }

    public static Expr Pow(Expr expr) {
        return Fn.apply("pow", expr);
    }

    public static Expr Radians(Expr expr) {
        return Fn.apply("radians", expr);
    }

    public static Expr Radians(Double d) {
        return Fn.apply("radians", new Value.DoubleV(d));
    }

    public static Expr Round(Expr expr, Expr expr2) {
        return Fn.apply("round", expr, "precision", expr2);
    }

    public static Expr Round(Double d, Expr expr) {
        return Fn.apply("round", new Value.DoubleV(d), "precision", expr);
    }

    public static Expr Round(Long l, Expr expr) {
        return Fn.apply("round", new Value.LongV(l), "precision", expr);
    }

    public static Expr Round(Expr expr, Long l) {
        return Fn.apply("round", expr, "precision", new Value.LongV(l));
    }

    public static Expr Round(Double d, Long l) {
        return Fn.apply("round", new Value.DoubleV(d), "precision", new Value.LongV(l));
    }

    public static Expr Round(Long l, Long l2) {
        return Fn.apply("round", new Value.LongV(l), "precision", new Value.LongV(l2));
    }

    public static Expr Round(Expr expr) {
        return Fn.apply("round", expr);
    }

    public static Expr Round(Double d) {
        return Fn.apply("round", new Value.DoubleV(d));
    }

    public static Expr Sign(Expr expr) {
        return Fn.apply("sign", expr);
    }

    public static Expr Sign(Double d) {
        return Fn.apply("sign", new Value.DoubleV(d));
    }

    public static Expr Sign(Long l) {
        return Fn.apply("sign", new Value.LongV(l));
    }

    public static Expr Sin(Expr expr) {
        return Fn.apply("sin", expr);
    }

    public static Expr Sin(Double d) {
        return Fn.apply("sin", new Value.DoubleV(d));
    }

    public static Expr Sinh(Expr expr) {
        return Fn.apply("sinh", expr);
    }

    public static Expr Sinh(Double d) {
        return Fn.apply("sinh", new Value.DoubleV(d));
    }

    public static Expr Sqrt(Expr expr) {
        return Fn.apply("sqrt", expr);
    }

    public static Expr Sqrt(Double d) {
        return Fn.apply("sqrt", new Value.DoubleV(d));
    }

    public static Expr Subtract(List<? extends Expr> list) {
        return Fn.apply("subtract", Language.varargs(list));
    }

    public static Expr Subtract(Expr ... exprArray) {
        return Language.Subtract(Arrays.asList(exprArray));
    }

    public static Expr Tan(Expr expr) {
        return Fn.apply("tan", expr);
    }

    public static Expr Tan(Double d) {
        return Fn.apply("tan", new Value.DoubleV(d));
    }

    public static Expr Tanh(Expr expr) {
        return Fn.apply("tanh", expr);
    }

    public static Expr Tanh(Double d) {
        return Fn.apply("tanh", new Value.DoubleV(d));
    }

    public static Expr Trunc(Expr expr, Expr expr2) {
        return Fn.apply("trunc", expr, "precision", expr2);
    }

    public static Expr Trunc(Double d, Expr expr) {
        return Fn.apply("trunc", new Value.DoubleV(d), "precision", expr);
    }

    public static Expr Trunc(Long l, Expr expr) {
        return Fn.apply("trunc", new Value.LongV(l), "precision", expr);
    }

    public static Expr Trunc(Expr expr, Long l) {
        return Fn.apply("trunc", expr, "precision", new Value.LongV(l));
    }

    public static Expr Trunc(Double d, Long l) {
        return Fn.apply("trunc", new Value.DoubleV(d), "precision", new Value.LongV(l));
    }

    public static Expr Trunc(Long l, Long l2) {
        return Fn.apply("trunc", new Value.LongV(l), "precision", new Value.LongV(l2));
    }

    public static Expr Trunc(Expr expr) {
        return Fn.apply("trunc", expr);
    }

    public static Expr Trunc(Double d) {
        return Fn.apply("trunc", new Value.DoubleV(d));
    }

    public static Expr Count(Expr expr) {
        return Fn.apply("count", expr);
    }

    public static Expr Sum(Expr expr) {
        return Fn.apply("sum", expr);
    }

    public static Expr Mean(Expr expr) {
        return Fn.apply("mean", expr);
    }

    public static Expr All(Expr expr) {
        return Fn.apply("all", expr);
    }

    public static Expr Any(Expr expr) {
        return Fn.apply("any", expr);
    }

    public static Expr LT(List<? extends Expr> list) {
        return Fn.apply("lt", Language.varargs(list));
    }

    public static Expr LT(Expr ... exprArray) {
        return Language.LT(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr LTE(List<? extends Expr> list) {
        return Fn.apply("lte", Language.varargs(list));
    }

    public static Expr LTE(Expr ... exprArray) {
        return Language.LTE(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr GT(List<? extends Expr> list) {
        return Fn.apply("gt", Language.varargs(list));
    }

    public static Expr GT(Expr ... exprArray) {
        return Language.GT(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr GTE(List<? extends Expr> list) {
        return Fn.apply("gte", Language.varargs(list));
    }

    public static Expr GTE(Expr ... exprArray) {
        return Language.GTE(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr And(List<? extends Expr> list) {
        return Fn.apply("and", Language.varargs(list));
    }

    public static Expr And(Expr ... exprArray) {
        return Language.And(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Or(List<? extends Expr> list) {
        return Fn.apply("or", Language.varargs(list));
    }

    public static Expr Or(Expr ... exprArray) {
        return Language.Or(Collections.unmodifiableList(Arrays.asList(exprArray)));
    }

    public static Expr Not(Expr expr) {
        return Fn.apply("not", expr);
    }

    public static Expr ToString(Expr expr) {
        return Fn.apply("to_string", expr);
    }

    public static Expr ToNumber(Expr expr) {
        return Fn.apply("to_number", expr);
    }

    public static Expr ToDouble(Expr expr) {
        return Fn.apply("to_double", expr);
    }

    public static Expr ToDouble(String string) {
        return Language.ToDouble(Language.Value(string));
    }

    public static Expr ToDouble(double d) {
        return Language.ToDouble(Language.Value(d));
    }

    public static Expr ToDouble(long l) {
        return Language.ToDouble(Language.Value(l));
    }

    public static Expr ToInteger(Expr expr) {
        return Fn.apply("to_integer", expr);
    }

    public static Expr ToInteger(String string) {
        return Language.ToInteger(Language.Value(string));
    }

    public static Expr ToInteger(double d) {
        return Language.ToInteger(Language.Value(d));
    }

    public static Expr ToInteger(long l) {
        return Language.ToInteger(Language.Value(l));
    }

    public static Expr ToTime(Expr expr) {
        return Fn.apply("to_time", expr);
    }

    public static Expr ToSeconds(Expr expr) {
        return Fn.apply("to_seconds", expr);
    }

    public static Expr ToMillis(Expr expr) {
        return Fn.apply("to_millis", expr);
    }

    public static Expr ToMicros(Expr expr) {
        return Fn.apply("to_micros", expr);
    }

    public static Expr DayOfMonth(Expr expr) {
        return Fn.apply("day_of_month", expr);
    }

    public static Expr DayOfWeek(Expr expr) {
        return Fn.apply("day_of_week", expr);
    }

    public static Expr DayOfYear(Expr expr) {
        return Fn.apply("day_of_year", expr);
    }

    public static Expr Year(Expr expr) {
        return Fn.apply("year", expr);
    }

    public static Expr Month(Expr expr) {
        return Fn.apply("month", expr);
    }

    public static Expr Hour(Expr expr) {
        return Fn.apply("hour", expr);
    }

    public static Expr Minute(Expr expr) {
        return Fn.apply("minute", expr);
    }

    public static Expr Second(Expr expr) {
        return Fn.apply("second", expr);
    }

    public static Expr ToDate(Expr expr) {
        return Fn.apply("to_date", expr);
    }

    public static Expr Merge(Expr expr, Expr expr2) {
        return Fn.apply("merge", expr, "with", expr2);
    }

    public static Expr Merge(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("merge", expr, "with", expr2, "lambda", expr3);
    }

    public static Expr ToObject(Expr expr) {
        return Fn.apply("to_object", expr);
    }

    public static Expr ToArray(Expr expr) {
        return Fn.apply("to_array", expr);
    }

    public static Expr IsNumber(Expr expr) {
        return Fn.apply("is_number", expr);
    }

    public static Expr IsDouble(Expr expr) {
        return Fn.apply("is_double", expr);
    }

    public static Expr IsInteger(Expr expr) {
        return Fn.apply("is_integer", expr);
    }

    public static Expr IsBoolean(Expr expr) {
        return Fn.apply("is_boolean", expr);
    }

    public static Expr IsNull(Expr expr) {
        return Fn.apply("is_null", expr);
    }

    public static Expr IsBytes(Expr expr) {
        return Fn.apply("is_bytes", expr);
    }

    public static Expr IsTimestamp(Expr expr) {
        return Fn.apply("is_timestamp", expr);
    }

    public static Expr IsDate(Expr expr) {
        return Fn.apply("is_date", expr);
    }

    public static Expr IsString(Expr expr) {
        return Fn.apply("is_string", expr);
    }

    public static Expr IsArray(Expr expr) {
        return Fn.apply("is_array", expr);
    }

    public static Expr IsObject(Expr expr) {
        return Fn.apply("is_object", expr);
    }

    public static Expr IsRef(Expr expr) {
        return Fn.apply("is_ref", expr);
    }

    public static Expr IsSet(Expr expr) {
        return Fn.apply("is_set", expr);
    }

    public static Expr IsDoc(Expr expr) {
        return Fn.apply("is_doc", expr);
    }

    public static Expr IsLambda(Expr expr) {
        return Fn.apply("is_lambda", expr);
    }

    public static Expr IsCollection(Expr expr) {
        return Fn.apply("is_collection", expr);
    }

    public static Expr IsDatabase(Expr expr) {
        return Fn.apply("is_database", expr);
    }

    public static Expr IsIndex(Expr expr) {
        return Fn.apply("is_index", expr);
    }

    public static Expr IsFunction(Expr expr) {
        return Fn.apply("is_function", expr);
    }

    public static Expr IsKey(Expr expr) {
        return Fn.apply("is_key", expr);
    }

    public static Expr IsToken(Expr expr) {
        return Fn.apply("is_token", expr);
    }

    public static Expr IsCredentials(Expr expr) {
        return Fn.apply("is_credentials", expr);
    }

    public static Expr IsRole(Expr expr) {
        return Fn.apply("is_role", expr);
    }

    public static final class Path {
        private final List<Expr> segments;

        private Path() {
            this(Collections.emptyList());
        }

        private Path(List<Expr> list) {
            this.segments = list;
        }

        public Path at(String ... stringArray) {
            ArrayList<Expr> arrayList = new ArrayList<Expr>(this.segments.size() + stringArray.length);
            arrayList.addAll(this.segments);
            for (String string : stringArray) {
                arrayList.add(Language.Value(string));
            }
            return new Path(Collections.unmodifiableList(arrayList));
        }

        public Path at(int ... nArray) {
            ArrayList<Expr> arrayList = new ArrayList<Expr>(this.segments.size() + nArray.length);
            arrayList.addAll(this.segments);
            for (int n : nArray) {
                arrayList.add(Language.Value(n));
            }
            return new Path(Collections.unmodifiableList(arrayList));
        }
    }

    public static final class LetBinding {
        private final Expr bindings;

        private LetBinding(List<Expr> list) {
            this.bindings = Fn.apply(list);
        }

        public Expr in(Expr expr) {
            return Fn.apply("let", this.bindings, "in", expr);
        }
    }

    public static enum Normalizer {
        NFD("NFD"),
        NFC("NFC"),
        NFKD("NFKD"),
        NFKC("NFKC"),
        NFKCCaseFold("NFKCCaseFold");

        private final Expr value;

        private Normalizer(String string2) {
            this.value = Language.Value(string2);
        }
    }

    public static enum Action {
        CREATE("create"),
        DELETE("delete");

        private final Expr value;

        private Action(String string2) {
            this.value = Language.Value(string2);
        }
    }

    public static enum TimeUnit {
        DAY("day"),
        HALF_DAY("half day"),
        HOUR("hour"),
        MINUTE("minute"),
        SECOND("second"),
        MILLISECOND("millisecond"),
        MICROSECOND("microsecond"),
        NANOSECOND("nanosecond");

        private final Expr value;

        private TimeUnit(String string2) {
            this.value = Language.Value(string2);
        }
    }
}

