/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.errors;

import com.faunadb.client.HttpResponses;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class FaunaException
extends RuntimeException {
    private final Optional<HttpResponses.QueryErrorResponse> response;

    public FaunaException(HttpResponses.QueryErrorResponse queryErrorResponse) {
        super(FaunaException.constructErrorMessage(queryErrorResponse.errors()));
        this.response = Optional.of(queryErrorResponse);
    }

    public FaunaException(String string) {
        super(string);
        this.response = Optional.empty();
    }

    public FaunaException(String string, Throwable throwable) {
        super(string, throwable);
        this.response = Optional.empty();
    }

    public List<HttpResponses.QueryError> errors() {
        if (this.response.isPresent()) {
            return this.response.get().errors();
        }
        return Collections.emptyList();
    }

    public int status() {
        if (this.response.isPresent()) {
            return this.response.get().status();
        }
        return 0;
    }

    protected static String constructErrorMessage(List<HttpResponses.QueryError> list) {
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        for (HttpResponses.QueryError queryError : list) {
            arrayList.add((CallSite)((Object)(queryError.code() + ": " + queryError.description())));
        }
        return String.join((CharSequence)", ", arrayList);
    }
}

