/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HttpResponses {

    public static class QueryErrorResponse {
        private final int status;
        private final List<QueryError> errors;

        public static QueryErrorResponse create(int n, List<QueryError> list) {
            return new QueryErrorResponse(n, Collections.unmodifiableList(list));
        }

        public QueryErrorResponse(int n, List<QueryError> list) {
            this.status = n;
            this.errors = list;
        }

        public int status() {
            return this.status;
        }

        public List<QueryError> errors() {
            return this.errors;
        }
    }

    @JsonDeserialize(using=Codec.QueryErrorDeserializer.class)
    public static class QueryError {
        private final List<String> position;
        private final String code;
        private final String description;
        private final List<ValidationFailure> failures;

        public QueryError(List<String> list, String string, String string2, List<ValidationFailure> list2) {
            this.position = Collections.unmodifiableList(list);
            this.code = string;
            this.description = string2;
            this.failures = Collections.unmodifiableList(list2);
        }

        public List<String> position() {
            return this.position;
        }

        public String code() {
            return this.code;
        }

        public String description() {
            return this.description;
        }

        public List<ValidationFailure> failures() {
            return this.failures;
        }
    }

    @JsonDeserialize(using=Codec.ValidationFailureDeserializer.class)
    public static class ValidationFailure {
        private final List<String> field;
        private final String code;
        private final String description;

        public ValidationFailure(List<String> list, String string, String string2) {
            this.field = Collections.unmodifiableList(list);
            this.code = string;
            this.description = string2;
        }

        public String code() {
            return this.code;
        }

        public String description() {
            return this.description;
        }

        public List<String> field() {
            return this.field;
        }
    }

    static class Codec {
        Codec() {
        }

        static class QueryErrorDeserializer
        extends JsonDeserializer<QueryError> {
            QueryErrorDeserializer() {
            }

            public QueryError deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
                JsonNode jsonNode = (JsonNode)objectMapper.readTree(jsonParser);
                TypeFactory typeFactory = deserializationContext.getTypeFactory();
                List list = jsonNode.has("position") ? (List)objectMapper.convertValue((Object)jsonNode.get("position"), (JavaType)typeFactory.constructCollectionType(ArrayList.class, String.class)) : Collections.emptyList();
                if (!jsonNode.has("code")) {
                    throw new JsonParseException(jsonParser, "Cannot deserialize QueryError: no 'code' field.", jsonParser.getTokenLocation());
                }
                String string = jsonNode.get("code").asText();
                if (!jsonNode.has("description")) {
                    throw new JsonParseException(jsonParser, "Cannot deserialize QueryError: no 'description' field.", jsonParser.getTokenLocation());
                }
                String string2 = jsonNode.get("description").asText();
                List list2 = jsonNode.has("failures") ? (List)objectMapper.convertValue((Object)jsonNode.get("failures"), (JavaType)typeFactory.constructCollectionType(ArrayList.class, ValidationFailure.class)) : Collections.emptyList();
                return new QueryError(list, string, string2, list2);
            }
        }

        static class ValidationFailureDeserializer
        extends JsonDeserializer<ValidationFailure> {
            ValidationFailureDeserializer() {
            }

            public ValidationFailure deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                String string;
                ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
                TypeFactory typeFactory = deserializationContext.getTypeFactory();
                JsonNode jsonNode = (JsonNode)objectMapper.readTree(jsonParser);
                if (!jsonNode.has("field")) {
                    throw new JsonParseException(jsonParser, "Cannot deserialize ValidationFailure: no 'field' field.", jsonParser.getTokenLocation());
                }
                List list = (List)objectMapper.convertValue((Object)jsonNode.get("field"), (JavaType)typeFactory.constructCollectionType(ArrayList.class, String.class));
                if (!jsonNode.has("code")) {
                    throw new JsonParseException(jsonParser, "Cannot deserialize ValidationFailure: no 'code' field.", jsonParser.getTokenLocation());
                }
                String string2 = jsonNode.get("code").asText();
                if (jsonNode.has("description")) {
                    string = jsonNode.get("description").asText();
                } else if (jsonNode.has("reason")) {
                    string = jsonNode.get("reason").asText();
                } else {
                    throw new JsonParseException(jsonParser, "Cannot deserialize ValidationFailure: no 'description' field.", jsonParser.getTokenLocation());
                }
                return new ValidationFailure(list, string2, string);
            }
        }
    }
}

