/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.faunadb.client.HttpResponses;
import com.faunadb.client.errors.BadRequestException;
import com.faunadb.client.errors.InternalException;
import com.faunadb.client.errors.NotFoundException;
import com.faunadb.client.errors.PermissionDeniedException;
import com.faunadb.client.errors.TransactionContentionException;
import com.faunadb.client.errors.UnauthorizedException;
import com.faunadb.client.errors.UnavailableException;
import com.faunadb.client.errors.UnknownException;
import com.faunadb.client.query.Expr;
import com.faunadb.client.query.Language;
import com.faunadb.client.streaming.BodyValueFlowProcessor;
import com.faunadb.client.streaming.EventField;
import com.faunadb.client.streaming.SnapshotEventFlowProcessor;
import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Field;
import com.faunadb.client.types.MetricsResponse;
import com.faunadb.client.types.Value;
import com.faunadb.common.Connection;
import com.faunadb.common.http.ResponseBodyStringProcessor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FaunaClient {
    private final ObjectMapper json = new ObjectMapper().registerModule((Module)new Jdk8Module());
    private final Connection connection;

    public static Builder builder() {
        return new Builder();
    }

    private FaunaClient(Connection connection) {
        this.connection = connection;
    }

    public FaunaClient newSessionClient(String string) {
        return new FaunaClient(this.connection.newSessionConnection(string));
    }

    public CompletableFuture<Value> query(Expr expr) {
        return this.query(expr, Optional.empty());
    }

    public CompletableFuture<Value> query(Expr expr, Duration duration) {
        return this.query(expr, Optional.ofNullable(duration));
    }

    public CompletableFuture<Value> query(Expr expr, Optional<Duration> optional) {
        return this.performRequest(this.json.valueToTree((Object)expr), optional);
    }

    public CompletableFuture<MetricsResponse> queryWithMetrics(Expr expr, Optional<Duration> optional) {
        return this.performRequestWithMetrics(this.json.valueToTree((Object)expr), optional);
    }

    public CompletableFuture<List<Value>> query(Expr ... exprArray) {
        return this.query(Arrays.asList(exprArray));
    }

    public CompletableFuture<List<Value>> query(List<? extends Expr> list) {
        return this.query(list, Optional.empty());
    }

    public CompletableFuture<List<Value>> query(List<? extends Expr> list, Duration duration) {
        return this.query(list, Optional.ofNullable(duration));
    }

    public CompletableFuture<List<Value>> query(List<? extends Expr> list, Optional<Duration> optional) {
        return this.performRequest(this.json.valueToTree(list), optional).thenApply(value -> value.collect(Field.as(Codec.VALUE)));
    }

    public void syncLastTxnTime(long l) {
        this.connection.syncLastTxnTime(l);
    }

    public long getLastTxnTime() {
        return this.connection.getLastTxnTime();
    }

    private Value handleResponse(HttpResponse<String> httpResponse) {
        try {
            this.handleQueryErrors(httpResponse.statusCode(), httpResponse.body());
            JsonNode jsonNode = this.parseResponseBody(httpResponse.body());
            JsonNode jsonNode2 = jsonNode.get("resource");
            if (jsonNode2 == null) {
                throw new IllegalArgumentException("Invalid JSON.");
            }
            if (jsonNode2 instanceof NullNode) {
                return Value.NullV.NULL;
            }
            return (Value)this.json.treeToValue((TreeNode)jsonNode2, Value.class);
        }
        catch (JsonProcessingException | IllegalArgumentException throwable) {
            throw new AssertionError((Object)throwable);
        }
    }

    private MetricsResponse handleResponseWithMetrics(HttpResponse<String> httpResponse) {
        HashMap<MetricsResponse.Metrics, String> hashMap = new HashMap<MetricsResponse.Metrics, String>();
        MetricsResponse.Metrics.vals().forEach(metrics -> httpResponse.headers().firstValue(metrics.getMetric()).ifPresent(string -> hashMap.put((MetricsResponse.Metrics)((Object)metrics), (String)string)));
        Value value = this.handleResponse(httpResponse);
        return MetricsResponse.of(value, hashMap);
    }

    private CompletableFuture<Value> performRequest(JsonNode jsonNode, Optional<Duration> optional) {
        return this.handleNetworkExceptions((CompletableFuture)this.connection.post("", jsonNode, optional).thenApply(this::handleResponse));
    }

    private CompletableFuture<MetricsResponse> performRequestWithMetrics(JsonNode jsonNode, Optional<Duration> optional) {
        return this.handleNetworkExceptions((CompletableFuture)this.connection.post("", jsonNode, optional).thenApply(this::handleResponseWithMetrics));
    }

    public CompletableFuture<Flow.Publisher<Value>> stream(Expr expr) {
        return this.performStreamRequest(this.json.valueToTree((Object)expr), List.of());
    }

    public CompletableFuture<Flow.Publisher<Value>> stream(Expr expr, List<EventField> list, boolean bl) {
        return this.performStreamRequest(this.json.valueToTree((Object)expr), list).thenApply(publisher -> {
            if (bl) {
                Function<Expr, CompletableFuture<Value>> function = expr -> this.query(Language.Get(expr));
                SnapshotEventFlowProcessor snapshotEventFlowProcessor = new SnapshotEventFlowProcessor(expr, function);
                publisher.subscribe(snapshotEventFlowProcessor);
                return snapshotEventFlowProcessor;
            }
            return publisher;
        });
    }

    private CompletableFuture<Flow.Publisher<Value>> performStreamRequest(JsonNode jsonNode, List<EventField> list) {
        Map map = Map.of("fields", list.stream().map(EventField::value).collect(Collectors.toList()));
        try {
            return this.handleNetworkExceptions((CompletableFuture)this.connection.performStreamRequest("POST", "stream", jsonNode, map).thenCompose(httpResponse -> {
                CompletableFuture<BodyValueFlowProcessor> completableFuture = new CompletableFuture<BodyValueFlowProcessor>();
                if (httpResponse.statusCode() < 300) {
                    BodyValueFlowProcessor bodyValueFlowProcessor = new BodyValueFlowProcessor(this.json, this.connection);
                    ((Flow.Publisher)httpResponse.body()).subscribe(bodyValueFlowProcessor);
                    completableFuture.complete(bodyValueFlowProcessor);
                } else {
                    ResponseBodyStringProcessor.consumeBody((HttpResponse)httpResponse).thenCompose(string -> {
                        try {
                            this.handleQueryErrors(httpResponse.statusCode(), (String)string);
                        }
                        catch (Exception exception) {
                            completableFuture.completeExceptionally(exception);
                        }
                        return completableFuture;
                    });
                }
                return completableFuture;
            }));
        }
        catch (Exception exception) {
            CompletableFuture<Flow.Publisher<Value>> completableFuture = new CompletableFuture<Flow.Publisher<Value>>();
            completableFuture.completeExceptionally(exception);
            return completableFuture;
        }
    }

    private void handleQueryErrors(int n, String string) {
        if (n >= 300) {
            try {
                ArrayList<HttpResponses.QueryError> arrayList = new ArrayList<HttpResponses.QueryError>();
                ArrayNode arrayNode = (ArrayNode)this.parseResponseBody(string).get("errors");
                if (arrayNode != null) {
                    for (JsonNode jsonNode : arrayNode) {
                        arrayList.add((HttpResponses.QueryError)this.json.treeToValue((TreeNode)jsonNode, HttpResponses.QueryError.class));
                    }
                }
                HttpResponses.QueryErrorResponse queryErrorResponse = HttpResponses.QueryErrorResponse.create(n, arrayList);
                switch (n) {
                    case 400: {
                        throw new BadRequestException(queryErrorResponse);
                    }
                    case 401: {
                        throw new UnauthorizedException(queryErrorResponse);
                    }
                    case 403: {
                        throw new PermissionDeniedException(queryErrorResponse);
                    }
                    case 404: {
                        throw new NotFoundException(queryErrorResponse);
                    }
                    case 409: {
                        throw new TransactionContentionException(queryErrorResponse);
                    }
                    case 500: {
                        throw new InternalException(queryErrorResponse);
                    }
                    case 503: {
                        throw new UnavailableException(queryErrorResponse);
                    }
                }
                throw new UnknownException(queryErrorResponse);
            }
            catch (JsonProcessingException | IllegalArgumentException throwable) {
                if (n == 503) {
                    throw new UnavailableException("Service Unavailable: Unparseable response.", throwable);
                }
                throw new UnknownException("Unparseable service " + n + " response.", throwable);
            }
        }
    }

    private <V> CompletableFuture<V> handleNetworkExceptions(CompletableFuture<V> completableFuture) {
        return completableFuture.whenComplete((object, throwable) -> {
            if (throwable instanceof ConnectException || throwable instanceof TimeoutException) {
                throw new UnavailableException(throwable.getMessage(), (Throwable)throwable);
            }
            if (throwable instanceof CompletionException && throwable.getCause() instanceof IOException && throwable.getMessage().contains("header parser received no bytes")) {
                throw new UnavailableException(throwable.getMessage(), (Throwable)throwable);
            }
            if (throwable instanceof CompletionException && throwable.getCause() instanceof IOException && throwable.getMessage().contains("too many concurrent streams")) {
                throw new BadRequestException("the maximum number of streams has been reached for this client");
            }
        });
    }

    private JsonNode parseResponseBody(String string) throws JsonProcessingException, IllegalArgumentException {
        JsonNode jsonNode = this.json.readTree(string);
        if (jsonNode == null) {
            throw new IllegalArgumentException("Invalid JSON.");
        }
        return jsonNode;
    }

    public static final class Builder {
        private String secret;
        private URL endpoint;
        private MetricRegistry registry;
        private Duration queryTimeout;
        private String userAgent;
        private boolean checkNewVersion = true;
        private Map<String, String> customHeaders;

        private Builder() {
        }

        public Builder withSecret(String string) {
            this.secret = string;
            return this;
        }

        public Builder withEndpoint(String string) throws MalformedURLException {
            this.endpoint = new URL(string);
            return this;
        }

        public Builder withMetrics(MetricRegistry metricRegistry) {
            this.registry = metricRegistry;
            return this;
        }

        public Builder withQueryTimeout(Duration duration) {
            this.queryTimeout = duration;
            return this;
        }

        public Builder withUserAgent(String string) {
            this.userAgent = string;
            return this;
        }

        public Builder withCheckNewVersion(boolean bl) {
            this.checkNewVersion = bl;
            return this;
        }

        public Builder withCustomHeaders(Map<String, String> map) {
            this.customHeaders = map;
            return this;
        }

        public FaunaClient build() {
            Connection.Builder builder = Connection.builder().withAuthToken(this.secret).withFaunaRoot(this.endpoint).withQueryTimeout(this.queryTimeout).withUserAgent(this.userAgent).withJvmDriver(Connection.JvmDriver.JAVA).withCheckNewDriverVersion(this.checkNewVersion);
            if (this.registry != null) {
                builder.withMetrics(this.registry);
            }
            if (this.customHeaders != null) {
                builder.withCustomHeaders(this.customHeaders);
            }
            return new FaunaClient(builder.build());
        }
    }
}

