/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.common.http;

import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;

public class ResponseBodyStringProcessor {
    public static CompletableFuture<String> consumeBody(HttpResponse<Flow.Publisher<List<ByteBuffer>>> httpResponse) {
        final CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        Flow.Subscriber<List<ByteBuffer>> subscriber = new Flow.Subscriber<List<ByteBuffer>>(){
            Flow.Subscription subscription = null;
            List<ByteBuffer> captured = new ArrayList<ByteBuffer>();

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(List<ByteBuffer> list) {
                this.captured.addAll(list);
                this.subscription.request(1L);
            }

            @Override
            public void onError(Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }

            @Override
            public void onComplete() {
                String string = this.captured.stream().map(byteBuffer -> StandardCharsets.UTF_8.decode((ByteBuffer)byteBuffer).toString()).collect(Collectors.joining());
                completableFuture.complete(string);
            }
        };
        httpResponse.body().subscribe(subscriber);
        return completableFuture;
    }
}

