/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import scala.collection.Map;
import scala.collection.Seq;

public class UntypedScalaObjectDeserializer
extends UntypedObjectDeserializer {
    private JsonDeserializer<Object> _mapDeser;
    private JsonDeserializer<Object> _listDeser;

    public UntypedScalaObjectDeserializer() {
        super(null, null);
    }

    public void resolve(DeserializationContext ctxt) {
        super.resolve(ctxt);
        JavaType anyRef = ctxt.constructType(Object.class);
        JavaType string = ctxt.constructType(String.class);
        DeserializerFactory factory = ctxt.getFactory();
        TypeFactory tf = ctxt.getTypeFactory();
        this._mapDeser = ctxt.findRootValueDeserializer(factory.mapAbstractType(ctxt.getConfig(), (JavaType)tf.constructMapLikeType(Map.class, string, anyRef)));
        this._listDeser = ctxt.findRootValueDeserializer(factory.mapAbstractType(ctxt.getConfig(), (JavaType)tf.constructCollectionLikeType(Seq.class, anyRef)));
    }

    public Object mapArray(JsonParser jp, DeserializationContext ctxt) {
        return ctxt.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY) ? this.mapArrayToArray(jp, ctxt) : this._listDeser.deserialize(jp, ctxt);
    }

    public Object mapObject(JsonParser jp, DeserializationContext ctxt) {
        return this._mapDeser.deserialize(jp, ctxt);
    }
}

