/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.stree;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsMissing;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class JrsObject
extends JrsValue {
    private final Map<String, JrsValue> _values;

    public JrsObject() {
        this(Collections.emptyMap());
    }

    public JrsObject(Map<String, JrsValue> map) {
        this._values = map;
    }

    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    public int size() {
        return this._values.size();
    }

    public boolean isValueNode() {
        return false;
    }

    public boolean isContainerNode() {
        return true;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public Iterator<String> fieldNames() {
        return this._values.keySet().iterator();
    }

    @Override
    public JrsValue get(int n) {
        return null;
    }

    @Override
    public JrsValue get(String string) {
        return this._values.get(string);
    }

    @Override
    public JrsValue path(int n) {
        return JrsMissing.instance();
    }

    @Override
    public JrsValue path(String string) {
        JrsValue jrsValue = this._values.get(string);
        return jrsValue == null ? JrsMissing.instance() : jrsValue;
    }

    @Override
    protected JrsValue _at(JsonPointer jsonPointer) {
        String string = jsonPointer.getMatchingProperty();
        return this.get(string);
    }

    public Iterator<Map.Entry<String, JrsValue>> fields() {
        if (this._values.isEmpty()) {
            return this._values.entrySet().iterator();
        }
        return this._values.entrySet().iterator();
    }

    @Override
    protected void write(JsonGenerator jsonGenerator, JacksonJrsTreeCodec jacksonJrsTreeCodec) throws IOException {
        jsonGenerator.writeStartObject();
        if (!this._values.isEmpty()) {
            for (Map.Entry<String, JrsValue> entry : this._values.entrySet()) {
                jsonGenerator.writeFieldName(entry.getKey());
                jacksonJrsTreeCodec.writeTree(jsonGenerator, entry.getValue());
            }
        }
        jsonGenerator.writeEndObject();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JrsObject jrsObject = (JrsObject)object;
        return this._values != null ? this._values.equals(jrsObject._values) : jrsObject._values == null;
    }

    public int hashCode() {
        return this._values != null ? this._values.hashCode() : 0;
    }
}

