/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.yaml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.jaxrs.base.ProviderBase;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.cfg.MapperConfiguratorBase;
import com.fasterxml.jackson.jaxrs.yaml.PackageVersion;
import com.fasterxml.jackson.jaxrs.yaml.YAMLEndpointConfig;
import com.fasterxml.jackson.jaxrs.yaml.YAMLMapperConfigurator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"application/yaml", "*/*"})
public class JacksonYAMLProvider
extends ProviderBase<JacksonYAMLProvider, YAMLMapper, YAMLEndpointConfig, YAMLMapperConfigurator> {
    public static final Annotations[] BASIC_ANNOTATIONS = new Annotations[]{Annotations.JACKSON};
    @Context
    protected Providers _providers;

    public JacksonYAMLProvider() {
        this((YAMLMapper)null, BASIC_ANNOTATIONS);
    }

    public JacksonYAMLProvider(Annotations ... annotationsToUse) {
        this((YAMLMapper)null, annotationsToUse);
    }

    public JacksonYAMLProvider(YAMLMapper mapper) {
        this(mapper, BASIC_ANNOTATIONS);
    }

    public JacksonYAMLProvider(YAMLMapper mapper, Annotations[] annotationsToUse) {
        super((MapperConfiguratorBase)new YAMLMapperConfigurator(mapper, annotationsToUse));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected YAMLEndpointConfig _configForReading(ObjectReader reader, Annotation[] annotations) {
        return YAMLEndpointConfig.forReading(reader, annotations);
    }

    protected YAMLEndpointConfig _configForWriting(ObjectWriter writer, Annotation[] annotations) {
        return YAMLEndpointConfig.forWriting(writer, annotations);
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "yaml".equalsIgnoreCase(subtype) || subtype.endsWith("+yaml");
        }
        return true;
    }

    public YAMLMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
        YAMLMapper m = ((YAMLMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        if (m == null && (m = (YAMLMapper)this._locateMapperViaProvider(type, mediaType, YAMLMapper.class, this._providers)) == null) {
            m = ((YAMLMapperConfigurator)this._mapperConfig).getDefaultMapper();
        }
        return m;
    }

    protected JsonParser _createParser(ObjectReader reader, InputStream rawStream) throws IOException {
        PushbackInputStream wrappedStream = new PushbackInputStream(rawStream);
        int firstByte = wrappedStream.read();
        if (firstByte == -1) {
            return null;
        }
        wrappedStream.unread(firstByte);
        return reader.getFactory().createParser((InputStream)wrappedStream);
    }
}

