/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.LazyAssociatableConnectionManager;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import org.tranql.connector.DissociatableConnectionHandle;
import org.tranql.connector.DissociatableConnectionHandleFactory;
import org.tranql.connector.UserPasswordHandleFactoryRequestInfo;
import org.tranql.connector.jdbc.ConnectionHandle;

public class TranqlDataSource
implements DataSource,
Referenceable,
jakarta.resource.Referenceable {
    private final ManagedConnectionFactory mcf;
    private final ConnectionManager cm;
    private final UserPasswordHandleFactoryRequestInfo<Connection, ConnectionHandle> containerRequestInfo;
    private Reference ref;
    private final DissociatableConnectionHandleFactory<Connection, ConnectionHandle> handleFactory;

    public TranqlDataSource(ManagedConnectionFactory mcf, ConnectionManager connectionManager) {
        this.mcf = mcf;
        this.cm = connectionManager;
        this.handleFactory = new HandleFactory(this.cm, mcf);
        this.containerRequestInfo = new UserPasswordHandleFactoryRequestInfo<Connection, ConnectionHandle>(this.handleFactory, null, null);
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this.cm.allocateConnection(this.mcf, this.containerRequestInfo);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw (SQLException)new SQLException().initCause(e);
        }
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        try {
            UserPasswordHandleFactoryRequestInfo<Connection, ConnectionHandle> cri = new UserPasswordHandleFactoryRequestInfo<Connection, ConnectionHandle>(this.handleFactory, user, password);
            return (Connection)this.cm.allocateConnection(this.mcf, cri);
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw (SQLException)new SQLException().initCause(e);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        try {
            return this.mcf.getLogWriter();
        }
        catch (ResourceException e) {
            throw (SQLException)new SQLException().initCause(e);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new UnsupportedOperationException("Cannot set loginTimeout on a connection factory");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException("Cannot set logWriter on a connection factory");
    }

    @Override
    public Reference getReference() throws NamingException {
        if (this.ref == null) {
            this.ref = new SelfReference(this);
        }
        return this.ref;
    }

    public void setReference(Reference reference) {
        this.ref = reference;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    private static class HandleFactory
    implements DissociatableConnectionHandleFactory<Connection, ConnectionHandle> {
        private final LazyAssociatableConnectionManager connectionManager;
        private final ManagedConnectionFactory managedConnectionFactory;

        HandleFactory(ConnectionManager connectionManager, ManagedConnectionFactory managedConnectionFactory) {
            this.connectionManager = connectionManager instanceof LazyAssociatableConnectionManager ? (LazyAssociatableConnectionManager)connectionManager : null;
            this.managedConnectionFactory = managedConnectionFactory;
        }

        @Override
        public DissociatableConnectionHandle<Connection, ConnectionHandle> newHandle(ConnectionRequestInfo connectionRequestInfo) {
            return new ConnectionHandle(this.connectionManager, this.managedConnectionFactory, connectionRequestInfo);
        }
    }

    private static class SelfReference
    extends Reference {
        private static final long serialVersionUID = -354056139412012348L;
        private final TranqlDataSource self;
        private static final Enumeration<RefAddr> EMPTY_ENUMERATION = new Enumeration<RefAddr>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public RefAddr nextElement() {
                return null;
            }
        };

        public SelfReference(TranqlDataSource self) {
            super("");
            this.self = self;
        }

        @Override
        public String getClassName() {
            return TranqlDataSource.class.getName();
        }

        @Override
        public String getFactoryClassName() {
            return SelfObjectFactory.class.getName();
        }

        @Override
        public String getFactoryClassLocation() {
            return null;
        }

        @Override
        public RefAddr get(String s) {
            return null;
        }

        @Override
        public RefAddr get(int i) {
            return null;
        }

        @Override
        public Enumeration<RefAddr> getAll() {
            return EMPTY_ENUMERATION;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void add(RefAddr refAddr) {
            throw new UnsupportedOperationException("no ref addr");
        }

        @Override
        public void add(int i, RefAddr refAddr) {
            throw new UnsupportedOperationException("no ref addr");
        }

        public TranqlDataSource getContent() {
            return this.self;
        }
    }

    public static class SelfObjectFactory
    implements ObjectFactory {
        @Override
        public Object getObjectInstance(Object o, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
            if (o instanceof SelfReference) {
                return ((SelfReference)o).getContent();
            }
            return null;
        }
    }
}

