/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.tranql.connector.jdbc.ConnectionHandle;
import org.tranql.connector.jdbc.StatementHandle;

public class ResultSetHandle
implements ResultSet {
    protected final StatementHandle<?> s;
    protected final ResultSet rs;

    public ResultSetHandle(StatementHandle<?> s, ResultSet rs) {
        this.s = s;
        this.rs = rs;
    }

    private void connectionError(SQLException e) {
        ((ConnectionHandle)this.s.getConnection()).connectionError(e);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.s;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        try {
            return this.rs.absolute(row);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this.rs.afterLast();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this.rs.beforeFirst();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this.rs.cancelRowUpdates();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.rs.clearWarnings();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.rs.close();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            this.rs.deleteRow();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        try {
            return this.rs.findColumn(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            return this.rs.first();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        try {
            return this.rs.getArray(colName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Array getArray(int i) throws SQLException {
        try {
            return this.rs.getArray(i);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            return this.rs.getAsciiStream(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        try {
            return this.rs.getAsciiStream(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            return this.rs.getBigDecimal(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            return this.rs.getBigDecimal(columnIndex, scale);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        try {
            return this.rs.getBigDecimal(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        try {
            return this.rs.getBigDecimal(columnName, scale);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            return this.rs.getBinaryStream(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        try {
            return this.rs.getBinaryStream(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        try {
            return this.rs.getBlob(colName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        try {
            return this.rs.getBlob(i);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            return this.rs.getBoolean(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        try {
            return this.rs.getBoolean(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try {
            return this.rs.getByte(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        try {
            return this.rs.getByte(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            return this.rs.getBytes(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        try {
            return this.rs.getBytes(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            return this.rs.getCharacterStream(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        try {
            return this.rs.getCharacterStream(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        try {
            return this.rs.getClob(colName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        try {
            return this.rs.getClob(i);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            return this.rs.getConcurrency();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            return this.rs.getCursorName();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            return this.rs.getDate(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.rs.getDate(columnIndex, cal);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        try {
            return this.rs.getDate(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        try {
            return this.rs.getDate(columnName, cal);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            return this.rs.getDouble(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        try {
            return this.rs.getDouble(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.rs.getFetchDirection();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.rs.getFetchSize();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            return this.rs.getFloat(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        try {
            return this.rs.getFloat(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            return this.rs.getInt(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        try {
            return this.rs.getInt(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            return this.rs.getLong(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        try {
            return this.rs.getLong(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.rs.getMetaData();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        try {
            return this.rs.getObject(colName, map);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this.rs.getObject(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        try {
            return this.rs.getObject(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        try {
            return this.rs.getObject(i, map);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        try {
            return this.rs.getRef(colName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        try {
            return this.rs.getRef(i);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try {
            return this.rs.getRow();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            return this.rs.getShort(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        try {
            return this.rs.getShort(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            return this.rs.getString(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        try {
            return this.rs.getString(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            return this.rs.getTime(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.rs.getTime(columnIndex, cal);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        try {
            return this.rs.getTime(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        try {
            return this.rs.getTime(columnName, cal);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            return this.rs.getTimestamp(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.rs.getTimestamp(columnIndex, cal);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        try {
            return this.rs.getTimestamp(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        try {
            return this.rs.getTimestamp(columnName, cal);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            return this.rs.getType();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try {
            return this.rs.getUnicodeStream(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        try {
            return this.rs.getUnicodeStream(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            return this.rs.getURL(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        try {
            return this.rs.getURL(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.rs.getWarnings();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            this.rs.insertRow();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            return this.rs.isAfterLast();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            return this.rs.isBeforeFirst();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            return this.rs.isFirst();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            return this.rs.isLast();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            return this.rs.last();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this.rs.moveToCurrentRow();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this.rs.moveToInsertRow();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            return this.rs.previous();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this.rs.refreshRow();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        try {
            return this.rs.relative(rows);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            return this.rs.rowDeleted();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            return this.rs.rowInserted();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            return this.rs.rowUpdated();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.rs.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.rs.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        try {
            this.rs.updateArray(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        try {
            this.rs.updateArray(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public RowId getRowId(int i) throws SQLException {
        try {
            return this.rs.getRowId(i);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public RowId getRowId(String s) throws SQLException {
        try {
            return this.rs.getRowId(s);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateRowId(int i, RowId rowId) throws SQLException {
        try {
            this.rs.updateRowId(i, rowId);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateRowId(String s, RowId rowId) throws SQLException {
        try {
            this.rs.updateRowId(s, rowId);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.rs.getHoldability();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.rs.isClosed();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNString(int i, String s) throws SQLException {
        try {
            this.rs.updateNString(i, s);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNString(String s, String s1) throws SQLException {
        try {
            this.rs.updateNString(s, s1);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(int i, NClob nClob) throws SQLException {
        try {
            this.rs.updateNClob(i, nClob);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(String s, NClob nClob) throws SQLException {
        try {
            this.rs.updateNClob(s, nClob);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        try {
            return this.rs.getNClob(i);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public NClob getNClob(String s) throws SQLException {
        try {
            return this.rs.getNClob(s);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        try {
            return this.rs.getSQLXML(i);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public SQLXML getSQLXML(String s) throws SQLException {
        try {
            return this.rs.getSQLXML(s);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateSQLXML(int i, SQLXML sqlxml) throws SQLException {
        try {
            this.rs.updateSQLXML(i, sqlxml);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateSQLXML(String s, SQLXML sqlxml) throws SQLException {
        try {
            this.rs.updateSQLXML(s, sqlxml);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getNString(int i) throws SQLException {
        try {
            return this.rs.getNString(i);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getNString(String s) throws SQLException {
        try {
            return this.rs.getNString(s);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        try {
            return this.rs.getNCharacterStream(i);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Reader getNCharacterStream(String s) throws SQLException {
        try {
            return this.rs.getNCharacterStream(s);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(int i, Reader reader, long l) throws SQLException {
        try {
            this.rs.updateNCharacterStream(i, reader, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(String s, Reader reader, long l) throws SQLException {
        try {
            this.rs.updateNCharacterStream(s, reader, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(int i, InputStream inputStream, long l) throws SQLException {
        try {
            this.rs.updateAsciiStream(i, inputStream, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(int i, InputStream inputStream, long l) throws SQLException {
        try {
            this.rs.updateBinaryStream(i, inputStream, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(int i, Reader reader, long l) throws SQLException {
        try {
            this.rs.updateCharacterStream(i, reader, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(String s, InputStream inputStream, long l) throws SQLException {
        try {
            this.rs.updateAsciiStream(s, inputStream, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(String s, InputStream inputStream, long l) throws SQLException {
        try {
            this.rs.updateBinaryStream(s, inputStream, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(String s, Reader reader, long l) throws SQLException {
        try {
            this.rs.updateCharacterStream(s, reader, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(int i, InputStream inputStream, long l) throws SQLException {
        try {
            this.rs.updateBlob(i, inputStream, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(String s, InputStream inputStream, long l) throws SQLException {
        try {
            this.rs.updateBlob(s, inputStream, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateClob(int i, Reader reader, long l) throws SQLException {
        try {
            this.rs.updateClob(i, reader, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateClob(String s, Reader reader, long l) throws SQLException {
        try {
            this.rs.updateClob(s, reader, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(int i, Reader reader, long l) throws SQLException {
        try {
            this.rs.updateNClob(i, reader, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(String s, Reader reader, long l) throws SQLException {
        try {
            this.rs.updateNClob(s, reader, l);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(int i, Reader reader) throws SQLException {
        try {
            this.rs.updateNCharacterStream(i, reader);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNCharacterStream(String s, Reader reader) throws SQLException {
        try {
            this.rs.updateNCharacterStream(s, reader);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(int i, InputStream inputStream) throws SQLException {
        try {
            this.rs.updateAsciiStream(i, inputStream);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(int i, InputStream inputStream) throws SQLException {
        try {
            this.rs.updateBinaryStream(i, inputStream);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(int i, Reader reader) throws SQLException {
        try {
            this.rs.updateCharacterStream(i, reader);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(String s, InputStream inputStream) throws SQLException {
        try {
            this.rs.updateAsciiStream(s, inputStream);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(String s, InputStream inputStream) throws SQLException {
        try {
            this.rs.updateBinaryStream(s, inputStream);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(String s, Reader reader) throws SQLException {
        try {
            this.rs.updateCharacterStream(s, reader);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(int i, InputStream inputStream) throws SQLException {
        try {
            this.rs.updateBlob(i, inputStream);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(String s, InputStream inputStream) throws SQLException {
        try {
            this.rs.updateBlob(s, inputStream);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateClob(int i, Reader reader) throws SQLException {
        try {
            this.rs.updateClob(i, reader);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateClob(String s, Reader reader) throws SQLException {
        try {
            this.rs.updateClob(s, reader);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(int i, Reader reader) throws SQLException {
        try {
            this.rs.updateNClob(i, reader);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNClob(String s, Reader reader) throws SQLException {
        try {
            this.rs.updateNClob(s, reader);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this.rs.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            this.rs.updateAsciiStream(columnName, x, length);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            this.rs.updateBigDecimal(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        try {
            this.rs.updateBigDecimal(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this.rs.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        try {
            this.rs.updateBinaryStream(columnName, x, length);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        try {
            this.rs.updateBlob(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        try {
            this.rs.updateBlob(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            this.rs.updateBoolean(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        try {
            this.rs.updateBoolean(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            this.rs.updateByte(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        try {
            this.rs.updateByte(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            this.rs.updateBytes(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        try {
            this.rs.updateBytes(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        try {
            this.rs.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        try {
            this.rs.updateCharacterStream(columnName, reader, length);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        try {
            this.rs.updateClob(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        try {
            this.rs.updateClob(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            this.rs.updateDate(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        try {
            this.rs.updateDate(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            this.rs.updateDouble(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        try {
            this.rs.updateDouble(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            this.rs.updateFloat(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        try {
            this.rs.updateFloat(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            this.rs.updateInt(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        try {
            this.rs.updateInt(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            this.rs.updateLong(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        try {
            this.rs.updateLong(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try {
            this.rs.updateNull(columnIndex);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        try {
            this.rs.updateNull(columnName);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        try {
            this.rs.updateObject(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        try {
            this.rs.updateObject(columnIndex, x, scale);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        try {
            this.rs.updateObject(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        try {
            this.rs.updateObject(columnName, x, scale);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        try {
            this.rs.updateRef(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        try {
            this.rs.updateRef(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            this.rs.updateRow();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            this.rs.updateShort(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        try {
            this.rs.updateShort(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        try {
            this.rs.updateString(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        try {
            this.rs.updateString(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            this.rs.updateTime(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        try {
            this.rs.updateTime(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            this.rs.updateTimestamp(columnIndex, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        try {
            this.rs.updateTimestamp(columnName, x);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            return this.rs.wasNull();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        if (tClass.isInstance(this)) {
            return tClass.cast(this);
        }
        try {
            return this.rs.unwrap(tClass);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return true;
        }
        try {
            return this.rs.isWrapperFor(aClass);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            return this.rs.getObject(columnIndex, type);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        try {
            return this.rs.getObject(columnLabel, type);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }
}

