/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import jakarta.resource.NotSupportedException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.InvalidPropertyException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ResourceAdapterInternalException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.UserPasswordManagedConnectionFactory;
import org.tranql.connector.jdbc.AutocommitSpecCompliant;
import org.tranql.connector.jdbc.ManagedPooledConnection;
import org.tranql.connector.jdbc.TranqlDataSource;

public abstract class AbstractPooledConnectionDataSourceMCF<T extends ConnectionPoolDataSource>
implements UserPasswordManagedConnectionFactory,
AutocommitSpecCompliant {
    private static final long serialVersionUID = 1900317507397273416L;
    protected final T connectionPoolDataSource;
    protected final ExceptionSorter exceptionSorter;
    private int transactionIsolationLevel = -1;

    protected AbstractPooledConnectionDataSourceMCF(T connectionPoolDataSource, ExceptionSorter exceptionSorter) {
        this.connectionPoolDataSource = connectionPoolDataSource;
        this.exceptionSorter = exceptionSorter;
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("ConnectionManager is required");
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new TranqlDataSource(this, connectionManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
        PooledConnection sqlConnection = this.getPhysicalConnection(subject, credentialExtractor);
        try {
            return new ManagedPooledConnection(this, sqlConnection, credentialExtractor, this.exceptionSorter);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Could not set up ManagedPooledConnection", (Throwable)e);
        }
    }

    protected PooledConnection getPhysicalConnection(Subject subject, CredentialExtractor credentialExtractor) throws ResourceException {
        try {
            return this.connectionPoolDataSource.getPooledConnection(credentialExtractor.getUserName(), credentialExtractor.getPassword());
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to obtain physical connection to " + this.connectionPoolDataSource, (Throwable)e);
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        for (Object o : set) {
            ManagedConnectionHandle mc;
            if (!(o instanceof ManagedConnectionHandle) || !(mc = (ManagedConnectionHandle)o).matches(this, subject, connectionRequestInfo)) continue;
            return mc;
        }
        return null;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            return this.connectionPoolDataSource.getLogWriter();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void setLogWriter(PrintWriter log) throws ResourceException {
        try {
            this.connectionPoolDataSource.setLogWriter(log);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Integer getLoginTimeout() {
        int timeout;
        try {
            timeout = this.connectionPoolDataSource.getLoginTimeout();
        }
        catch (SQLException e) {
            timeout = 0;
        }
        return timeout;
    }

    public void setLoginTimeout(Integer timeout) throws ResourceException {
        try {
            this.connectionPoolDataSource.setLoginTimeout(timeout);
        }
        catch (SQLException e) {
            throw new InvalidPropertyException(e.getMessage());
        }
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    @Override
    public Boolean isCommitBeforeAutocommit() {
        return Boolean.FALSE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractPooledConnectionDataSourceMCF) {
            AbstractPooledConnectionDataSourceMCF other = (AbstractPooledConnectionDataSourceMCF)obj;
            return this.connectionPoolDataSource.equals(other.connectionPoolDataSource);
        }
        return false;
    }

    public int hashCode() {
        return this.connectionPoolDataSource.hashCode();
    }

    public String toString() {
        return "AbstractXADataSourceMCF[" + this.connectionPoolDataSource + "]";
    }
}

