/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ResourceAdapterInternalException;
import java.sql.SQLException;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.tranql.connector.CredentialExtractor;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.jdbc.AbstractXADataSourceMCF;
import org.tranql.connector.jdbc.ConnectionWrapper;
import org.tranql.connector.jdbc.ManagedXAConnection;

public abstract class AbstractPSCachedXADataSourceMCF<T extends XADataSource>
extends AbstractXADataSourceMCF<T> {
    private int preparedStatementCacheSize = 0;

    public AbstractPSCachedXADataSourceMCF(T xaDataSource, ExceptionSorter exceptionSorter) {
        super(xaDataSource, exceptionSorter);
    }

    @Override
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
        XAConnection sqlConnection = this.getPhysicalConnection(credentialExtractor);
        try {
            ManagedXAConnection mxac = null;
            if (this.preparedStatementCacheSize > 0) {
                ConnectionWrapper pc = new ConnectionWrapper(sqlConnection.getConnection(), this.preparedStatementCacheSize);
                mxac = new ManagedXAConnection(this, sqlConnection, sqlConnection.getXAResource(), pc, credentialExtractor, this.exceptionSorter);
            } else {
                mxac = new ManagedXAConnection(this, sqlConnection, credentialExtractor, this.exceptionSorter);
            }
            return mxac;
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Could not set up ManagedXAConnection", (Throwable)e);
        }
    }

    public Integer getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(Integer preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
    }
}

