/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.view.ReactViewGroup;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public abstract class ReactClippingViewManager<T extends ReactViewGroup>
extends ViewGroupManager<T> {
    @ReactProp(name="removeClippedSubviews")
    public void setRemoveClippedSubviews(T view, boolean removeClippedSubviews) {
        UiThreadUtil.assertOnUiThread();
        ((ReactViewGroup)view).setRemoveClippedSubviews(removeClippedSubviews);
    }

    @Override
    public void addView(T parent, View child, int index) {
        UiThreadUtil.assertOnUiThread();
        boolean removeClippedSubviews = ((ReactViewGroup)parent).getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            ((ReactViewGroup)parent).addViewWithSubviewClippingEnabled(child, index);
        } else {
            parent.addView(child, index);
        }
    }

    @Override
    public int getChildCount(T parent) {
        boolean removeClippedSubviews = ((ReactViewGroup)parent).getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            return ((ReactViewGroup)parent).getAllChildrenCount();
        }
        return parent.getChildCount();
    }

    @Override
    @Nullable
    public View getChildAt(T parent, int index) {
        boolean removeClippedSubviews = ((ReactViewGroup)parent).getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            return ((ReactViewGroup)parent).getChildAtWithSubviewClippingEnabled(index);
        }
        return parent.getChildAt(index);
    }

    @Override
    public void removeViewAt(T parent, int index) {
        UiThreadUtil.assertOnUiThread();
        boolean removeClippedSubviews = ((ReactViewGroup)parent).getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            View child = this.getChildAt(parent, index);
            if (child != null) {
                if (child.getParent() != null) {
                    ((ReactViewGroup)parent).removeView(child);
                }
                ((ReactViewGroup)parent).removeViewWithSubviewClippingEnabled(child);
            }
        } else {
            ((ReactViewGroup)parent).removeViewAt(index);
        }
    }

    @Override
    public void removeAllViews(T parent) {
        UiThreadUtil.assertOnUiThread();
        boolean removeClippedSubviews = ((ReactViewGroup)parent).getRemoveClippedSubviews();
        if (removeClippedSubviews) {
            ((ReactViewGroup)parent).removeAllViewsWithSubviewClippingEnabled();
        } else {
            parent.removeAllViews();
        }
    }
}

