/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.annotation.Nullable;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.textinput.ReactTextInputLocalData;
import com.facebook.react.views.view.MeasureUtil;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;

@VisibleForTesting
public class ReactTextInputShadowNode
extends ReactBaseTextShadowNode
implements YogaMeasureFunction {
    private int mMostRecentEventCount = -1;
    @Nullable
    private EditText mInternalEditText;
    @Nullable
    private ReactTextInputLocalData mLocalData;
    @VisibleForTesting
    public static final String PROP_TEXT = "text";
    @VisibleForTesting
    public static final String PROP_PLACEHOLDER = "placeholder";
    @Nullable
    private String mText = null;
    @Nullable
    private String mPlaceholder = null;

    public ReactTextInputShadowNode(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        super(reactTextViewManagerCallback);
        this.mTextBreakStrategy = 1;
        this.initMeasureFunction();
    }

    public ReactTextInputShadowNode() {
        this(null);
    }

    private void initMeasureFunction() {
        this.setMeasureFunction(this);
    }

    @Override
    public void setThemedContext(ThemedReactContext themedContext) {
        super.setThemedContext(themedContext);
        EditText editText = this.createInternalEditText();
        this.setDefaultPadding(4, ViewCompat.getPaddingStart((View)editText));
        this.setDefaultPadding(1, editText.getPaddingTop());
        this.setDefaultPadding(5, ViewCompat.getPaddingEnd((View)editText));
        this.setDefaultPadding(3, editText.getPaddingBottom());
        this.mInternalEditText = editText;
        this.mInternalEditText.setPadding(0, 0, 0, 0);
        this.mInternalEditText.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
    }

    @Override
    public long measure(YogaNode node, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        EditText editText = (EditText)Assertions.assertNotNull((Object)this.mInternalEditText);
        if (this.mLocalData != null) {
            this.mLocalData.apply(editText);
        } else {
            editText.setTextSize(0, (float)this.mTextAttributes.getEffectiveFontSize());
            if (this.mNumberOfLines != -1) {
                editText.setLines(this.mNumberOfLines);
            }
            if (editText.getBreakStrategy() != this.mTextBreakStrategy) {
                editText.setBreakStrategy(this.mTextBreakStrategy);
            }
        }
        editText.setHint((CharSequence)this.getPlaceholder());
        editText.measure(MeasureUtil.getMeasureSpec(width, widthMode), MeasureUtil.getMeasureSpec(height, heightMode));
        return YogaMeasureOutput.make(editText.getMeasuredWidth(), editText.getMeasuredHeight());
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public boolean isYogaLeafNode() {
        return true;
    }

    @Override
    public void setLocalData(Object data) {
        Assertions.assertCondition((boolean)(data instanceof ReactTextInputLocalData));
        this.mLocalData = (ReactTextInputLocalData)data;
        this.dirty();
    }

    @ReactProp(name="mostRecentEventCount")
    public void setMostRecentEventCount(int mostRecentEventCount) {
        this.mMostRecentEventCount = mostRecentEventCount;
    }

    @ReactProp(name="text")
    public void setText(@Nullable String text) {
        this.mText = text;
        this.markUpdated();
    }

    @Nullable
    public String getText() {
        return this.mText;
    }

    @ReactProp(name="placeholder")
    public void setPlaceholder(@Nullable String placeholder) {
        this.mPlaceholder = placeholder;
        this.markUpdated();
    }

    @Nullable
    public String getPlaceholder() {
        return this.mPlaceholder;
    }

    @Override
    public void setTextBreakStrategy(@Nullable String textBreakStrategy) {
        if (textBreakStrategy == null || "simple".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 0;
        } else if ("highQuality".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 1;
        } else if ("balanced".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 2;
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid textBreakStrategy: " + textBreakStrategy));
            this.mTextBreakStrategy = 0;
        }
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mMostRecentEventCount != -1) {
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(this.spannedFromShadowNode(this, this.getText(), false, null), this.mMostRecentEventCount, this.mContainsImages, this.getPadding(0), this.getPadding(1), this.getPadding(2), this.getPadding(3), this.mTextAlign, this.mTextBreakStrategy, this.mJustificationMode);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        super.setPadding(spacingType, padding);
        this.markUpdated();
    }

    protected EditText createInternalEditText() {
        ContextThemeWrapper context = new ContextThemeWrapper((Context)this.getThemedContext(), R.style.Theme_ReactNative_TextInput_DefaultBackground);
        return new EditText((Context)context);
    }
}

