/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.text.SpannableStringBuilder;
import android.widget.EditText;

public final class ReactTextInputLocalData {
    private final SpannableStringBuilder mText;
    private final float mTextSize;
    private final int mMinLines;
    private final int mMaxLines;
    private final int mInputType;
    private final int mBreakStrategy;
    private final CharSequence mPlaceholder;

    public ReactTextInputLocalData(EditText editText) {
        this.mText = new SpannableStringBuilder((CharSequence)editText.getText());
        this.mTextSize = editText.getTextSize();
        this.mInputType = editText.getInputType();
        this.mPlaceholder = editText.getHint();
        this.mMinLines = editText.getMinLines();
        this.mMaxLines = editText.getMaxLines();
        this.mBreakStrategy = editText.getBreakStrategy();
    }

    public void apply(EditText editText) {
        editText.setText((CharSequence)this.mText);
        editText.setTextSize(0, this.mTextSize);
        editText.setMinLines(this.mMinLines);
        editText.setMaxLines(this.mMaxLines);
        editText.setInputType(this.mInputType);
        editText.setHint(this.mPlaceholder);
        editText.setBreakStrategy(this.mBreakStrategy);
    }
}

