/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.text.TextUtils;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.ReactTextView;

public abstract class ReactTextAnchorViewManager<T extends View, C extends ReactBaseTextShadowNode>
extends BaseViewManager<T, C> {
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3, 4, 5};
    private static final String TAG = "ReactTextAnchorViewManager";

    @ReactProp(name="accessible")
    public void setAccessible(ReactTextView view, boolean accessible) {
        view.setFocusable(accessible);
    }

    @ReactProp(name="numberOfLines", defaultInt=0x7FFFFFFF)
    public void setNumberOfLines(ReactTextView view, int numberOfLines) {
        view.setNumberOfLines(numberOfLines);
    }

    @ReactProp(name="ellipsizeMode")
    public void setEllipsizeMode(ReactTextView view, @Nullable String ellipsizeMode) {
        if (ellipsizeMode == null || ellipsizeMode.equals("tail")) {
            view.setEllipsizeLocation(TextUtils.TruncateAt.END);
        } else if (ellipsizeMode.equals("head")) {
            view.setEllipsizeLocation(TextUtils.TruncateAt.START);
        } else if (ellipsizeMode.equals("middle")) {
            view.setEllipsizeLocation(TextUtils.TruncateAt.MIDDLE);
        } else if (ellipsizeMode.equals("clip")) {
            view.setEllipsizeLocation(null);
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid ellipsizeMode: " + ellipsizeMode));
            view.setEllipsizeLocation(TextUtils.TruncateAt.END);
        }
    }

    @ReactProp(name="adjustsFontSizeToFit")
    public void setAdjustFontSizeToFit(ReactTextView view, boolean adjustsFontSizeToFit) {
        view.setAdjustFontSizeToFit(adjustsFontSizeToFit);
    }

    @ReactProp(name="fontSize")
    public void setFontSize(ReactTextView view, float fontSize) {
        view.setFontSize(fontSize);
    }

    @ReactProp(name="letterSpacing", defaultFloat=0.0f)
    public void setLetterSpacing(ReactTextView view, float letterSpacing) {
        view.setLetterSpacing(letterSpacing);
    }

    @ReactProp(name="textAlignVertical")
    public void setTextAlignVertical(ReactTextView view, @Nullable String textAlignVertical) {
        if (textAlignVertical == null || "auto".equals(textAlignVertical)) {
            view.setGravityVertical(0);
        } else if ("top".equals(textAlignVertical)) {
            view.setGravityVertical(48);
        } else if ("bottom".equals(textAlignVertical)) {
            view.setGravityVertical(80);
        } else if ("center".equals(textAlignVertical)) {
            view.setGravityVertical(16);
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid textAlignVertical: " + textAlignVertical));
            view.setGravityVertical(0);
        }
    }

    @ReactProp(name="selectable")
    public void setSelectable(ReactTextView view, boolean isSelectable) {
        view.setTextIsSelectable(isSelectable);
    }

    @ReactProp(name="selectionColor", customType="Color")
    public void setSelectionColor(ReactTextView view, @Nullable Integer color) {
        if (color == null) {
            view.setHighlightColor(DefaultStyleValuesUtil.getDefaultTextColorHighlight(view.getContext()));
        } else {
            view.setHighlightColor(color);
        }
    }

    @ReactProp(name="android_hyphenationFrequency")
    public void setAndroidHyphenationFrequency(ReactTextView view, @Nullable String frequency) {
        if (frequency == null || frequency.equals("none")) {
            view.setHyphenationFrequency(0);
        } else if (frequency.equals("full")) {
            view.setHyphenationFrequency(2);
        } else if (frequency.equals("normal")) {
            view.setHyphenationFrequency(1);
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid android_hyphenationFrequency: " + frequency));
            view.setHyphenationFrequency(0);
        }
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public void setBorderRadius(ReactTextView view, int index, float borderRadius) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(borderRadius, LengthPercentageType.POINT);
            BackgroundStyleApplicator.setBorderRadius((View)view, BorderRadiusProp.values()[index], radius);
        } else {
            if (!Float.isNaN(borderRadius)) {
                borderRadius = PixelUtil.toPixelFromDIP(borderRadius);
            }
            if (index == 0) {
                view.setBorderRadius(borderRadius);
            } else {
                view.setBorderRadius(borderRadius, index - 1);
            }
        }
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(ReactTextView view, @Nullable String borderStyle) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BorderStyle parsedBorderStyle = borderStyle == null ? null : BorderStyle.fromString(borderStyle);
            BackgroundStyleApplicator.setBorderStyle((View)view, parsedBorderStyle);
        } else {
            view.setBorderStyle(borderStyle);
        }
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth", "borderStartWidth", "borderEndWidth"}, defaultFloat=NaNf)
    public void setBorderWidth(ReactTextView view, int index, float width) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBorderWidth((View)view, LogicalEdge.values()[index], Float.valueOf(width));
        } else {
            if (!Float.isNaN(width)) {
                width = PixelUtil.toPixelFromDIP(width);
            }
            view.setBorderWidth(SPACING_TYPES[index], width);
        }
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor"}, customType="Color")
    public void setBorderColor(ReactTextView view, int index, @Nullable Integer color) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBorderColor((View)view, LogicalEdge.ALL, color);
        } else {
            view.setBorderColor(SPACING_TYPES[index], color);
        }
    }

    @ReactProp(name="includeFontPadding", defaultBoolean=true)
    public void setIncludeFontPadding(ReactTextView view, boolean includepad) {
        view.setIncludeFontPadding(includepad);
    }

    @ReactProp(name="disabled", defaultBoolean=false)
    public void setDisabled(ReactTextView view, boolean disabled) {
        view.setEnabled(!disabled);
    }

    @ReactProp(name="dataDetectorType")
    public void setDataDetectorType(ReactTextView view, @Nullable String type) {
        if (type != null) {
            switch (type) {
                case "phoneNumber": {
                    view.setLinkifyMask(4);
                    return;
                }
                case "link": {
                    view.setLinkifyMask(1);
                    return;
                }
                case "email": {
                    view.setLinkifyMask(2);
                    return;
                }
                case "all": {
                    view.setLinkifyMask(15);
                    return;
                }
            }
        }
        view.setLinkifyMask(0);
    }

    @ReactProp(name="onInlineViewLayout")
    public void setNotifyOnInlineViewLayout(ReactTextView view, boolean notifyOnInlineViewLayout) {
        view.setNotifyOnInlineViewLayout(notifyOnInlineViewLayout);
    }

    @ReactProp(name="boxShadow", customType="BoxShadow")
    public void setBoxShadow(ReactTextView view, @Nullable ReadableArray shadows) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBoxShadow((View)view, shadows);
        }
    }

    @Override
    public void setBackgroundColor(T view, @ColorInt int backgroundColor) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBackgroundColor(view, backgroundColor);
        } else {
            super.setBackgroundColor(view, backgroundColor);
        }
    }
}

