/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.imagehelper;

import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.react.views.imagehelper.ImageSource;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/views/imagehelper/MultiSourceHelper;", "", "()V", "getBestSourceForSize", "Lcom/facebook/react/views/imagehelper/MultiSourceHelper$MultiSourceResult;", "width", "", "height", "sources", "", "Lcom/facebook/react/views/imagehelper/ImageSource;", "multiplier", "", "MultiSourceResult", "ReactAndroid_release"})
public final class MultiSourceHelper {
    @NotNull
    public static final MultiSourceHelper INSTANCE = new MultiSourceHelper();

    private MultiSourceHelper() {
    }

    @JvmStatic
    @NotNull
    public static final MultiSourceResult getBestSourceForSize(int width, int height, @NotNull List<? extends ImageSource> sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        return MultiSourceHelper.getBestSourceForSize(width, height, sources, 1.0);
    }

    @JvmStatic
    @NotNull
    public static final MultiSourceResult getBestSourceForSize(int width, int height, @NotNull List<? extends ImageSource> sources, double multiplier) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        if (sources.isEmpty()) {
            return new MultiSourceResult(null, null);
        }
        if (sources.size() == 1) {
            return new MultiSourceResult(sources.get(0), null);
        }
        if (width <= 0 || height <= 0) {
            return new MultiSourceResult(null, null);
        }
        ImagePipeline imagePipeline = ImagePipelineFactory.getInstance().getImagePipeline();
        Intrinsics.checkNotNullExpressionValue((Object)imagePipeline, (String)"getImagePipeline(...)");
        ImagePipeline imagePipeline2 = imagePipeline;
        ImageSource best = null;
        ImageSource bestCached = null;
        double viewArea = (double)(width * height) * multiplier;
        double bestPrecision = Double.MAX_VALUE;
        double bestCachePrecision = Double.MAX_VALUE;
        for (ImageSource imageSource : sources) {
            double precision = Math.abs(1.0 - imageSource.getSize() / viewArea);
            if (precision < bestPrecision) {
                bestPrecision = precision;
                best = imageSource;
            }
            if (!(precision < bestCachePrecision) || !imagePipeline2.isInBitmapMemoryCache(imageSource.getUri()) && !imagePipeline2.isInDiskCacheSync(imageSource.getUri())) continue;
            bestCachePrecision = precision;
            bestCached = imageSource;
        }
        if (bestCached != null && best != null && Intrinsics.areEqual((Object)bestCached.getSource(), (Object)best.getSource())) {
            bestCached = null;
        }
        return new MultiSourceResult(best, bestCached);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/imagehelper/MultiSourceHelper$MultiSourceResult;", "", "bestResult", "Lcom/facebook/react/views/imagehelper/ImageSource;", "bestResultInCache", "(Lcom/facebook/react/views/imagehelper/ImageSource;Lcom/facebook/react/views/imagehelper/ImageSource;)V", "ReactAndroid_release"})
    public static final class MultiSourceResult {
        @JvmField
        @Nullable
        public final ImageSource bestResult;
        @JvmField
        @Nullable
        public final ImageSource bestResultInCache;

        public MultiSourceResult(@Nullable ImageSource bestResult, @Nullable ImageSource bestResultInCache) {
            this.bestResult = bestResult;
            this.bestResultInCache = bestResultInCache;
        }
    }
}

