/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.JSEngineResolutionAlgorithm;
import com.facebook.react.MemoryPressureRouter;
import com.facebook.react.ReactHost;
import com.facebook.react.ReactInstanceEventListener;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.MemoryPressureListener;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactNoCrashBridgeNotAllowedSoftException;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.RuntimeExecutor;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.devsupport.DevSupportManagerBase;
import com.facebook.react.devsupport.InspectorFlags;
import com.facebook.react.devsupport.ReleaseDevSupportManager;
import com.facebook.react.devsupport.inspector.InspectorNetworkHelper;
import com.facebook.react.devsupport.inspector.InspectorNetworkRequestListener;
import com.facebook.react.devsupport.interfaces.BundleLoadCallback;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.interfaces.TaskInterface;
import com.facebook.react.interfaces.fabric.ReactSurface;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.modules.appearance.AppearanceModule;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.runtime.BridgelessAtomicRef;
import com.facebook.react.runtime.BridgelessDevSupportManager;
import com.facebook.react.runtime.BridgelessReactContext;
import com.facebook.react.runtime.BridgelessReactStateTracker;
import com.facebook.react.runtime.ReactHostDelegate;
import com.facebook.react.runtime.ReactHostInspectorTarget;
import com.facebook.react.runtime.ReactInstance;
import com.facebook.react.runtime.ReactLifecycleStateManager;
import com.facebook.react.runtime.ReactSurfaceImpl;
import com.facebook.react.runtime.ReactSurfaceView;
import com.facebook.react.runtime.internal.bolts.Continuation;
import com.facebook.react.runtime.internal.bolts.Task;
import com.facebook.react.runtime.internal.bolts.TaskCompletionSource;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.BlackHoleEventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

@DoNotStrip
@ThreadSafe
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactHostImpl
implements ReactHost {
    private static final String TAG = "ReactHost";
    private static final int BRIDGELESS_MARKER_INSTANCE_KEY = 1;
    private static final AtomicInteger mCounter = new AtomicInteger(0);
    private final Context mContext;
    private final ReactHostDelegate mReactHostDelegate;
    private final ComponentFactory mComponentFactory;
    private final DevSupportManager mDevSupportManager;
    private final Executor mBGExecutor;
    private final Executor mUIExecutor;
    private final Set<ReactSurfaceImpl> mAttachedSurfaces = new HashSet<ReactSurfaceImpl>();
    private final MemoryPressureRouter mMemoryPressureRouter;
    private final boolean mAllowPackagerServerAccess;
    private final boolean mUseDevSupport;
    private final BridgelessAtomicRef<Task<ReactInstance>> mCreateReactInstanceTaskRef = new BridgelessAtomicRef<Task<Object>>(Task.forResult(null));
    @Nullable
    private ReactInstance mReactInstance;
    private final BridgelessAtomicRef<BridgelessReactContext> mBridgelessReactContextRef = new BridgelessAtomicRef();
    private final AtomicReference<Activity> mActivity = new AtomicReference();
    private final AtomicReference<WeakReference<Activity>> mLastUsedActivity = new AtomicReference<WeakReference<Object>>(new WeakReference<Object>(null));
    private final BridgelessReactStateTracker mBridgelessReactStateTracker = new BridgelessReactStateTracker(ReactBuildConfig.DEBUG);
    private final ReactLifecycleStateManager mReactLifecycleStateManager = new ReactLifecycleStateManager(this.mBridgelessReactStateTracker);
    private final int mId = mCounter.getAndIncrement();
    @Nullable
    private JSEngineResolutionAlgorithm mJSEngineResolutionAlgorithm = null;
    @Nullable
    private MemoryPressureListener mMemoryPressureListener;
    @Nullable
    private DefaultHardwareBackBtnHandler mDefaultHardwareBackBtnHandler;
    private final List<ReactInstanceEventListener> mReactInstanceEventListeners = new ArrayList<ReactInstanceEventListener>();
    private final List<Function0<Unit>> mBeforeDestroyListeners = new ArrayList<Function0<Unit>>();
    @Nullable
    private ReactHostInspectorTarget mReactHostInspectorTarget;
    private volatile boolean mHostInvalidated = false;
    @ThreadConfined(value="ReactHost")
    @Nullable
    private Task<Void> mStartTask = null;
    @ThreadConfined(value="ReactHost")
    @Nullable
    private Task<ReactInstance> mReloadTask = null;
    @ThreadConfined(value="ReactHost")
    @Nullable
    private Task<Void> mDestroyTask = null;

    public ReactHostImpl(Context context, ReactHostDelegate delegate, ComponentFactory componentFactory, boolean allowPackagerServerAccess, boolean useDevSupport) {
        this(context, delegate, componentFactory, Executors.newSingleThreadExecutor(), Task.UI_THREAD_EXECUTOR, allowPackagerServerAccess, useDevSupport);
    }

    public ReactHostImpl(Context context, ReactHostDelegate delegate, ComponentFactory componentFactory, Executor bgExecutor, Executor uiExecutor, boolean allowPackagerServerAccess, boolean useDevSupport) {
        this.mContext = context;
        this.mReactHostDelegate = delegate;
        this.mComponentFactory = componentFactory;
        this.mBGExecutor = bgExecutor;
        this.mUIExecutor = uiExecutor;
        this.mMemoryPressureRouter = new MemoryPressureRouter(context);
        this.mAllowPackagerServerAccess = allowPackagerServerAccess;
        this.mUseDevSupport = useDevSupport;
        this.mDevSupportManager = this.mUseDevSupport ? new BridgelessDevSupportManager(this, this.mContext, this.mReactHostDelegate.getJsMainModulePath()) : new ReleaseDevSupportManager();
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.mReactLifecycleStateManager.getLifecycleState();
    }

    @Override
    public TaskInterface<Void> start() {
        return Task.call(this::getOrCreateStartTask, this.mBGExecutor).continueWithTask(Task::getResult);
    }

    TaskInterface<Void> prerenderSurface(ReactSurfaceImpl surface) {
        String method = "prerenderSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method, "Schedule");
        this.attachSurface(surface);
        return this.callAfterGetOrCreateReactInstance(method, reactInstance -> {
            this.log(method, "Execute");
            reactInstance.prerenderSurface(surface);
        }, this.mBGExecutor);
    }

    TaskInterface<Void> startSurface(ReactSurfaceImpl surface) {
        String method = "startSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method, "Schedule");
        this.attachSurface(surface);
        return this.callAfterGetOrCreateReactInstance(method, reactInstance -> {
            this.log(method, "Execute");
            reactInstance.startSurface(surface);
        }, this.mBGExecutor);
    }

    TaskInterface<Void> stopSurface(ReactSurfaceImpl surface) {
        String method = "stopSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method, "Schedule");
        this.detachSurface(surface);
        return this.callWithExistingReactInstance(method, reactInstance -> {
            this.log(method, "Execute");
            reactInstance.stopSurface(surface);
        }, this.mBGExecutor).makeVoid();
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity, @Nullable DefaultHardwareBackBtnHandler defaultBackButtonImpl) {
        this.mDefaultHardwareBackBtnHandler = defaultBackButtonImpl;
        this.onHostResume(activity);
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity) {
        String method = "onHostResume(activity)";
        this.log("onHostResume(activity)");
        this.setCurrentActivity(activity);
        ReactContext currentContext = this.getCurrentReactContext();
        this.mReactLifecycleStateManager.moveToOnHostResume(currentContext, this.getCurrentActivity());
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostLeaveHint(@Nullable Activity activity) {
        String method = "onUserLeaveHint(activity)";
        this.log("onUserLeaveHint(activity)");
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            currentContext.onUserLeaveHint(activity);
        }
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostPause(@Nullable Activity activity) {
        String method = "onHostPause(activity)";
        this.log("onHostPause(activity)");
        ReactContext currentContext = this.getCurrentReactContext();
        Activity currentActivity = this.getCurrentActivity();
        if (currentActivity != null) {
            String currentActivityClass = currentActivity.getClass().getSimpleName();
            String activityClass = activity == null ? "null" : activity.getClass().getSimpleName();
            Assertions.assertCondition((activity == currentActivity ? 1 : 0) != 0, (String)("Pausing an activity that is not the current activity, this is incorrect! Current activity: " + currentActivityClass + " Paused activity: " + activityClass));
        }
        this.mDefaultHardwareBackBtnHandler = null;
        this.mReactLifecycleStateManager.moveToOnHostPause(currentContext, currentActivity);
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostPause() {
        String method = "onHostPause()";
        this.log("onHostPause()");
        ReactContext currentContext = this.getCurrentReactContext();
        this.mDefaultHardwareBackBtnHandler = null;
        this.mReactLifecycleStateManager.moveToOnHostPause(currentContext, this.getCurrentActivity());
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostDestroy() {
        String method = "onHostDestroy()";
        this.log("onHostDestroy()");
        this.moveToHostDestroy(this.getCurrentReactContext());
    }

    @Override
    @ThreadConfined(value="UI")
    public void onHostDestroy(@Nullable Activity activity) {
        String method = "onHostDestroy(activity)";
        this.log("onHostDestroy(activity)");
        Activity currentActivity = this.getCurrentActivity();
        if (currentActivity == activity) {
            this.moveToHostDestroy(this.getCurrentReactContext());
        }
    }

    @Override
    @Nullable
    public ReactContext getCurrentReactContext() {
        return this.mBridgelessReactContextRef.getNullable();
    }

    @Override
    public DevSupportManager getDevSupportManager() {
        return (DevSupportManager)Assertions.assertNotNull((Object)this.mDevSupportManager);
    }

    @Override
    public ReactSurface createSurface(Context context, String moduleName, @Nullable Bundle initialProps) {
        ReactSurfaceImpl surface = new ReactSurfaceImpl(context, moduleName, initialProps);
        ReactSurfaceView surfaceView = new ReactSurfaceView(context, surface);
        surfaceView.setShouldLogContentAppeared(true);
        surface.attachView(surfaceView);
        surface.attach(this);
        return surface;
    }

    @Override
    public MemoryPressureRouter getMemoryPressureRouter() {
        return this.mMemoryPressureRouter;
    }

    boolean isInstanceInitialized() {
        return this.mReactInstance != null;
    }

    @Override
    @ThreadConfined(value="UI")
    public boolean onBackPressed() {
        UiThreadUtil.assertOnUiThread();
        ReactInstance reactInstance = this.mReactInstance;
        if (reactInstance == null) {
            return false;
        }
        DeviceEventManagerModule deviceEventManagerModule = reactInstance.getNativeModule(DeviceEventManagerModule.class);
        if (deviceEventManagerModule == null) {
            return false;
        }
        deviceEventManagerModule.emitHardwareBackPressed();
        return true;
    }

    @Override
    @Nullable
    public ReactQueueConfiguration getReactQueueConfiguration() {
        ReactInstance reactInstance = this.mReactInstance;
        if (reactInstance != null) {
            return reactInstance.getReactQueueConfiguration();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReactInstanceEventListener(ReactInstanceEventListener listener) {
        List<ReactInstanceEventListener> list = this.mReactInstanceEventListeners;
        synchronized (list) {
            this.mReactInstanceEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReactInstanceEventListener(ReactInstanceEventListener listener) {
        List<ReactInstanceEventListener> list = this.mReactInstanceEventListeners;
        synchronized (list) {
            this.mReactInstanceEventListeners.remove(listener);
        }
    }

    @Override
    public TaskInterface<Void> reload(String reason) {
        String method = "reload()";
        return Task.call(() -> {
            Task<Void> reloadTask = null;
            if (this.mDestroyTask != null) {
                this.log("reload()", "Waiting for destroy to finish, before reloading React Native.");
                reloadTask = this.mDestroyTask.continueWithTask(task -> this.getOrCreateReloadTask(reason), this.mBGExecutor).makeVoid();
            } else {
                reloadTask = this.getOrCreateReloadTask(reason).makeVoid();
            }
            return reloadTask.continueWithTask(task -> {
                if (task.isFaulted()) {
                    Exception ex = task.getError();
                    if (this.mUseDevSupport) {
                        this.mDevSupportManager.handleException(ex);
                    } else {
                        this.mReactHostDelegate.handleInstanceException(ex);
                    }
                    return this.getOrCreateDestroyTask("Reload failed", ex);
                }
                return task;
            }, this.mBGExecutor);
        }, this.mBGExecutor).continueWithTask(Task::getResult);
    }

    @DoNotStrip
    private void setPausedInDebuggerMessage(@Nullable String message) {
        if (message == null) {
            this.mDevSupportManager.hidePausedInDebuggerOverlay();
        } else {
            this.mDevSupportManager.showPausedInDebuggerOverlay(message, new DevSupportManager.PausedInDebuggerOverlayCommandListener(){

                @Override
                public void onResume() {
                    UiThreadUtil.assertOnUiThread();
                    if (ReactHostImpl.this.mReactHostInspectorTarget != null) {
                        ReactHostImpl.this.mReactHostInspectorTarget.sendDebuggerResumeCommand();
                    }
                }
            });
        }
    }

    @DoNotStrip
    private Map<String, String> getHostMetadata() {
        return AndroidInfoHelpers.getInspectorHostMetadata(this.mContext);
    }

    @DoNotStrip
    private void loadNetworkResource(String url, InspectorNetworkRequestListener listener) {
        InspectorNetworkHelper.loadNetworkResource(url, listener);
    }

    @Override
    public TaskInterface<Void> destroy(String reason, @Nullable Exception ex) {
        String method = "destroy()";
        return Task.call(() -> {
            if (this.mReloadTask != null) {
                this.log("destroy()", "Reloading React Native. Waiting for reload to finish before destroying React Native.");
                return this.mReloadTask.continueWithTask(task -> this.getOrCreateDestroyTask(reason, ex), this.mBGExecutor);
            }
            return this.getOrCreateDestroyTask(reason, ex);
        }, this.mBGExecutor).continueWithTask(Task::getResult);
    }

    private MemoryPressureListener createMemoryPressureListener(ReactInstance reactInstance) {
        WeakReference<ReactInstance> weakReactInstance = new WeakReference<ReactInstance>(reactInstance);
        return level -> this.mBGExecutor.execute(() -> {
            ReactInstance strongReactInstance = (ReactInstance)weakReactInstance.get();
            if (strongReactInstance != null) {
                strongReactInstance.handleMemoryPressure(level);
            }
        });
    }

    @Nullable
    Activity getCurrentActivity() {
        return this.mActivity.get();
    }

    @Nullable
    Activity getLastUsedActivity() {
        WeakReference<Activity> lastUsedActivityWeakRef = this.mLastUsedActivity.get();
        if (lastUsedActivityWeakRef != null) {
            return (Activity)lastUsedActivityWeakRef.get();
        }
        return null;
    }

    private void setCurrentActivity(@Nullable Activity activity) {
        this.mActivity.set(activity);
        if (activity != null) {
            this.mLastUsedActivity.set(new WeakReference<Activity>(activity));
        }
    }

    EventDispatcher getEventDispatcher() {
        ReactInstance reactInstance = this.mReactInstance;
        if (reactInstance == null) {
            return BlackHoleEventDispatcher.get();
        }
        return reactInstance.getEventDispatcher();
    }

    @Nullable
    FabricUIManager getUIManager() {
        ReactInstance reactInstance = this.mReactInstance;
        if (reactInstance == null) {
            return null;
        }
        return reactInstance.getUIManager();
    }

    <T extends NativeModule> boolean hasNativeModule(Class<T> nativeModuleInterface) {
        ReactInstance reactInstance = this.mReactInstance;
        if (reactInstance != null) {
            return reactInstance.hasNativeModule(nativeModuleInterface);
        }
        return false;
    }

    Collection<NativeModule> getNativeModules() {
        ReactInstance reactInstance = this.mReactInstance;
        if (reactInstance != null) {
            return reactInstance.getNativeModules();
        }
        return new ArrayList<NativeModule>();
    }

    @Nullable
    <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        ReactInstance reactInstance;
        if (nativeModuleInterface == UIManagerModule.class) {
            ReactSoftExceptionLogger.logSoftExceptionVerbose(TAG, new ReactNoCrashBridgeNotAllowedSoftException("getNativeModule(UIManagerModule.class) cannot be called when the bridge is disabled"));
        }
        if ((reactInstance = this.mReactInstance) != null) {
            return reactInstance.getNativeModule(nativeModuleInterface);
        }
        return null;
    }

    @Nullable
    NativeModule getNativeModule(String nativeModuleName) {
        ReactInstance reactInstance = this.mReactInstance;
        if (reactInstance != null) {
            return reactInstance.getNativeModule(nativeModuleName);
        }
        return null;
    }

    @Nullable
    RuntimeExecutor getRuntimeExecutor() {
        String method = "getRuntimeExecutor()";
        ReactInstance reactInstance = this.mReactInstance;
        if (reactInstance != null) {
            return reactInstance.getBufferedRuntimeExecutor();
        }
        this.raiseSoftException("getRuntimeExecutor()", "Tried to get runtime executor while instance is not ready");
        return null;
    }

    @Nullable
    CallInvokerHolder getJSCallInvokerHolder() {
        String method = "getJSCallInvokerHolder()";
        ReactInstance reactInstance = this.mReactInstance;
        if (reactInstance != null) {
            return reactInstance.getJSCallInvokerHolder();
        }
        this.raiseSoftException("getJSCallInvokerHolder()", "Tried to get JSCallInvokerHolder while instance is not ready");
        return null;
    }

    @Override
    @ThreadConfined(value="UI")
    public void onActivityResult(Activity activity, int requestCode, int resultCode, @Nullable Intent data) {
        String method = "onActivityResult(activity = \"" + activity + "\", requestCode = \"" + requestCode + "\", resultCode = \"" + resultCode + "\", data = \"" + data + "\")";
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            currentContext.onActivityResult(activity, requestCode, resultCode, data);
        } else {
            this.raiseSoftException(method, "Tried to access onActivityResult while context is not ready");
        }
    }

    @Override
    @ThreadConfined(value="UI")
    public void onWindowFocusChange(boolean hasFocus) {
        String method = "onWindowFocusChange(hasFocus = \"" + hasFocus + "\")";
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            currentContext.onWindowFocusChange(hasFocus);
        } else {
            this.raiseSoftException(method, "Tried to access onWindowFocusChange while context is not ready");
        }
    }

    @Override
    @ThreadConfined(value="UI")
    public void onNewIntent(Intent intent) {
        String method = "onNewIntent(intent = \"" + intent + "\")";
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            DeviceEventManagerModule deviceEventManagerModule;
            String action = intent.getAction();
            Uri uri = intent.getData();
            if (uri != null && ("android.intent.action.VIEW".equals(action) || "android.nfc.action.NDEF_DISCOVERED".equals(action)) && (deviceEventManagerModule = currentContext.getNativeModule(DeviceEventManagerModule.class)) != null) {
                deviceEventManagerModule.emitNewIntentReceived(uri);
            }
            currentContext.onNewIntent(this.getCurrentActivity(), intent);
        } else {
            this.raiseSoftException(method, "Tried to access onNewIntent while context is not ready");
        }
    }

    @Override
    @ThreadConfined(value="UI")
    public void onConfigurationChanged(Context updatedContext) {
        AppearanceModule appearanceModule;
        ReactContext currentReactContext = this.getCurrentReactContext();
        if (currentReactContext != null && (appearanceModule = currentReactContext.getNativeModule(AppearanceModule.class)) != null) {
            appearanceModule.onConfigurationChanged(updatedContext);
        }
    }

    @Nullable
    JavaScriptContextHolder getJavaScriptContextHolder() {
        ReactInstance reactInstance = this.mReactInstance;
        if (reactInstance != null) {
            return reactInstance.getJavaScriptContextHolder();
        }
        return null;
    }

    DefaultHardwareBackBtnHandler getDefaultBackButtonHandler() {
        return () -> {
            UiThreadUtil.assertOnUiThread();
            if (this.mDefaultHardwareBackBtnHandler != null) {
                this.mDefaultHardwareBackBtnHandler.invokeDefaultOnBackPressed();
            }
        };
    }

    Task<Boolean> loadBundle(JSBundleLoader bundleLoader) {
        String method = "loadBundle()";
        this.log("loadBundle()", "Schedule");
        return this.callWithExistingReactInstance("loadBundle()", reactInstance -> {
            this.log("loadBundle()", "Execute");
            reactInstance.loadJSBundle(bundleLoader);
        }, null);
    }

    Task<Boolean> registerSegment(int segmentId, String path, Callback callback) {
        String method = "registerSegment(segmentId = \"" + segmentId + "\", path = \"" + path + "\")";
        this.log(method, "Schedule");
        return this.callWithExistingReactInstance(method, reactInstance -> {
            this.log(method, "Execute");
            reactInstance.registerSegment(segmentId, path);
            ((Callback)Assertions.assertNotNull((Object)callback)).invoke(new Object[0]);
        }, null);
    }

    void handleHostException(Exception e) {
        String method = "handleHostException(message = \"" + e.getMessage() + "\")";
        this.log(method);
        if (this.mUseDevSupport) {
            this.mDevSupportManager.handleException(e);
        } else {
            this.mReactHostDelegate.handleInstanceException(e);
        }
        this.destroy(method, e);
    }

    Task<Boolean> callFunctionOnModule(String moduleName, String methodName, NativeArray args) {
        String method = "callFunctionOnModule(\"" + moduleName + "\", \"" + methodName + "\")";
        return this.callWithExistingReactInstance(method, reactInstance -> reactInstance.callFunctionOnModule(moduleName, methodName, args), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachSurface(ReactSurfaceImpl surface) {
        String method = "attachSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method);
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            this.mAttachedSurfaces.add(surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachSurface(ReactSurfaceImpl surface) {
        String method = "detachSurface(surfaceId = " + surface.getSurfaceID() + ")";
        this.log(method);
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            this.mAttachedSurfaces.remove(surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSurfaceAttached(ReactSurfaceImpl surface) {
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            return this.mAttachedSurfaces.contains(surface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSurfaceWithModuleNameAttached(String moduleName) {
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            for (ReactSurfaceImpl surface : this.mAttachedSurfaces) {
                if (!surface.getModuleName().equals(moduleName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBeforeDestroyListener(@NonNull Function0<Unit> onBeforeDestroy) {
        List<Function0<Unit>> list = this.mBeforeDestroyListeners;
        synchronized (list) {
            this.mBeforeDestroyListeners.add(onBeforeDestroy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeforeDestroyListener(@NonNull Function0<Unit> onBeforeDestroy) {
        List<Function0<Unit>> list = this.mBeforeDestroyListeners;
        synchronized (list) {
            this.mBeforeDestroyListeners.remove(onBeforeDestroy);
        }
    }

    @ThreadConfined(value="ReactHost")
    private Task<Void> getOrCreateStartTask() {
        String method = "getOrCreateStartTask()";
        if (this.mStartTask == null) {
            this.log("getOrCreateStartTask()", "Schedule");
            this.mStartTask = this.waitThenCallGetOrCreateReactInstanceTask().continueWithTask(task -> {
                if (task.isFaulted()) {
                    Exception ex = task.getError();
                    if (this.mUseDevSupport) {
                        this.mDevSupportManager.handleException(ex);
                    } else {
                        this.mReactHostDelegate.handleInstanceException(ex);
                    }
                    return this.getOrCreateDestroyTask("getOrCreateStartTask() failure: " + task.getError().getMessage(), task.getError()).continueWithTask(destroyTask -> Task.forError(task.getError())).makeVoid();
                }
                return task.makeVoid();
            }, this.mBGExecutor);
        }
        return this.mStartTask;
    }

    @ThreadConfined(value="UI")
    private void moveToHostDestroy(@Nullable ReactContext currentContext) {
        this.mReactLifecycleStateManager.moveToOnHostDestroy(currentContext);
        this.setCurrentActivity(null);
    }

    private void raiseSoftException(String callingMethod, String message) {
        this.raiseSoftException(callingMethod, message, null);
    }

    private void raiseSoftException(String callingMethod, String message, @Nullable Throwable throwable) {
        String method = "raiseSoftException(" + callingMethod + ")";
        this.log(method, message);
        ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException(method + ": " + message, throwable));
    }

    private Executor getDefaultReactInstanceExecutor() {
        return ReactNativeFeatureFlags.useImmediateExecutorInAndroidBridgeless() ? Task.IMMEDIATE_EXECUTOR : this.mBGExecutor;
    }

    private Task<Boolean> callWithExistingReactInstance(String callingMethod, ReactInstanceCalback continuation, @Nullable Executor executor) {
        String method = "callWithExistingReactInstance(" + callingMethod + ")";
        if (executor == null) {
            executor = this.getDefaultReactInstanceExecutor();
        }
        return this.mCreateReactInstanceTaskRef.get().onSuccess(task -> {
            ReactInstance reactInstance;
            ReactInstance reactInstance2 = reactInstance = ReactNativeFeatureFlags.completeReactInstanceCreationOnBgThreadOnAndroid() ? (ReactInstance)task.getResult() : this.mReactInstance;
            if (reactInstance == null) {
                this.raiseSoftException(method, "Execute: reactInstance is null. Dropping work.");
                return Boolean.FALSE;
            }
            continuation.then(reactInstance);
            return Boolean.TRUE;
        }, executor);
    }

    private Task<Void> callAfterGetOrCreateReactInstance(String callingMethod, ReactInstanceCalback runnable, @Nullable Executor executor) {
        String method = "callAfterGetOrCreateReactInstance(" + callingMethod + ")";
        if (executor == null) {
            executor = this.getDefaultReactInstanceExecutor();
        }
        return this.getOrCreateReactInstance().onSuccess(task -> {
            ReactInstance reactInstance;
            ReactInstance reactInstance2 = reactInstance = ReactNativeFeatureFlags.completeReactInstanceCreationOnBgThreadOnAndroid() ? (ReactInstance)task.getResult() : this.mReactInstance;
            if (reactInstance == null) {
                this.raiseSoftException(method, "Execute: reactInstance is null. Dropping work.");
                return null;
            }
            runnable.then(reactInstance);
            return null;
        }, executor).continueWith(task -> {
            if (task.isFaulted()) {
                this.handleHostException(task.getError());
            }
            return null;
        });
    }

    private BridgelessReactContext getOrCreateReactContext() {
        String method = "getOrCreateReactContext()";
        return this.mBridgelessReactContextRef.getOrCreate(() -> {
            this.log("getOrCreateReactContext()", "Creating BridgelessReactContext");
            return new BridgelessReactContext(this.mContext, this);
        });
    }

    private Task<ReactInstance> getOrCreateReactInstance() {
        return Task.call(this::waitThenCallGetOrCreateReactInstanceTask, this.mBGExecutor).continueWithTask(Task::getResult);
    }

    @ThreadConfined(value="ReactHost")
    private Task<ReactInstance> waitThenCallGetOrCreateReactInstanceTask() {
        return this.waitThenCallGetOrCreateReactInstanceTaskWithRetries(0, 4);
    }

    @ThreadConfined(value="ReactHost")
    private Task<ReactInstance> waitThenCallGetOrCreateReactInstanceTaskWithRetries(int tryNum, int maxTries) {
        String method = "waitThenCallGetOrCreateReactInstanceTaskWithRetries";
        if (this.mReloadTask != null) {
            this.log("waitThenCallGetOrCreateReactInstanceTaskWithRetries", "React Native is reloading. Return reload task.");
            return this.mReloadTask;
        }
        if (this.mDestroyTask != null) {
            boolean shouldTryAgain;
            boolean bl = shouldTryAgain = tryNum < maxTries;
            if (shouldTryAgain) {
                this.log("waitThenCallGetOrCreateReactInstanceTaskWithRetries", "React Native is tearing down.Wait for teardown to finish, before trying again (try count = " + tryNum + ").");
                return this.mDestroyTask.onSuccessTask(task -> this.waitThenCallGetOrCreateReactInstanceTaskWithRetries(tryNum + 1, maxTries), this.mBGExecutor);
            }
            this.raiseSoftException("waitThenCallGetOrCreateReactInstanceTaskWithRetries", "React Native is tearing down. Not wait for teardown to finish: reached max retries.");
        }
        return this.getOrCreateReactInstanceTask();
    }

    @ThreadConfined(value="ReactHost")
    private Task<ReactInstance> getOrCreateReactInstanceTask() {
        String method = "getOrCreateReactInstanceTask()";
        this.log("getOrCreateReactInstanceTask()");
        return this.mCreateReactInstanceTaskRef.getOrCreate(() -> {
            this.log("getOrCreateReactInstanceTask()", "Start");
            Assertions.assertCondition((!this.mHostInvalidated ? 1 : 0) != 0, (String)"Cannot start a new ReactInstance on an invalidated ReactHost");
            ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGELESS_LOADING_START, 1);
            Task<CreationResult> creationTask = this.getJsBundleLoader().onSuccess(task -> {
                MemoryPressureListener memoryPressureListener;
                ReactInstance instance;
                JSBundleLoader bundleLoader = (JSBundleLoader)task.getResult();
                BridgelessReactContext reactContext = this.getOrCreateReactContext();
                DevSupportManager devSupportManager = this.getDevSupportManager();
                reactContext.setJSExceptionHandler(devSupportManager);
                this.log("getOrCreateReactInstanceTask()", "Creating ReactInstance");
                this.mReactInstance = instance = new ReactInstance(reactContext, this.mReactHostDelegate, this.mComponentFactory, devSupportManager, this::handleHostException, this.mUseDevSupport, this.getOrCreateReactHostInspectorTarget());
                this.mMemoryPressureListener = memoryPressureListener = this.createMemoryPressureListener(instance);
                this.mMemoryPressureRouter.addMemoryPressureListener(memoryPressureListener);
                instance.initializeEagerTurboModules();
                this.log("getOrCreateReactInstanceTask()", "Loading JS Bundle");
                instance.loadJSBundle(bundleLoader);
                this.log("getOrCreateReactInstanceTask()", "Calling DevSupportManagerBase.onNewReactContextCreated(reactContext)");
                devSupportManager.onNewReactContextCreated(reactContext);
                reactContext.runOnJSQueueThread(() -> ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGELESS_LOADING_END, 1));
                return new CreationResult(instance, reactContext, this.mReloadTask != null);
            }, this.mBGExecutor);
            Continuation lifecycleUpdateTask = task -> {
                boolean isManagerResumed;
                ReactInstance reactInstance = ((CreationResult)task.getResult()).mInstance;
                ReactContext reactContext = ((CreationResult)task.getResult()).mContext;
                boolean isReloading = ((CreationResult)task.getResult()).mIsReloading;
                boolean bl = isManagerResumed = this.mReactLifecycleStateManager.getLifecycleState() == LifecycleState.RESUMED;
                if (isReloading && !isManagerResumed) {
                    this.mReactLifecycleStateManager.moveToOnHostResume(reactContext, this.getCurrentActivity());
                } else {
                    this.mReactLifecycleStateManager.resumeReactContextIfHostResumed(reactContext, this.getCurrentActivity());
                }
                this.log("getOrCreateReactInstanceTask()", "Executing ReactInstanceEventListeners");
                ReactInstanceEventListener[] reactInstanceEventListenerArray = this.mReactInstanceEventListeners;
                synchronized (this.mReactInstanceEventListeners) {
                    ReactInstanceEventListener[] instanceEventListeners = this.mReactInstanceEventListeners.toArray(new ReactInstanceEventListener[0]);
                    // ** MonitorExit[var7_6] (shouldn't be in output)
                    for (ReactInstanceEventListener listener : instanceEventListeners) {
                        if (listener == null) continue;
                        listener.onReactContextInitialized(reactContext);
                    }
                    return reactInstance;
                }
            };
            if (ReactNativeFeatureFlags.completeReactInstanceCreationOnBgThreadOnAndroid()) {
                creationTask.onSuccess(lifecycleUpdateTask, this.mUIExecutor);
                return creationTask.onSuccess(task -> ((CreationResult)task.getResult()).mInstance, Task.IMMEDIATE_EXECUTOR);
            }
            return creationTask.onSuccess(lifecycleUpdateTask, this.mUIExecutor);
        });
    }

    private Task<JSBundleLoader> getJsBundleLoader() {
        String method = "getJSBundleLoader()";
        this.log("getJSBundleLoader()");
        if (this.mUseDevSupport && this.mAllowPackagerServerAccess) {
            return this.isMetroRunning().onSuccessTask(task -> {
                boolean isMetroRunning = (Boolean)task.getResult();
                if (isMetroRunning) {
                    return this.loadJSBundleFromMetro();
                }
                return Task.forResult(this.mReactHostDelegate.getJsBundleLoader());
            }, this.mBGExecutor);
        }
        if (ReactBuildConfig.DEBUG) {
            FLog.d((String)TAG, (String)"Packager server access is disabled in this environment");
        }
        return Task.call(() -> this.mReactHostDelegate.getJsBundleLoader());
    }

    private Task<Boolean> isMetroRunning() {
        String method = "isMetroRunning()";
        this.log("isMetroRunning()");
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        DevSupportManager asyncDevSupportManager = this.getDevSupportManager();
        asyncDevSupportManager.isPackagerRunning(packagerIsRunning -> {
            this.log("isMetroRunning()", "Async result = " + packagerIsRunning);
            taskCompletionSource.setResult(packagerIsRunning);
        });
        return taskCompletionSource.getTask();
    }

    private Task<JSBundleLoader> loadJSBundleFromMetro() {
        String method = "loadJSBundleFromMetro()";
        this.log("loadJSBundleFromMetro()");
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        final DevSupportManagerBase asyncDevSupportManager = (DevSupportManagerBase)this.getDevSupportManager();
        final String bundleURL = asyncDevSupportManager.getDevServerHelper().getDevServerBundleURL((String)Assertions.assertNotNull((Object)asyncDevSupportManager.getJSAppBundleName()));
        asyncDevSupportManager.reloadJSFromServer(bundleURL, new BundleLoadCallback(){

            @Override
            public void onSuccess() {
                ReactHostImpl.this.log("loadJSBundleFromMetro()", "Creating BundleLoader");
                JSBundleLoader bundleLoader = JSBundleLoader.createCachedBundleFromNetworkLoader(bundleURL, asyncDevSupportManager.getDownloadedJSBundleFile());
                taskCompletionSource.setResult(bundleLoader);
            }

            @Override
            public void onError(Exception cause) {
                taskCompletionSource.setError(cause);
            }
        });
        return taskCompletionSource.getTask();
    }

    private void log(String method, String message) {
        this.mBridgelessReactStateTracker.enterState("ReactHost{" + this.mId + "}." + method + ": " + message);
    }

    private void log(String method) {
        this.mBridgelessReactStateTracker.enterState("ReactHost{" + this.mId + "}." + method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAttachedSurfaces(String method, ReactInstance reactInstance) {
        this.log(method, "Stopping all React Native surfaces");
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            for (ReactSurfaceImpl surface : this.mAttachedSurfaces) {
                reactInstance.stopSurface(surface);
                surface.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAttachedSurfaces(String method, ReactInstance reactInstance) {
        this.log(method, "Restarting previously running React Native Surfaces");
        Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
        synchronized (set) {
            for (ReactSurfaceImpl surface : this.mAttachedSurfaces) {
                reactInstance.startSurface(surface);
            }
        }
    }

    private ReactInstanceTaskUnwrapper createReactInstanceUnwrapper(String tag, String method, String reason) {
        return (task, stage) -> {
            ReactInstance reactInstance = (ReactInstance)task.getResult();
            ReactInstance currentReactInstance = this.mReactInstance;
            String stageLabel = "Stage: " + stage;
            String reasonLabel = tag + " reason: " + reason;
            if (task.isFaulted()) {
                Exception ex = task.getError();
                String faultLabel = "Fault reason: " + ex.getMessage();
                this.raiseSoftException(method, tag + ": ReactInstance task faulted. " + stageLabel + ". " + faultLabel + ". " + reasonLabel);
                return currentReactInstance;
            }
            if (task.isCancelled()) {
                this.raiseSoftException(method, tag + ": ReactInstance task cancelled. " + stageLabel + ". " + reasonLabel);
                return currentReactInstance;
            }
            if (reactInstance == null) {
                this.raiseSoftException(method, tag + ": ReactInstance task returned null. " + stageLabel + ". " + reasonLabel);
                return currentReactInstance;
            }
            if (currentReactInstance != null && reactInstance != currentReactInstance) {
                this.raiseSoftException(method, tag + ": Detected two different ReactInstances. Returning old. " + stageLabel + ". " + reasonLabel);
            }
            return reactInstance;
        };
    }

    @ThreadConfined(value="ReactHost")
    private Task<ReactInstance> getOrCreateReloadTask(String reason) {
        String method = "getOrCreateReloadTask()";
        this.log("getOrCreateReloadTask()");
        this.raiseSoftException("getOrCreateReloadTask()", reason);
        ReactInstanceTaskUnwrapper reactInstanceTaskUnwrapper = this.createReactInstanceUnwrapper("Reload", "getOrCreateReloadTask()", reason);
        if (this.mReloadTask == null) {
            this.mReloadTask = this.mCreateReactInstanceTaskRef.get().continueWithTask(task -> {
                this.log("getOrCreateReloadTask()", "Starting React Native reload");
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "1: Starting reload");
                this.unregisterInstanceFromInspector(reactInstance);
                ReactContext reactContext = this.mBridgelessReactContextRef.getNullable();
                if (reactContext == null) {
                    this.raiseSoftException("getOrCreateReloadTask()", "ReactContext is null. Reload reason: " + reason);
                }
                if (reactContext != null && this.mReactLifecycleStateManager.getLifecycleState() == LifecycleState.RESUMED) {
                    this.log("getOrCreateReloadTask()", "Calling ReactContext.onHostPause()");
                    reactContext.onHostPause();
                }
                return Task.forResult(reactInstance);
            }, this.mUIExecutor).continueWithTask(task -> {
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "2: Surface shutdown");
                if (reactInstance == null) {
                    this.raiseSoftException("getOrCreateReloadTask()", "Skipping surface shutdown: ReactInstance null");
                    return task;
                }
                this.stopAttachedSurfaces("getOrCreateReloadTask()", reactInstance);
                return task;
            }, this.mBGExecutor).continueWithTask(task -> {
                reactInstanceTaskUnwrapper.unwrap(task, "3: Executing Before Destroy Listeners");
                Function0[] function0Array = this.mBeforeDestroyListeners;
                synchronized (this.mBeforeDestroyListeners) {
                    Function0[] beforeDestroyListeners = this.mBeforeDestroyListeners.toArray(new Function0[0]);
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    for (Function0 destroyListener : beforeDestroyListeners) {
                        destroyListener.invoke();
                    }
                    return task;
                }
            }, this.mUIExecutor).continueWithTask(task -> {
                ReactContext reactContext;
                reactInstanceTaskUnwrapper.unwrap(task, "4: Destroying ReactContext");
                if (this.mMemoryPressureListener != null) {
                    this.log("getOrCreateReloadTask()", "Removing memory pressure listener");
                    this.mMemoryPressureRouter.removeMemoryPressureListener(this.mMemoryPressureListener);
                }
                if ((reactContext = (ReactContext)this.mBridgelessReactContextRef.getNullable()) != null) {
                    this.log("getOrCreateReloadTask()", "Resetting ReactContext ref");
                    this.mBridgelessReactContextRef.reset();
                    this.log("getOrCreateReloadTask()", "Destroying ReactContext");
                    reactContext.destroy();
                }
                if (this.mUseDevSupport && reactContext != null) {
                    this.log("getOrCreateReloadTask()", "Calling DevSupportManager.onReactInstanceDestroyed(reactContext)");
                    this.mDevSupportManager.onReactInstanceDestroyed(reactContext);
                }
                return task;
            }, this.mUIExecutor).continueWithTask(task -> {
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "5: Destroying ReactInstance");
                if (reactInstance == null) {
                    this.raiseSoftException("getOrCreateReloadTask()", "Skipping ReactInstance.destroy(): ReactInstance null");
                } else {
                    this.log("getOrCreateReloadTask()", "Resetting ReactInstance ptr");
                    this.mReactInstance = null;
                    this.log("getOrCreateReloadTask()", "Destroying ReactInstance");
                    reactInstance.destroy();
                }
                this.log("getOrCreateReloadTask()", "Resetting createReactInstance task ref");
                this.mCreateReactInstanceTaskRef.reset();
                this.log("getOrCreateReloadTask()", "Resetting start task ref");
                this.mStartTask = null;
                return this.getOrCreateReactInstanceTask();
            }, this.mBGExecutor).continueWithTask(task -> {
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "6: Restarting surfaces");
                if (reactInstance == null) {
                    this.raiseSoftException("getOrCreateReloadTask()", "Skipping surface restart: ReactInstance null");
                    return task;
                }
                this.startAttachedSurfaces("getOrCreateReloadTask()", reactInstance);
                return task;
            }, this.mBGExecutor).continueWithTask(task -> {
                if (task.isFaulted()) {
                    Exception fault = task.getError();
                    this.raiseSoftException("getOrCreateReloadTask()", "Error during reload. ReactInstance task faulted. Fault reason: " + fault.getMessage() + ". Reload reason: " + reason, task.getError());
                }
                if (task.isCancelled()) {
                    this.raiseSoftException("getOrCreateReloadTask()", "Error during reload. ReactInstance task cancelled. Reload reason: " + reason);
                }
                this.log("getOrCreateReloadTask()", "Resetting reload task ref");
                this.mReloadTask = null;
                return task;
            }, this.mBGExecutor);
        }
        return this.mReloadTask;
    }

    @ThreadConfined(value="ReactHost")
    private Task<Void> getOrCreateDestroyTask(String reason, @Nullable Exception ex) {
        String method = "getOrCreateDestroyTask()";
        this.log("getOrCreateDestroyTask()");
        this.raiseSoftException("getOrCreateDestroyTask()", reason, ex);
        ReactInstanceTaskUnwrapper reactInstanceTaskUnwrapper = this.createReactInstanceUnwrapper("Destroy", "getOrCreateDestroyTask()", reason);
        if (this.mDestroyTask == null) {
            this.mDestroyTask = this.mCreateReactInstanceTaskRef.get().continueWithTask(task -> {
                ReactContext reactContext;
                this.log("getOrCreateDestroyTask()", "Starting React Native destruction");
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "1: Starting destroy");
                this.unregisterInstanceFromInspector(reactInstance);
                if (this.mHostInvalidated && this.mReactHostInspectorTarget != null) {
                    this.mReactHostInspectorTarget.close();
                    this.mReactHostInspectorTarget = null;
                }
                if (this.mUseDevSupport) {
                    this.log("getOrCreateDestroyTask()", "DevSupportManager cleanup");
                    this.mDevSupportManager.stopInspector();
                }
                if ((reactContext = (ReactContext)this.mBridgelessReactContextRef.getNullable()) == null) {
                    this.raiseSoftException("getOrCreateDestroyTask()", "ReactContext is null. Destroy reason: " + reason);
                }
                this.log("getOrCreateDestroyTask()", "Move ReactHost to onHostDestroy()");
                this.mReactLifecycleStateManager.moveToOnHostDestroy(reactContext);
                return Task.forResult(reactInstance);
            }, this.mUIExecutor).continueWithTask(task -> {
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "2: Stopping surfaces");
                if (reactInstance == null) {
                    this.raiseSoftException("getOrCreateDestroyTask()", "Skipping surface shutdown: ReactInstance null");
                    return task;
                }
                this.stopAttachedSurfaces("getOrCreateDestroyTask()", reactInstance);
                Set<ReactSurfaceImpl> set = this.mAttachedSurfaces;
                synchronized (set) {
                    this.mAttachedSurfaces.clear();
                }
                return task;
            }, this.mBGExecutor).continueWithTask(task -> {
                HashSet<Function0<Unit>> beforeDestroyListeners;
                reactInstanceTaskUnwrapper.unwrap(task, "3: Executing Before Destroy Listeners");
                List<Function0<Unit>> list = this.mBeforeDestroyListeners;
                synchronized (list) {
                    beforeDestroyListeners = new HashSet<Function0<Unit>>(this.mBeforeDestroyListeners);
                }
                for (Function0 function0 : beforeDestroyListeners) {
                    function0.invoke();
                }
                return task;
            }, this.mUIExecutor).continueWithTask(task -> {
                reactInstanceTaskUnwrapper.unwrap(task, "4: Destroying ReactContext");
                ReactContext reactContext = this.mBridgelessReactContextRef.getNullable();
                if (reactContext == null) {
                    this.raiseSoftException("getOrCreateDestroyTask()", "ReactContext is null. Destroy reason: " + reason);
                }
                this.log("getOrCreateDestroyTask()", "Destroying MemoryPressureRouter");
                this.mMemoryPressureRouter.destroy(this.mContext);
                if (reactContext != null) {
                    this.log("getOrCreateDestroyTask()", "Resetting ReactContext ref");
                    this.mBridgelessReactContextRef.reset();
                    this.log("getOrCreateDestroyTask()", "Destroying ReactContext");
                    reactContext.destroy();
                }
                this.setCurrentActivity(null);
                ResourceDrawableIdHelper.getInstance().clear();
                return task;
            }, this.mUIExecutor).continueWithTask(task -> {
                ReactInstance reactInstance = reactInstanceTaskUnwrapper.unwrap(task, "5: Destroying ReactInstance");
                if (reactInstance == null) {
                    this.raiseSoftException("getOrCreateDestroyTask()", "Skipping ReactInstance.destroy(): ReactInstance null");
                } else {
                    this.log("getOrCreateDestroyTask()", "Resetting ReactInstance ptr");
                    this.mReactInstance = null;
                    this.log("getOrCreateDestroyTask()", "Destroying ReactInstance");
                    reactInstance.destroy();
                }
                this.log("getOrCreateDestroyTask()", "Resetting createReactInstance task ref");
                this.mCreateReactInstanceTaskRef.reset();
                this.log("getOrCreateDestroyTask()", "Resetting start task ref");
                this.mStartTask = null;
                this.log("getOrCreateDestroyTask()", "Resetting destroy task ref");
                this.mDestroyTask = null;
                return task;
            }, this.mBGExecutor).continueWith(task -> {
                if (task.isFaulted()) {
                    Exception fault = task.getError();
                    this.raiseSoftException("getOrCreateDestroyTask()", "React destruction failed. ReactInstance task faulted. Fault reason: " + fault.getMessage() + ". Destroy reason: " + reason, task.getError());
                }
                if (task.isCancelled()) {
                    this.raiseSoftException("getOrCreateDestroyTask()", "React destruction failed. ReactInstance task cancelled. Destroy reason: " + reason);
                }
                return null;
            });
        }
        return this.mDestroyTask;
    }

    @Nullable
    private ReactHostInspectorTarget getOrCreateReactHostInspectorTarget() {
        if (this.mReactHostInspectorTarget == null && InspectorFlags.getFuseboxEnabled()) {
            this.mReactHostInspectorTarget = new ReactHostInspectorTarget(this);
        }
        return this.mReactHostInspectorTarget;
    }

    @ThreadConfined(value="UI")
    private void unregisterInstanceFromInspector(@Nullable ReactInstance reactInstance) {
        if (reactInstance != null) {
            if (InspectorFlags.getFuseboxEnabled()) {
                Assertions.assertCondition((this.mReactHostInspectorTarget != null && this.mReactHostInspectorTarget.isValid() ? 1 : 0) != 0, (String)"Host inspector target destroyed before instance was unregistered");
            }
            reactInstance.unregisterFromInspector();
        }
    }

    @Override
    public void invalidate() {
        FLog.d((String)TAG, (String)"ReactHostImpl.invalidate()");
        this.mHostInvalidated = true;
        this.destroy("ReactHostImpl.invalidate()", null);
    }

    private static interface ReactInstanceCalback {
        public void then(ReactInstance var1);
    }

    private static interface ReactInstanceTaskUnwrapper {
        @Nullable
        public ReactInstance unwrap(Task<ReactInstance> var1, String var2);
    }

    private static class CreationResult {
        final ReactInstance mInstance;
        final ReactContext mContext;
        final boolean mIsReloading;

        private CreationResult(ReactInstance instance, ReactContext context, boolean isReloading) {
            this.mInstance = instance;
            this.mContext = context;
            this.mIsReloading = isReloading;
        }
    }
}

