/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.jstasks;

import android.util.SparseArray;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.jstasks.HeadlessJsTaskConfig;
import com.facebook.react.jstasks.HeadlessJsTaskEventListener;
import com.facebook.react.jstasks.HeadlessJsTaskRetryPolicy;
import com.facebook.react.modules.appregistry.AppRegistry;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;

public class HeadlessJsTaskContext {
    private static final WeakHashMap<ReactContext, HeadlessJsTaskContext> INSTANCES = new WeakHashMap();
    private final WeakReference<ReactContext> mReactContext;
    private final Set<HeadlessJsTaskEventListener> mHeadlessJsTaskEventListeners = new CopyOnWriteArraySet<HeadlessJsTaskEventListener>();
    private final AtomicInteger mLastTaskId = new AtomicInteger(0);
    private final Set<Integer> mActiveTasks = new CopyOnWriteArraySet<Integer>();
    private final Map<Integer, HeadlessJsTaskConfig> mActiveTaskConfigs = new ConcurrentHashMap<Integer, HeadlessJsTaskConfig>();
    private final SparseArray<Runnable> mTaskTimeouts = new SparseArray();

    public static HeadlessJsTaskContext getInstance(ReactContext context) {
        HeadlessJsTaskContext helper = INSTANCES.get((Object)context);
        if (helper == null) {
            helper = new HeadlessJsTaskContext(context);
            INSTANCES.put(context, helper);
        }
        return helper;
    }

    private HeadlessJsTaskContext(ReactContext reactContext) {
        this.mReactContext = new WeakReference<ReactContext>(reactContext);
    }

    public synchronized void addTaskEventListener(HeadlessJsTaskEventListener listener) {
        this.mHeadlessJsTaskEventListeners.add(listener);
        for (Integer activeTaskId : this.mActiveTasks) {
            listener.onHeadlessJsTaskStart(activeTaskId);
        }
    }

    public void removeTaskEventListener(HeadlessJsTaskEventListener listener) {
        this.mHeadlessJsTaskEventListeners.remove(listener);
    }

    public boolean hasActiveTasks() {
        return this.mActiveTasks.size() > 0;
    }

    public synchronized int startTask(HeadlessJsTaskConfig taskConfig) {
        int taskId = this.mLastTaskId.incrementAndGet();
        this.startTask(taskConfig, taskId);
        return taskId;
    }

    private synchronized void startTask(HeadlessJsTaskConfig taskConfig, int taskId) {
        UiThreadUtil.assertOnUiThread();
        ReactContext reactContext = (ReactContext)((Object)Assertions.assertNotNull((Object)((Object)((ReactContext)((Object)this.mReactContext.get()))), (String)"Tried to start a task on a react context that has already been destroyed"));
        if (reactContext.getLifecycleState() == LifecycleState.RESUMED && !taskConfig.isAllowedInForeground()) {
            throw new IllegalStateException("Tried to start task " + taskConfig.getTaskKey() + " while in foreground, but this is not allowed.");
        }
        this.mActiveTasks.add(taskId);
        this.mActiveTaskConfigs.put(taskId, new HeadlessJsTaskConfig(taskConfig));
        if (reactContext.hasActiveReactInstance()) {
            reactContext.getJSModule(AppRegistry.class).startHeadlessTask(taskId, taskConfig.getTaskKey(), taskConfig.getData());
        } else {
            ReactSoftExceptionLogger.logSoftException("HeadlessJsTaskContext", new RuntimeException("Cannot start headless task, CatalystInstance not available"));
        }
        if (taskConfig.getTimeout() > 0L) {
            this.scheduleTaskTimeout(taskId, taskConfig.getTimeout());
        }
        for (HeadlessJsTaskEventListener listener : this.mHeadlessJsTaskEventListeners) {
            listener.onHeadlessJsTaskStart(taskId);
        }
    }

    public synchronized boolean retryTask(final int taskId) {
        HeadlessJsTaskConfig sourceTaskConfig = this.mActiveTaskConfigs.get(taskId);
        Assertions.assertCondition((sourceTaskConfig != null ? 1 : 0) != 0, (String)("Tried to retrieve non-existent task config with id " + taskId + "."));
        HeadlessJsTaskRetryPolicy retryPolicy = sourceTaskConfig.getRetryPolicy();
        if (!retryPolicy.canRetry()) {
            return false;
        }
        this.removeTimeout(taskId);
        final HeadlessJsTaskConfig taskConfig = new HeadlessJsTaskConfig(sourceTaskConfig.getTaskKey(), sourceTaskConfig.getData(), sourceTaskConfig.getTimeout(), sourceTaskConfig.isAllowedInForeground(), retryPolicy.update());
        Runnable retryAttempt = new Runnable(){

            @Override
            public void run() {
                HeadlessJsTaskContext.this.startTask(taskConfig, taskId);
            }
        };
        UiThreadUtil.runOnUiThread(retryAttempt, retryPolicy.getDelay());
        return true;
    }

    public synchronized void finishTask(final int taskId) {
        boolean removed = this.mActiveTasks.remove(taskId);
        this.mActiveTaskConfigs.remove(taskId);
        this.removeTimeout(taskId);
        if (removed) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    for (HeadlessJsTaskEventListener listener : HeadlessJsTaskContext.this.mHeadlessJsTaskEventListeners) {
                        listener.onHeadlessJsTaskFinish(taskId);
                    }
                }
            });
        }
    }

    private void removeTimeout(int taskId) {
        Runnable runnable = (Runnable)this.mTaskTimeouts.get(taskId);
        if (runnable != null) {
            UiThreadUtil.removeOnUiThread(runnable);
            this.mTaskTimeouts.remove(taskId);
        }
    }

    public synchronized boolean isTaskRunning(int taskId) {
        return this.mActiveTasks.contains(taskId);
    }

    private void scheduleTaskTimeout(int taskId, long timeout) {
        Runnable runnable = () -> this.finishTask(taskId);
        this.mTaskTimeouts.append(taskId, (Object)runnable);
        UiThreadUtil.runOnUiThread(runnable, timeout);
    }
}

