/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Sink;

class MultipartStreamReader {
    private static final String CRLF = "\r\n";
    private final BufferedSource mSource;
    private final String mBoundary;
    private long mLastProgressEvent;

    public MultipartStreamReader(BufferedSource source, String boundary) {
        this.mSource = source;
        this.mBoundary = boundary;
    }

    private Map<String, String> parseHeaders(Buffer data) {
        String[] lines;
        HashMap<String, String> headers = new HashMap<String, String>();
        String text = data.readUtf8();
        for (String line : lines = text.split(CRLF)) {
            int indexOfSeparator = line.indexOf(":");
            if (indexOfSeparator == -1) continue;
            String key = line.substring(0, indexOfSeparator).trim();
            String value = line.substring(indexOfSeparator + 1).trim();
            headers.put(key, value);
        }
        return headers;
    }

    private void emitChunk(Buffer chunk, boolean done, ChunkListener listener) throws IOException {
        ByteString marker = ByteString.encodeUtf8((String)"\r\n\r\n");
        long indexOfMarker = chunk.indexOf(marker);
        if (indexOfMarker == -1L) {
            listener.onChunkComplete(null, chunk, done);
        } else {
            Buffer headers = new Buffer();
            Buffer body = new Buffer();
            chunk.read(headers, indexOfMarker);
            chunk.skip((long)marker.size());
            chunk.readAll((Sink)body);
            listener.onChunkComplete(this.parseHeaders(headers), body, done);
        }
    }

    private void emitProgress(Map<String, String> headers, long contentLength, boolean isFinal, ChunkListener listener) throws IOException {
        if (headers == null || listener == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.mLastProgressEvent > 16L || isFinal) {
            this.mLastProgressEvent = currentTime;
            long headersContentLength = headers.get("Content-Length") != null ? Long.parseLong(headers.get("Content-Length")) : 0L;
            listener.onChunkProgress(headers, contentLength, headersContentLength);
        }
    }

    public boolean readAllParts(ChunkListener listener) throws IOException {
        ByteString delimiter = ByteString.encodeUtf8((String)("\r\n--" + this.mBoundary + CRLF));
        ByteString closeDelimiter = ByteString.encodeUtf8((String)("\r\n--" + this.mBoundary + "--" + CRLF));
        ByteString headersDelimiter = ByteString.encodeUtf8((String)"\r\n\r\n");
        int bufferLen = 4096;
        long chunkStart = 0L;
        long bytesSeen = 0L;
        Buffer content = new Buffer();
        Map<String, String> currentHeaders = null;
        long currentHeadersLength = 0L;
        while (true) {
            boolean isCloseDelimiter = false;
            long searchStart = Math.max(bytesSeen - (long)closeDelimiter.size(), chunkStart);
            long indexOfDelimiter = content.indexOf(delimiter, searchStart);
            if (indexOfDelimiter == -1L) {
                isCloseDelimiter = true;
                indexOfDelimiter = content.indexOf(closeDelimiter, searchStart);
            }
            if (indexOfDelimiter == -1L) {
                long bytesRead;
                bytesSeen = content.size();
                if (currentHeaders == null) {
                    long indexOfHeaders = content.indexOf(headersDelimiter, searchStart);
                    if (indexOfHeaders >= 0L) {
                        this.mSource.read(content, indexOfHeaders);
                        Buffer headers = new Buffer();
                        content.copyTo(headers, searchStart, indexOfHeaders - searchStart);
                        currentHeadersLength = headers.size() + (long)headersDelimiter.size();
                        currentHeaders = this.parseHeaders(headers);
                    }
                } else {
                    this.emitProgress(currentHeaders, content.size() - currentHeadersLength, false, listener);
                }
                if ((bytesRead = this.mSource.read(content, (long)bufferLen)) > 0L) continue;
                return false;
            }
            long chunkEnd = indexOfDelimiter;
            long length = chunkEnd - chunkStart;
            if (chunkStart > 0L) {
                Buffer chunk = new Buffer();
                content.skip(chunkStart);
                content.read(chunk, length);
                this.emitProgress(currentHeaders, chunk.size() - currentHeadersLength, true, listener);
                this.emitChunk(chunk, isCloseDelimiter, listener);
                currentHeaders = null;
                currentHeadersLength = 0L;
            } else {
                content.skip(chunkEnd);
            }
            if (isCloseDelimiter) {
                return true;
            }
            bytesSeen = chunkStart = (long)delimiter.size();
        }
    }

    public static interface ChunkListener {
        public void onChunkComplete(Map<String, String> var1, Buffer var2, boolean var3) throws IOException;

        public void onChunkProgress(Map<String, String> var1, long var2, long var4) throws IOException;
    }
}

