/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Application;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.JSEngineResolutionAlgorithm;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactInstanceManagerBuilder;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.bridge.JSExceptionHandler;
import com.facebook.react.bridge.JavaScriptExecutorFactory;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.UIManagerProvider;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.common.SurfaceDelegate;
import com.facebook.react.common.SurfaceDelegateFactory;
import com.facebook.react.devsupport.DevSupportManagerFactory;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import com.facebook.react.devsupport.interfaces.PausedInDebuggerOverlayManager;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import com.facebook.react.internal.ChoreographerProvider;
import java.util.List;

public abstract class ReactNativeHost {
    private final Application mApplication;
    @Nullable
    private ReactInstanceManager mReactInstanceManager;

    protected ReactNativeHost(Application application) {
        this.mApplication = application;
    }

    public synchronized ReactInstanceManager getReactInstanceManager() {
        if (this.mReactInstanceManager == null) {
            ReactMarker.logMarker(ReactMarkerConstants.INIT_REACT_RUNTIME_START);
            ReactMarker.logMarker(ReactMarkerConstants.GET_REACT_INSTANCE_MANAGER_START);
            this.mReactInstanceManager = this.createReactInstanceManager();
            ReactMarker.logMarker(ReactMarkerConstants.GET_REACT_INSTANCE_MANAGER_END);
        }
        return this.mReactInstanceManager;
    }

    public synchronized boolean hasInstance() {
        return this.mReactInstanceManager != null;
    }

    public synchronized void clear() {
        if (this.mReactInstanceManager != null) {
            this.mReactInstanceManager.invalidate();
            this.mReactInstanceManager = null;
        }
    }

    protected ReactInstanceManager createReactInstanceManager() {
        ReactMarker.logMarker(ReactMarkerConstants.BUILD_REACT_INSTANCE_MANAGER_START);
        ReactInstanceManagerBuilder builder = this.getBaseReactInstanceManagerBuilder();
        ReactMarker.logMarker(ReactMarkerConstants.BUILD_REACT_INSTANCE_MANAGER_END);
        return builder.build();
    }

    protected ReactInstanceManagerBuilder getBaseReactInstanceManagerBuilder() {
        ReactInstanceManagerBuilder builder = ReactInstanceManager.builder().setApplication(this.mApplication).setJSMainModulePath(this.getJSMainModuleName()).setUseDeveloperSupport(this.getUseDeveloperSupport()).setDevSupportManagerFactory(this.getDevSupportManagerFactory()).setDevLoadingViewManager(this.getDevLoadingViewManager()).setRequireActivity(this.getShouldRequireActivity()).setSurfaceDelegateFactory(this.getSurfaceDelegateFactory()).setJSExceptionHandler(this.getJSExceptionHandler()).setLazyViewManagersEnabled(this.getLazyViewManagersEnabled()).setRedBoxHandler(this.getRedBoxHandler()).setJavaScriptExecutorFactory(this.getJavaScriptExecutorFactory()).setUIManagerProvider(this.getUIManagerProvider()).setInitialLifecycleState(LifecycleState.BEFORE_CREATE).setReactPackageTurboModuleManagerDelegateBuilder(this.getReactPackageTurboModuleManagerDelegateBuilder()).setJSEngineResolutionAlgorithm(this.getJSEngineResolutionAlgorithm()).setChoreographerProvider(this.getChoreographerProvider()).setPausedInDebuggerOverlayManager(this.getPausedInDebuggerOverlayManager());
        for (ReactPackage reactPackage : this.getPackages()) {
            builder.addPackage(reactPackage);
        }
        String jsBundleFile = this.getJSBundleFile();
        if (jsBundleFile != null) {
            builder.setJSBundleFile(jsBundleFile);
        } else {
            builder.setBundleAssetName((String)Assertions.assertNotNull((Object)this.getBundleAssetName()));
        }
        return builder;
    }

    @Nullable
    protected RedBoxHandler getRedBoxHandler() {
        return null;
    }

    @Nullable
    protected JSExceptionHandler getJSExceptionHandler() {
        return null;
    }

    @Nullable
    protected JavaScriptExecutorFactory getJavaScriptExecutorFactory() {
        return null;
    }

    @Nullable
    protected ReactPackageTurboModuleManagerDelegate.Builder getReactPackageTurboModuleManagerDelegateBuilder() {
        return null;
    }

    protected final Application getApplication() {
        return this.mApplication;
    }

    @Nullable
    protected UIManagerProvider getUIManagerProvider() {
        return reactApplicationContext -> null;
    }

    public boolean getShouldRequireActivity() {
        return true;
    }

    public boolean getLazyViewManagersEnabled() {
        return false;
    }

    public SurfaceDelegateFactory getSurfaceDelegateFactory() {
        return new SurfaceDelegateFactory(){

            @Override
            @Nullable
            public SurfaceDelegate createSurfaceDelegate(String moduleName) {
                return null;
            }
        };
    }

    @Nullable
    protected DevLoadingViewManager getDevLoadingViewManager() {
        return null;
    }

    @Nullable
    protected PausedInDebuggerOverlayManager getPausedInDebuggerOverlayManager() {
        return null;
    }

    protected String getJSMainModuleName() {
        return "index.android";
    }

    @Nullable
    protected String getJSBundleFile() {
        return null;
    }

    @Nullable
    protected String getBundleAssetName() {
        return "index.android.bundle";
    }

    public abstract boolean getUseDeveloperSupport();

    @Nullable
    protected DevSupportManagerFactory getDevSupportManagerFactory() {
        return null;
    }

    protected abstract List<ReactPackage> getPackages();

    @Nullable
    protected JSEngineResolutionAlgorithm getJSEngineResolutionAlgorithm() {
        return null;
    }

    @Nullable
    protected ChoreographerProvider getChoreographerProvider() {
        return null;
    }
}

