/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fbreact.specs;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class NativePlatformConstantsAndroidSpec
extends ReactContextBaseJavaModule
implements TurboModule {
    public static final String NAME = "PlatformConstants";

    public NativePlatformConstantsAndroidSpec(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    protected abstract Map<String, Object> getTypedExportedConstants();

    @Override
    @Nullable
    @DoNotStrip
    public final Map<String, Object> getConstants() {
        Map<String, Object> constants = this.getTypedExportedConstants();
        if (ReactBuildConfig.DEBUG || ReactBuildConfig.IS_INTERNAL_BUILD) {
            HashSet<String> obligatoryFlowConstants = new HashSet<String>(Arrays.asList("Brand", "Fingerprint", "Manufacturer", "Model", "Release", "Serial", "Version", "isTesting", "reactNativeVersion", "uiMode"));
            HashSet<String> optionalFlowConstants = new HashSet<String>(Arrays.asList("ServerHost", "isDisableAnimations"));
            HashSet<String> undeclaredConstants = new HashSet<String>(constants.keySet());
            undeclaredConstants.removeAll(obligatoryFlowConstants);
            undeclaredConstants.removeAll(optionalFlowConstants);
            if (!undeclaredConstants.isEmpty()) {
                throw new IllegalStateException(String.format("Native Module Flow doesn't declare constants: %s", undeclaredConstants));
            }
            undeclaredConstants = obligatoryFlowConstants;
            undeclaredConstants.removeAll(constants.keySet());
            if (!undeclaredConstants.isEmpty()) {
                throw new IllegalStateException(String.format("Native Module doesn't fill in constants: %s", undeclaredConstants));
            }
        }
        return constants;
    }

    @ReactMethod(isBlockingSynchronousMethod=true)
    @DoNotStrip
    public abstract String getAndroidID();
}

