/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.uimanager.drawable.CSSBackgroundDrawable;

@UnstableReactNativeAPI
public class ReactViewBackgroundManager {
    @Nullable
    private CSSBackgroundDrawable mCSSBackgroundDrawable;
    private View mView;
    private int mColor = 0;
    private Overflow mOverflow = Overflow.VISIBLE;

    public ReactViewBackgroundManager(View view) {
        this.mView = view;
    }

    public void cleanup() {
        ViewCompat.setBackground((View)this.mView, null);
        this.mView = null;
        this.mCSSBackgroundDrawable = null;
    }

    private CSSBackgroundDrawable getOrCreateReactViewBackground() {
        if (this.mCSSBackgroundDrawable == null) {
            this.mCSSBackgroundDrawable = new CSSBackgroundDrawable(this.mView.getContext());
            Drawable backgroundDrawable = this.mView.getBackground();
            ViewCompat.setBackground((View)this.mView, null);
            if (backgroundDrawable == null) {
                ViewCompat.setBackground((View)this.mView, (Drawable)this.mCSSBackgroundDrawable);
            } else {
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mCSSBackgroundDrawable, backgroundDrawable});
                ViewCompat.setBackground((View)this.mView, (Drawable)layerDrawable);
            }
        }
        return this.mCSSBackgroundDrawable;
    }

    public void setBackgroundColor(int color) {
        if (color != 0 || this.mCSSBackgroundDrawable != null) {
            this.getOrCreateReactViewBackground().setColor(color);
        }
    }

    public int getBackgroundColor() {
        return this.mColor;
    }

    public void setBorderWidth(int position, float width) {
        this.getOrCreateReactViewBackground().setBorderWidth(position, width);
    }

    public void setBorderColor(int position, @Nullable Integer color) {
        this.getOrCreateReactViewBackground().setBorderColor(position, color);
    }

    public int getBorderColor(int position) {
        return this.getOrCreateReactViewBackground().getBorderColor(position);
    }

    public void setBorderRadius(float borderRadius) {
        this.getOrCreateReactViewBackground().setRadius(borderRadius);
    }

    public void setBorderRadius(float borderRadius, int position) {
        this.getOrCreateReactViewBackground().setRadius(borderRadius, position);
    }

    public void setBorderStyle(@Nullable String style2) {
        this.getOrCreateReactViewBackground().setBorderStyle(style2);
    }

    public void setOverflow(@Nullable String overflow) {
        Overflow lastOverflow = this.mOverflow;
        this.mOverflow = "hidden".equals(overflow) ? Overflow.HIDDEN : ("scroll".equals(overflow) ? Overflow.SCROLL : Overflow.VISIBLE);
        if (lastOverflow != this.mOverflow) {
            this.mView.invalidate();
        }
    }

    public void maybeClipToPaddingBox(Canvas canvas) {
        if (this.mOverflow == Overflow.VISIBLE) {
            return;
        }
        Rect drawingRect = new Rect();
        this.mView.getDrawingRect(drawingRect);
        CSSBackgroundDrawable cssBackground = this.mCSSBackgroundDrawable;
        if (cssBackground == null) {
            canvas.clipRect(drawingRect);
            return;
        }
        Path paddingBoxPath = cssBackground.getPaddingBoxPath();
        if (paddingBoxPath != null) {
            paddingBoxPath.offset((float)drawingRect.left, (float)drawingRect.top);
            canvas.clipPath(paddingBoxPath);
        } else {
            RectF paddingBoxRect = cssBackground.getPaddingBoxRect();
            paddingBoxRect.offset((float)drawingRect.left, (float)drawingRect.top);
            canvas.clipRect(paddingBoxRect);
        }
    }

    private static enum Overflow {
        VISIBLE,
        HIDDEN,
        SCROLL;

    }
}

