/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.swiperefresh;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.NativeGestureUtil;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactSwipeRefreshLayout
extends SwipeRefreshLayout {
    private static final float DEFAULT_CIRCLE_TARGET = 64.0f;
    private boolean mDidLayout = false;
    private boolean mRefreshing = false;
    private float mProgressViewOffset = 0.0f;
    private int mTouchSlop;
    private float mPrevTouchX;
    private boolean mIntercepted;
    private boolean mNativeGestureStarted = false;

    public ReactSwipeRefreshLayout(ReactContext reactContext) {
        super((Context)reactContext);
        this.mTouchSlop = ViewConfiguration.get((Context)reactContext).getScaledTouchSlop();
    }

    public void setRefreshing(boolean refreshing) {
        this.mRefreshing = refreshing;
        if (this.mDidLayout) {
            super.setRefreshing(refreshing);
        }
    }

    public void setProgressViewOffset(float offset) {
        this.mProgressViewOffset = offset;
        if (this.mDidLayout) {
            int diameter = this.getProgressCircleDiameter();
            int start = Math.round(PixelUtil.toPixelFromDIP(offset)) - diameter;
            int end = Math.round(PixelUtil.toPixelFromDIP(offset + 64.0f) - (float)diameter);
            this.setProgressViewOffset(false, start, end);
        }
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mDidLayout) {
            this.mDidLayout = true;
            this.setProgressViewOffset(this.mProgressViewOffset);
            this.setRefreshing(this.mRefreshing);
        }
    }

    public boolean canChildScrollUp() {
        View firstChild = this.getChildAt(0);
        if (firstChild != null) {
            return firstChild.canScrollVertically(-1);
        }
        return super.canChildScrollUp();
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.shouldInterceptTouchEvent(ev) && super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
            this.mNativeGestureStarted = true;
            if (this.getParent() != null) {
                this.getParent().requestDisallowInterceptTouchEvent(true);
            }
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        if (action == 1 && this.mNativeGestureStarted) {
            NativeGestureUtil.notifyNativeGestureEnded((View)this, ev);
            this.mNativeGestureStarted = false;
        }
        return super.onTouchEvent(ev);
    }

    private boolean shouldInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mPrevTouchX = ev.getX();
                this.mIntercepted = false;
                break;
            }
            case 2: {
                float eventX = ev.getX();
                float xDiff = Math.abs(eventX - this.mPrevTouchX);
                if (!this.mIntercepted && !(xDiff > (float)this.mTouchSlop)) break;
                this.mIntercepted = true;
                return false;
            }
        }
        return true;
    }
}

