/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.graphics.Bitmap;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.MultiCacheKey;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.request.Postprocessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/views/image/MultiPostprocessor;", "Lcom/facebook/imagepipeline/request/Postprocessor;", "postprocessors", "", "(Ljava/util/List;)V", "getName", "", "getPostprocessorCacheKey", "Lcom/facebook/cache/common/CacheKey;", "process", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "sourceBitmap", "bitmapFactory", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nMultiPostprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPostprocessor.kt\ncom/facebook/react/views/image/MultiPostprocessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1549#2:63\n1620#2,3:64\n*S KotlinDebug\n*F\n+ 1 MultiPostprocessor.kt\ncom/facebook/react/views/image/MultiPostprocessor\n*L\n26#1:63\n26#1:64,3\n*E\n"})
public final class MultiPostprocessor
implements Postprocessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Postprocessor> postprocessors;

    private MultiPostprocessor(List<? extends Postprocessor> postprocessors) {
        this.postprocessors = new LinkedList(postprocessors);
    }

    @NotNull
    public String getName() {
        return "MultiPostProcessor (" + CollectionsKt.joinToString$default((Iterable)this.postprocessors, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ")";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CacheKey getPostprocessorCacheKey() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.postprocessors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Postprocessor postprocessor = (Postprocessor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPostprocessorCacheKey());
        }
        List list = (List)destination$iv$iv;
        return (CacheKey)new MultiCacheKey(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CloseableReference<Bitmap> process(@NotNull Bitmap sourceBitmap, @NotNull PlatformBitmapFactory bitmapFactory) {
        Intrinsics.checkNotNullParameter((Object)sourceBitmap, (String)"sourceBitmap");
        Intrinsics.checkNotNullParameter((Object)bitmapFactory, (String)"bitmapFactory");
        Bitmap prevBitmap = null;
        CloseableReference nextBitmap = null;
        try {
            for (Postprocessor p : this.postprocessors) {
                Bitmap bitmap = prevBitmap;
                if (bitmap == null || (bitmap = (Bitmap)bitmap.get()) == null) {
                    bitmap = sourceBitmap;
                }
                nextBitmap = p.process(bitmap, bitmapFactory);
                CloseableReference.closeSafely((CloseableReference)prevBitmap);
                prevBitmap = nextBitmap.clone();
            }
            if (nextBitmap == null) {
                boolean bl = false;
                String string2 = "MultiPostprocessor returned null bitmap - Number of Postprocessors: " + this.postprocessors.size();
                throw new IllegalStateException(string2.toString());
            }
            CloseableReference closeableReference = nextBitmap.clone();
            Intrinsics.checkNotNullExpressionValue((Object)closeableReference, (String)"clone(...)");
            CloseableReference closeableReference2 = closeableReference;
            return closeableReference2;
        }
        finally {
            CloseableReference.closeSafely(nextBitmap);
        }
    }

    @JvmStatic
    @Nullable
    public static final Postprocessor from(@NotNull List<? extends Postprocessor> postprocessors) {
        return Companion.from(postprocessors);
    }

    public /* synthetic */ MultiPostprocessor(List postprocessors, DefaultConstructorMarker $constructor_marker) {
        this(postprocessors);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/views/image/MultiPostprocessor$Companion;", "", "()V", "from", "Lcom/facebook/imagepipeline/request/Postprocessor;", "postprocessors", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Postprocessor from(@NotNull List<? extends Postprocessor> postprocessors) {
            Intrinsics.checkNotNullParameter(postprocessors, (String)"postprocessors");
            return switch (postprocessors.size()) {
                case 0 -> null;
                case 1 -> postprocessors.get(0);
                default -> new MultiPostprocessor(postprocessors, null);
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

