/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.RequiresApi;
import com.facebook.react.uimanager.FilterHelper;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.drawable.BoxShadowBorderRadiusKt;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import com.facebook.react.uimanager.style.CornerRadii;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0012\u0010#\u001a\u00020\u00162\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/react/uimanager/drawable/OutsetBoxShadowDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "borderRadius", "Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "shadowColor", "", "offsetX", "", "offsetY", "blurRadius", "spread", "(Landroid/content/Context;Lcom/facebook/react/uimanager/style/BorderRadiusStyle;IFFFF)V", "value", "getBorderRadius", "()Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "setBorderRadius", "(Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "shadowPaint", "Landroid/graphics/Paint;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "drawShadowRect", "shadowRect", "Landroid/graphics/RectF;", "drawShadowRoundRect", "spreadExtent", "computedBorderRadii", "Lcom/facebook/react/uimanager/style/ComputedBorderRadius;", "getOpacity", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "ReactAndroid_debug"})
@RequiresApi(value=28)
@SourceDebugExtension(value={"SMAP\nOutsetBoxShadowDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutsetBoxShadowDrawable.kt\ncom/facebook/react/uimanager/drawable/OutsetBoxShadowDrawable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class OutsetBoxShadowDrawable
extends Drawable {
    @NotNull
    private final Context context;
    private final int shadowColor;
    private final float offsetX;
    private final float offsetY;
    private final float blurRadius;
    private final float spread;
    @Nullable
    private BorderRadiusStyle borderRadius;
    @NotNull
    private final Paint shadowPaint;

    /*
     * WARNING - void declaration
     */
    public OutsetBoxShadowDrawable(@NotNull Context context, @Nullable BorderRadiusStyle borderRadius, int shadowColor, float offsetX, float offsetY, float blurRadius, float spread) {
        void $this$shadowPaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.shadowColor = shadowColor;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.blurRadius = blurRadius;
        this.spread = spread;
        this.borderRadius = borderRadius;
        Paint paint2 = paint = new Paint();
        OutsetBoxShadowDrawable outsetBoxShadowDrawable = this;
        boolean bl = false;
        $this$shadowPaint_u24lambda_u240.setColor(this.shadowColor);
        if (this.blurRadius > 0.0f) {
            $this$shadowPaint_u24lambda_u240.setMaskFilter((MaskFilter)new BlurMaskFilter(FilterHelper.INSTANCE.sigmaToRadius$ReactAndroid_debug(this.blurRadius * 0.5f), BlurMaskFilter.Blur.NORMAL));
        }
        outsetBoxShadowDrawable.shadowPaint = paint;
    }

    public /* synthetic */ OutsetBoxShadowDrawable(Context context, BorderRadiusStyle borderRadiusStyle, int n, float f, float f2, float f3, float f4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            borderRadiusStyle = null;
        }
        this(context, borderRadiusStyle, n, f, f2, f3, f4);
    }

    @Nullable
    public final BorderRadiusStyle getBorderRadius() {
        return this.borderRadius;
    }

    public final void setBorderRadius(@Nullable BorderRadiusStyle value) {
        if (!Intrinsics.areEqual((Object)value, (Object)this.borderRadius)) {
            this.borderRadius = value;
            this.invalidateSelf();
        }
    }

    public void setAlpha(int alpha) {
        this.shadowPaint.setAlpha(MathKt.roundToInt((float)((float)alpha / 255.0f * ((float)Color.alpha((int)this.shadowColor) / 255.0f) * 255.0f)));
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.shadowPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return MathKt.roundToInt((float)((float)this.shadowPaint.getAlpha() / 255.0f / ((float)Color.alpha((int)this.shadowColor) / 255.0f) * 255.0f));
    }

    public void draw(@NotNull Canvas canvas) {
        RectF rectF;
        ComputedBorderRadius computedBorderRadius;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        float resolutionWidth = PixelUtil.INSTANCE.pxToDp(this.getBounds().width());
        float resolutionHeight = PixelUtil.INSTANCE.pxToDp(this.getBounds().height());
        Object object = this.borderRadius;
        if (object != null && (object = ((BorderRadiusStyle)object).resolve(this.getLayoutDirection(), this.context, resolutionWidth, resolutionHeight)) != null) {
            Object it = object;
            boolean bl = false;
            computedBorderRadius = new ComputedBorderRadius(new CornerRadii(PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getTopLeft().getHorizontal()), PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getTopLeft().getVertical())), new CornerRadii(PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getTopRight().getHorizontal()), PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getTopRight().getVertical())), new CornerRadii(PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getBottomLeft().getHorizontal()), PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getBottomLeft().getVertical())), new CornerRadii(PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getBottomRight().getHorizontal()), PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getBottomRight().getVertical())));
        } else {
            computedBorderRadius = null;
        }
        ComputedBorderRadius computedBorderRadii = computedBorderRadius;
        float spreadExtent = PixelUtil.INSTANCE.dpToPx(this.spread);
        RectF $this$draw_u24lambda_u242 = rectF = new RectF(this.getBounds());
        boolean bl = false;
        $this$draw_u24lambda_u242.inset(-spreadExtent, -spreadExtent);
        $this$draw_u24lambda_u242.offset(PixelUtil.INSTANCE.dpToPx(this.offsetX), PixelUtil.INSTANCE.dpToPx(this.offsetY));
        RectF shadowRect = rectF;
        int saveCount = canvas.save();
        boolean bl2 = false;
        ComputedBorderRadius computedBorderRadius2 = computedBorderRadii;
        boolean bl3 = computedBorderRadius2 != null ? computedBorderRadius2.hasRoundedBorders() : false;
        if (bl3) {
            this.drawShadowRoundRect(canvas, shadowRect, spreadExtent, computedBorderRadii);
        } else {
            this.drawShadowRect(canvas, shadowRect);
        }
        canvas.restoreToCount(saveCount);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawShadowRoundRect(Canvas canvas, RectF shadowRect, float spreadExtent, ComputedBorderRadius computedBorderRadii) {
        void $this$drawShadowRoundRect_u24lambda_u246;
        RectF $this$drawShadowRoundRect_u24lambda_u245;
        RectF rectF;
        RectF $this$drawShadowRoundRect_u24lambda_u244 = rectF = new RectF(this.getBounds());
        boolean bl = false;
        $this$drawShadowRoundRect_u24lambda_u244.inset(0.4f, 0.4f);
        RectF subpixelInsetBounds = rectF;
        $this$drawShadowRoundRect_u24lambda_u244 = rectF = new Path();
        Canvas canvas2 = canvas;
        boolean bl2 = false;
        float[] fArray = new float[]{computedBorderRadii.getTopLeft().getHorizontal(), computedBorderRadii.getTopLeft().getVertical(), computedBorderRadii.getTopRight().getHorizontal(), computedBorderRadii.getTopRight().getVertical(), computedBorderRadii.getBottomRight().getHorizontal(), computedBorderRadii.getBottomRight().getVertical(), computedBorderRadii.getBottomLeft().getHorizontal(), computedBorderRadii.getBottomLeft().getVertical()};
        $this$drawShadowRoundRect_u24lambda_u245.addRoundRect(subpixelInsetBounds, fArray, Path.Direction.CW);
        canvas2.clipOutPath((Path)rectF);
        $this$drawShadowRoundRect_u24lambda_u245 = rectF = new Path();
        canvas2 = canvas;
        boolean bl3 = false;
        fArray = new float[]{BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getTopLeft().getHorizontal(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getTopLeft().getVertical(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getTopRight().getHorizontal(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getTopRight().getVertical(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getBottomRight().getHorizontal(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getBottomRight().getVertical(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getBottomLeft().getHorizontal(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getBottomLeft().getVertical(), spreadExtent)};
        $this$drawShadowRoundRect_u24lambda_u246.addRoundRect(shadowRect, fArray, Path.Direction.CW);
        canvas2.drawPath((Path)rectF, this.shadowPaint);
    }

    private final void drawShadowRect(Canvas canvas, RectF shadowRect) {
        canvas.clipOutRect(this.getBounds());
        canvas.drawRect(shadowRect, this.shadowPaint);
    }
}

