/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.app.Activity;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.runtime.BridgelessReactStateTracker;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class ReactLifecycleStateManager {
    LifecycleState mState = LifecycleState.BEFORE_CREATE;
    private final BridgelessReactStateTracker mBridgelessReactStateTracker;

    ReactLifecycleStateManager(BridgelessReactStateTracker bridgelessReactStateTracker) {
        this.mBridgelessReactStateTracker = bridgelessReactStateTracker;
    }

    public LifecycleState getLifecycleState() {
        return this.mState;
    }

    @ThreadConfined(value="UI")
    public void resumeReactContextIfHostResumed(ReactContext currentContext, @Nullable Activity activity) {
        if (this.mState == LifecycleState.RESUMED) {
            this.mBridgelessReactStateTracker.enterState("ReactContext.onHostResume()");
            currentContext.onHostResume(activity);
        }
    }

    @ThreadConfined(value="UI")
    public void moveToOnHostResume(@Nullable ReactContext currentContext, @Nullable Activity activity) {
        if (this.mState == LifecycleState.RESUMED) {
            return;
        }
        if (currentContext != null) {
            this.mBridgelessReactStateTracker.enterState("ReactContext.onHostResume()");
            currentContext.onHostResume(activity);
        }
        this.mState = LifecycleState.RESUMED;
    }

    @ThreadConfined(value="UI")
    public void moveToOnHostPause(@Nullable ReactContext currentContext, @Nullable Activity activity) {
        if (currentContext != null) {
            if (this.mState == LifecycleState.BEFORE_CREATE) {
                this.mBridgelessReactStateTracker.enterState("ReactContext.onHostResume()");
                currentContext.onHostResume(activity);
                this.mBridgelessReactStateTracker.enterState("ReactContext.onHostPause()");
                currentContext.onHostPause();
            } else if (this.mState == LifecycleState.RESUMED) {
                this.mBridgelessReactStateTracker.enterState("ReactContext.onHostPause()");
                currentContext.onHostPause();
            }
        }
        this.mState = LifecycleState.BEFORE_RESUME;
    }

    @ThreadConfined(value="UI")
    public void moveToOnHostDestroy(@Nullable ReactContext currentContext) {
        if (currentContext != null) {
            if (this.mState == LifecycleState.BEFORE_RESUME) {
                this.mBridgelessReactStateTracker.enterState("ReactContext.onHostDestroy()");
                currentContext.onHostDestroy();
            } else if (this.mState == LifecycleState.RESUMED) {
                this.mBridgelessReactStateTracker.enterState("ReactContext.onHostPause()");
                currentContext.onHostPause();
                this.mBridgelessReactStateTracker.enterState("ReactContext.onHostDestroy()");
                currentContext.onHostDestroy();
            }
        }
        this.mState = LifecycleState.BEFORE_CREATE;
    }
}

