/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.accessibilityinfo;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.provider.Settings;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.facebook.fbreact.specs.NativeAccessibilityInfoSpec;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.module.annotations.ReactModule;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="AccessibilityInfo")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0007\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0003/01B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016J\b\u0010\"\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010&\u001a\u00020\u0019H\u0016J\b\u0010'\u001a\u00020\u0019H\u0017J\b\u0010(\u001a\u00020\u0019H\u0017J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u001eH\u0016J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u000bH\u0002J\b\u0010-\u001a\u00020\u0019H\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u000bH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000b8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule;", "Lcom/facebook/fbreact/specs/NativeAccessibilityInfoSpec;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "context", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "accessibilityManager", "Landroid/view/accessibility/AccessibilityManager;", "accessibilityServiceChangeListener", "Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule$ReactAccessibilityServiceChangeListener;", "accessibilityServiceEnabled", "", "animationScaleObserver", "Landroid/database/ContentObserver;", "contentResolver", "Landroid/content/ContentResolver;", "isReduceMotionEnabledValue", "()Z", "recommendedTimeout", "", "reduceMotionEnabled", "touchExplorationEnabled", "touchExplorationStateChangeListener", "Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule$ReactTouchExplorationStateChangeListener;", "announceForAccessibility", "", "message", "", "getRecommendedTimeoutMillis", "originalTimeout", "", "successCallback", "Lcom/facebook/react/bridge/Callback;", "initialize", "invalidate", "isAccessibilityServiceEnabled", "isReduceMotionEnabled", "isTouchExplorationEnabled", "onHostDestroy", "onHostPause", "onHostResume", "setAccessibilityFocus", "reactTag", "updateAndSendAccessibilityServiceChangeEvent", "enabled", "updateAndSendReduceMotionChangeEvent", "updateAndSendTouchExplorationChangeEvent", "Companion", "ReactAccessibilityServiceChangeListener", "ReactTouchExplorationStateChangeListener", "ReactAndroid_debug"})
public final class AccessibilityInfoModule
extends NativeAccessibilityInfoSpec
implements LifecycleEventListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ContentObserver animationScaleObserver;
    @Nullable
    private final AccessibilityManager accessibilityManager;
    @NotNull
    private final ReactTouchExplorationStateChangeListener touchExplorationStateChangeListener;
    @NotNull
    private final ReactAccessibilityServiceChangeListener accessibilityServiceChangeListener;
    @NotNull
    private final ContentResolver contentResolver;
    private boolean reduceMotionEnabled;
    private boolean touchExplorationEnabled;
    private boolean accessibilityServiceEnabled;
    private int recommendedTimeout;
    @NotNull
    private static final String REDUCE_MOTION_EVENT_NAME = "reduceMotionDidChange";
    @NotNull
    private static final String TOUCH_EXPLORATION_EVENT_NAME = "touchExplorationDidChange";
    @NotNull
    private static final String ACCESSIBILITY_SERVICE_EVENT_NAME = "accessibilityServiceDidChange";

    public AccessibilityInfoModule(@NotNull ReactApplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        super(context);
        Handler handler = UiThreadUtil.getUiThreadHandler();
        this.animationScaleObserver = new ContentObserver(this, handler){
            final /* synthetic */ AccessibilityInfoModule this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onChange(boolean selfChange) {
                this.onChange(selfChange, null);
            }

            public void onChange(boolean selfChange, @Nullable Uri uri) {
                if (AccessibilityInfoModule.access$getReactApplicationContext(this.this$0).hasActiveReactInstance()) {
                    AccessibilityInfoModule.access$updateAndSendReduceMotionChangeEvent(this.this$0);
                }
            }
        };
        this.touchExplorationStateChangeListener = new ReactTouchExplorationStateChangeListener();
        this.accessibilityServiceChangeListener = new ReactAccessibilityServiceChangeListener();
        Context appContext = context.getApplicationContext();
        Object object = appContext.getSystemService("accessibility");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.accessibility.AccessibilityManager");
        this.accessibilityManager = (AccessibilityManager)object;
        ContentResolver contentResolver = this.getReactApplicationContext().getContentResolver();
        Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"getContentResolver(...)");
        this.contentResolver = contentResolver;
        this.touchExplorationEnabled = this.accessibilityManager.isTouchExplorationEnabled();
        this.accessibilityServiceEnabled = this.accessibilityManager.isEnabled();
        this.reduceMotionEnabled = this.isReduceMotionEnabledValue();
    }

    @TargetApi(value=21)
    private final boolean isReduceMotionEnabledValue() {
        String rawValue;
        String string2 = rawValue = Settings.Global.getString((ContentResolver)this.contentResolver, (String)"transition_animation_scale");
        float parsedValue = string2 != null ? Float.parseFloat(string2) : 1.0f;
        return parsedValue == 0.0f;
    }

    @Override
    public void isReduceMotionEnabled(@NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        Object[] objectArray = new Object[]{this.reduceMotionEnabled};
        successCallback.invoke(objectArray);
    }

    @Override
    public void isTouchExplorationEnabled(@NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        Object[] objectArray = new Object[]{this.touchExplorationEnabled};
        successCallback.invoke(objectArray);
    }

    @Override
    public void isAccessibilityServiceEnabled(@NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        Object[] objectArray = new Object[]{this.accessibilityServiceEnabled};
        successCallback.invoke(objectArray);
    }

    private final void updateAndSendReduceMotionChangeEvent() {
        boolean isReduceMotionEnabled = this.isReduceMotionEnabledValue();
        if (this.reduceMotionEnabled != isReduceMotionEnabled) {
            this.reduceMotionEnabled = isReduceMotionEnabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                reactApplicationContext.emitDeviceEvent(REDUCE_MOTION_EVENT_NAME, this.reduceMotionEnabled);
            }
        }
    }

    private final void updateAndSendTouchExplorationChangeEvent(boolean enabled) {
        if (this.touchExplorationEnabled != enabled) {
            this.touchExplorationEnabled = enabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                this.getReactApplicationContext().emitDeviceEvent(TOUCH_EXPLORATION_EVENT_NAME, this.touchExplorationEnabled);
            }
        }
    }

    private final void updateAndSendAccessibilityServiceChangeEvent(boolean enabled) {
        if (this.accessibilityServiceEnabled != enabled) {
            this.accessibilityServiceEnabled = enabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                this.getReactApplicationContext().emitDeviceEvent(ACCESSIBILITY_SERVICE_EVENT_NAME, this.accessibilityServiceEnabled);
            }
        }
    }

    @Override
    @TargetApi(value=21)
    public void onHostResume() {
        AccessibilityManager accessibilityManager = this.accessibilityManager;
        if (accessibilityManager != null) {
            accessibilityManager.addTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.touchExplorationStateChangeListener);
        }
        AccessibilityManager accessibilityManager2 = this.accessibilityManager;
        if (accessibilityManager2 != null) {
            accessibilityManager2.addAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this.accessibilityServiceChangeListener);
        }
        Uri transitionUri = Settings.Global.getUriFor((String)"transition_animation_scale");
        this.contentResolver.registerContentObserver(transitionUri, false, this.animationScaleObserver);
        AccessibilityManager accessibilityManager3 = this.accessibilityManager;
        this.updateAndSendTouchExplorationChangeEvent(accessibilityManager3 != null ? accessibilityManager3.isTouchExplorationEnabled() : false);
        AccessibilityManager accessibilityManager4 = this.accessibilityManager;
        this.updateAndSendAccessibilityServiceChangeEvent(accessibilityManager4 != null ? accessibilityManager4.isEnabled() : false);
        this.updateAndSendReduceMotionChangeEvent();
    }

    @Override
    @TargetApi(value=21)
    public void onHostPause() {
        AccessibilityManager accessibilityManager = this.accessibilityManager;
        if (accessibilityManager != null) {
            accessibilityManager.removeTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.touchExplorationStateChangeListener);
        }
        AccessibilityManager accessibilityManager2 = this.accessibilityManager;
        if (accessibilityManager2 != null) {
            accessibilityManager2.removeAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this.accessibilityServiceChangeListener);
        }
        this.contentResolver.unregisterContentObserver(this.animationScaleObserver);
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
        AccessibilityManager accessibilityManager = this.accessibilityManager;
        this.updateAndSendTouchExplorationChangeEvent(accessibilityManager != null ? accessibilityManager.isTouchExplorationEnabled() : false);
        AccessibilityManager accessibilityManager2 = this.accessibilityManager;
        this.updateAndSendAccessibilityServiceChangeEvent(accessibilityManager2 != null ? accessibilityManager2.isEnabled() : false);
        this.updateAndSendReduceMotionChangeEvent();
    }

    @Override
    public void invalidate() {
        this.getReactApplicationContext().removeLifecycleEventListener(this);
        super.invalidate();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void announceForAccessibility(@Nullable String message) {
        if (this.accessibilityManager == null || !this.accessibilityManager.isEnabled()) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain((int)16384);
        event.getText().add(message);
        event.setClassName((CharSequence)AccessibilityInfoModule.class.getName());
        event.setPackageName((CharSequence)this.getReactApplicationContext().getPackageName());
        this.accessibilityManager.sendAccessibilityEvent(event);
    }

    @Override
    public void setAccessibilityFocus(double reactTag) {
    }

    @Override
    public void getRecommendedTimeoutMillis(double originalTimeout, @NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        if (Build.VERSION.SDK_INT < 29) {
            Object[] objectArray = new Object[]{(int)originalTimeout};
            successCallback.invoke(objectArray);
            return;
        }
        AccessibilityManager accessibilityManager = this.accessibilityManager;
        this.recommendedTimeout = accessibilityManager != null ? accessibilityManager.getRecommendedTimeoutMillis((int)originalTimeout, 4) : 0;
        Object[] objectArray = new Object[]{this.recommendedTimeout};
        successCallback.invoke(objectArray);
    }

    public static final /* synthetic */ ReactApplicationContext access$getReactApplicationContext(AccessibilityInfoModule $this) {
        return $this.getReactApplicationContext();
    }

    public static final /* synthetic */ void access$updateAndSendReduceMotionChangeEvent(AccessibilityInfoModule $this) {
        $this.updateAndSendReduceMotionChangeEvent();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule$Companion;", "", "()V", "ACCESSIBILITY_SERVICE_EVENT_NAME", "", "REDUCE_MOTION_EVENT_NAME", "TOUCH_EXPLORATION_EVENT_NAME", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule$ReactAccessibilityServiceChangeListener;", "Landroid/view/accessibility/AccessibilityManager$AccessibilityStateChangeListener;", "(Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule;)V", "onAccessibilityStateChanged", "", "enabled", "", "ReactAndroid_debug"})
    @TargetApi(value=21)
    private final class ReactAccessibilityServiceChangeListener
    implements AccessibilityManager.AccessibilityStateChangeListener {
        public void onAccessibilityStateChanged(boolean enabled) {
            AccessibilityInfoModule.this.updateAndSendAccessibilityServiceChangeEvent(enabled);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule$ReactTouchExplorationStateChangeListener;", "Landroid/view/accessibility/AccessibilityManager$TouchExplorationStateChangeListener;", "(Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule;)V", "onTouchExplorationStateChanged", "", "enabled", "", "ReactAndroid_debug"})
    @TargetApi(value=21)
    private final class ReactTouchExplorationStateChangeListener
    implements AccessibilityManager.TouchExplorationStateChangeListener {
        public void onTouchExplorationStateChanged(boolean enabled) {
            AccessibilityInfoModule.this.updateAndSendTouchExplorationChangeEvent(enabled);
        }
    }
}

