/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J+\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/facebook/react/devsupport/DefaultDevLoadingViewImplementation;", "Lcom/facebook/react/devsupport/interfaces/DevLoadingViewManager;", "reactInstanceDevHelper", "Lcom/facebook/react/devsupport/ReactInstanceDevHelper;", "(Lcom/facebook/react/devsupport/ReactInstanceDevHelper;)V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "devLoadingPopup", "Landroid/widget/PopupWindow;", "devLoadingView", "Landroid/widget/TextView;", "hide", "", "hideInternal", "showInternal", "message", "", "showMessage", "updateProgress", "status", "done", "", "total", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "Companion", "ReactAndroid_debug"})
public final class DefaultDevLoadingViewImplementation
implements DevLoadingViewManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactInstanceDevHelper reactInstanceDevHelper;
    @Nullable
    private TextView devLoadingView;
    @Nullable
    private PopupWindow devLoadingPopup;
    private static boolean isEnabled = true;

    public DefaultDevLoadingViewImplementation(@NotNull ReactInstanceDevHelper reactInstanceDevHelper) {
        Intrinsics.checkNotNullParameter((Object)reactInstanceDevHelper, (String)"reactInstanceDevHelper");
        this.reactInstanceDevHelper = reactInstanceDevHelper;
    }

    @Override
    public void showMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!isEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(() -> DefaultDevLoadingViewImplementation.showMessage$lambda$0(this, message));
    }

    @Override
    public void updateProgress(@Nullable String status, @Nullable Integer done, @Nullable Integer total) {
        if (!isEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(() -> DefaultDevLoadingViewImplementation.updateProgress$lambda$1(done, total, this, status));
    }

    @Override
    public void hide() {
        if (isEnabled) {
            UiThreadUtil.runOnUiThread(() -> DefaultDevLoadingViewImplementation.hide$lambda$2(this));
        }
    }

    private final void showInternal(String message) {
        PopupWindow popupWindow = this.devLoadingPopup;
        boolean bl = popupWindow != null ? popupWindow.isShowing() : false;
        if (bl) {
            return;
        }
        Activity currentActivity = this.reactInstanceDevHelper.getCurrentActivity();
        if (currentActivity == null) {
            FLog.e((String)"ReactNative", (String)"Unable to display loading message because react activity isn't available");
            return;
        }
        try {
            Rect rectangle = new Rect();
            currentActivity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rectangle);
            int topOffset = rectangle.top;
            Object object = currentActivity.getSystemService("layout_inflater");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.LayoutInflater");
            LayoutInflater inflater = (LayoutInflater)object;
            View view = inflater.inflate(R.layout.dev_loading_view, null);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.TextView");
            TextView view2 = (TextView)view;
            view2.setText((CharSequence)message);
            PopupWindow popup = new PopupWindow((View)view2, -1, -2);
            popup.setTouchable(false);
            popup.showAtLocation(currentActivity.getWindow().getDecorView(), 0, 0, topOffset);
            this.devLoadingView = view2;
            this.devLoadingPopup = popup;
        }
        catch (WindowManager.BadTokenException e) {
            FLog.e((String)"ReactNative", (String)("Unable to display loading message because react activity isn't active, message: " + message));
        }
    }

    private final void hideInternal() {
        PopupWindow popupWindow = this.devLoadingPopup;
        if (popupWindow == null) {
            return;
        }
        PopupWindow popup = popupWindow;
        if (popup.isShowing()) {
            popup.dismiss();
            this.devLoadingPopup = null;
            this.devLoadingView = null;
        }
    }

    private final Context getContext() {
        return (Context)this.reactInstanceDevHelper.getCurrentActivity();
    }

    private static final void showMessage$lambda$0(DefaultDevLoadingViewImplementation this$0, String $message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        this$0.showInternal($message);
    }

    private static final void updateProgress$lambda$1(Integer $done, Integer $total, DefaultDevLoadingViewImplementation this$0, String $status) {
        String string;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($done != null && $total != null && $total > 0) {
            Locale locale = Locale.getDefault();
            String string2 = " %.1f%%";
            Object[] objectArray = new Object[]{Float.valueOf((float)$done.intValue() / (float)$total.intValue() * (float)100)};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string = "";
        }
        String percentage = string;
        TextView textView = this$0.devLoadingView;
        if (textView != null) {
            String string4 = $status;
            if (string4 == null) {
                string4 = "Loading";
            }
            textView.setText((CharSequence)(string4 + percentage + "\u2026"));
        }
    }

    private static final void hide$lambda$2(DefaultDevLoadingViewImplementation this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.hideInternal();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/devsupport/DefaultDevLoadingViewImplementation$Companion;", "", "()V", "isEnabled", "", "setDevLoadingEnabled", "", "enabled", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public final void setDevLoadingEnabled(boolean enabled) {
            isEnabled = enabled;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

