/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.reactexecutor;

import com.facebook.hermes.instrumentation.HermesSamplingProfiler;
import com.facebook.hermes.reactexecutor.HermesExecutor;
import com.facebook.hermes.reactexecutor.RuntimeConfig;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptExecutorFactory;

public class HermesExecutorFactory
implements JavaScriptExecutorFactory {
    private static final String TAG = "Hermes";
    private final RuntimeConfig mConfig;
    private boolean mEnableDebugger = true;
    private String mDebuggerName = "";

    public HermesExecutorFactory() {
        this(null);
    }

    public HermesExecutorFactory(RuntimeConfig config) {
        this.mConfig = config;
    }

    public void setEnableDebugger(boolean enableDebugger) {
        this.mEnableDebugger = enableDebugger;
    }

    public void setDebuggerName(String debuggerName) {
        this.mDebuggerName = debuggerName;
    }

    @Override
    public JavaScriptExecutor create() {
        return new HermesExecutor(this.mConfig, this.mEnableDebugger, this.mDebuggerName);
    }

    @Override
    public void startSamplingProfiler() {
        HermesSamplingProfiler.enable();
    }

    @Override
    public void stopSamplingProfiler(String filename) {
        HermesSamplingProfiler.dumpSampledTraceToFile(filename);
        HermesSamplingProfiler.disable();
    }

    public String toString() {
        return "JSIExecutor+HermesRuntime";
    }
}

