/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.systrace;

import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.List;

public final class SystraceMessage {
    public static Boolean INCLUDE_ARGS = false;

    public static Builder beginSection(long tag, String sectionName) {
        return new StartSectionBuilder(tag, sectionName);
    }

    public static Builder endSection(long tag) {
        return new EndSectionBuilder(tag);
    }

    private static class StartSectionBuilder
    extends Builder {
        private String mSectionName;
        private long mTag;
        private List<String> mArgs = new ArrayList<String>();

        public StartSectionBuilder(long tag, String sectionName) {
            this.mTag = tag;
            this.mSectionName = sectionName;
        }

        @Override
        public void flush() {
            Systrace.beginSection(this.mTag, this.mSectionName + (INCLUDE_ARGS != false && this.mArgs.size() > 0 ? " (" + String.join((CharSequence)", ", this.mArgs) + ")" : ""));
        }

        @Override
        public Builder arg(String key, Object value) {
            this.addArg(key, String.valueOf(value));
            return this;
        }

        @Override
        public Builder arg(String key, int value) {
            this.addArg(key, String.valueOf(value));
            return this;
        }

        @Override
        public Builder arg(String key, long value) {
            this.addArg(key, String.valueOf(value));
            return this;
        }

        @Override
        public Builder arg(String key, double value) {
            this.addArg(key, String.valueOf(value));
            return this;
        }

        private void addArg(String key, String value) {
            this.mArgs.add(key + ": " + value);
        }
    }

    private static class EndSectionBuilder
    extends Builder {
        private long mTag;

        public EndSectionBuilder(long tag) {
            this.mTag = tag;
        }

        @Override
        public void flush() {
            Systrace.endSection(this.mTag);
        }

        @Override
        public Builder arg(String key, Object value) {
            return this;
        }

        @Override
        public Builder arg(String key, int value) {
            return this;
        }

        @Override
        public Builder arg(String key, long value) {
            return this;
        }

        @Override
        public Builder arg(String key, double value) {
            return this;
        }
    }

    public static abstract class Builder {
        public abstract void flush();

        public abstract Builder arg(String var1, Object var2);

        public abstract Builder arg(String var1, int var2);

        public abstract Builder arg(String var1, long var2);

        public abstract Builder arg(String var1, double var2);
    }
}

