/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.imagehelper;

import android.content.Context;
import android.net.Uri;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import java.util.Objects;

public class ImageSource {
    private static final String TRANSPARENT_BITMAP_URI = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";
    private Uri mUri;
    private String mSource;
    private double mSize;
    private boolean isResource;

    public ImageSource(Context context, String source, double width, double height) {
        this.mSource = source;
        this.mSize = width * height;
        this.mUri = this.computeUri(context);
    }

    public static ImageSource getTransparentBitmapImageSource(Context context) {
        return new ImageSource(context, TRANSPARENT_BITMAP_URI);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageSource that = (ImageSource)o;
        return Double.compare(that.mSize, this.mSize) == 0 && this.isResource == that.isResource && Objects.equals(this.mUri, that.mUri) && Objects.equals(this.mSource, that.mSource);
    }

    public int hashCode() {
        return Objects.hash(this.mUri, this.mSource, this.mSize, this.isResource);
    }

    public ImageSource(Context context, String source) {
        this(context, source, 0.0, 0.0);
    }

    public String getSource() {
        return this.mSource;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public double getSize() {
        return this.mSize;
    }

    public boolean isResource() {
        return this.isResource;
    }

    private Uri computeUri(Context context) {
        try {
            Uri uri = Uri.parse((String)this.mSource);
            return uri.getScheme() == null ? this.computeLocalUri(context) : uri;
        }
        catch (Exception e) {
            return this.computeLocalUri(context);
        }
    }

    private Uri computeLocalUri(Context context) {
        this.isResource = true;
        return ResourceDrawableIdHelper.getInstance().getResourceDrawableUri(context, this.mSource);
    }
}

