/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.BaseInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.layoutanimation.AnimatedPropertyType;
import com.facebook.react.uimanager.layoutanimation.InterpolatorType;
import com.facebook.react.uimanager.layoutanimation.SimpleSpringInterpolator;
import java.util.Map;

abstract class AbstractLayoutAnimation {
    private static final boolean SLOWDOWN_ANIMATION_MODE = false;
    private static final Map<InterpolatorType, BaseInterpolator> INTERPOLATOR = MapBuilder.of(InterpolatorType.LINEAR, new LinearInterpolator(), InterpolatorType.EASE_IN, new AccelerateInterpolator(), InterpolatorType.EASE_OUT, new DecelerateInterpolator(), InterpolatorType.EASE_IN_EASE_OUT, new AccelerateDecelerateInterpolator());
    @Nullable
    private Interpolator mInterpolator;
    private int mDelayMs;
    @Nullable
    protected AnimatedPropertyType mAnimatedProperty;
    protected int mDurationMs;

    AbstractLayoutAnimation() {
    }

    abstract boolean isValid();

    @Nullable
    abstract Animation createAnimationImpl(View var1, int var2, int var3, int var4, int var5);

    public void reset() {
        this.mAnimatedProperty = null;
        this.mDurationMs = 0;
        this.mDelayMs = 0;
        this.mInterpolator = null;
    }

    public void initializeFromConfig(ReadableMap data, int globalDuration) {
        this.mAnimatedProperty = data.hasKey("property") ? AnimatedPropertyType.fromString(data.getString("property")) : null;
        this.mDurationMs = data.hasKey("duration") ? data.getInt("duration") : globalDuration;
        int n = this.mDelayMs = data.hasKey("delay") ? data.getInt("delay") : 0;
        if (!data.hasKey("type")) {
            throw new IllegalArgumentException("Missing interpolation type.");
        }
        this.mInterpolator = AbstractLayoutAnimation.getInterpolator(InterpolatorType.fromString(data.getString("type")), data);
        if (!this.isValid()) {
            throw new IllegalViewOperationException("Invalid layout animation : " + data);
        }
    }

    @Nullable
    public final Animation createAnimation(View view, int x, int y, int width, int height) {
        if (!this.isValid()) {
            return null;
        }
        Animation animation = this.createAnimationImpl(view, x, y, width, height);
        if (animation != null) {
            int slowdownFactor = 1;
            animation.setDuration((long)(this.mDurationMs * slowdownFactor));
            animation.setStartOffset((long)(this.mDelayMs * slowdownFactor));
            animation.setInterpolator(this.mInterpolator);
        }
        return animation;
    }

    private static Interpolator getInterpolator(InterpolatorType type, ReadableMap params) {
        Interpolator interpolator = type.equals((Object)InterpolatorType.SPRING) ? new SimpleSpringInterpolator(SimpleSpringInterpolator.getSpringDamping(params)) : (Interpolator)INTERPOLATOR.get((Object)type);
        if (interpolator == null) {
            throw new IllegalArgumentException("Missing interpolator for type : " + (Object)((Object)type));
        }
        return interpolator;
    }
}

