/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.TouchEventCoalescingKeyHelper;
import com.facebook.react.uimanager.events.TouchEventType;
import com.facebook.react.uimanager.events.TouchesHelper;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class TouchEvent
extends Event<TouchEvent> {
    private static final String TAG = TouchEvent.class.getSimpleName();
    private static final int TOUCH_EVENTS_POOL_SIZE = 3;
    private static final Pools.SynchronizedPool<TouchEvent> EVENTS_POOL = new Pools.SynchronizedPool(3);
    public static final long UNSET = Long.MIN_VALUE;
    @Nullable
    private MotionEvent mMotionEvent;
    @Nullable
    private TouchEventType mTouchEventType;
    private short mCoalescingKey;
    private float mViewX;
    private float mViewY;

    @Deprecated
    public static TouchEvent obtain(int viewTag, TouchEventType touchEventType, MotionEvent motionEventToCopy, long gestureStartTime, float viewX, float viewY, TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper) {
        return TouchEvent.obtain(-1, viewTag, touchEventType, (MotionEvent)Assertions.assertNotNull((Object)motionEventToCopy), gestureStartTime, viewX, viewY, touchEventCoalescingKeyHelper);
    }

    public static TouchEvent obtain(int surfaceId, int viewTag, TouchEventType touchEventType, MotionEvent motionEventToCopy, long gestureStartTime, float viewX, float viewY, TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper) {
        TouchEvent event = (TouchEvent)EVENTS_POOL.acquire();
        if (event == null) {
            event = new TouchEvent();
        }
        event.init(surfaceId, viewTag, touchEventType, (MotionEvent)Assertions.assertNotNull((Object)motionEventToCopy), gestureStartTime, viewX, viewY, touchEventCoalescingKeyHelper);
        return event;
    }

    private TouchEvent() {
    }

    private void init(int surfaceId, int viewTag, TouchEventType touchEventType, MotionEvent motionEventToCopy, long gestureStartTime, float viewX, float viewY, TouchEventCoalescingKeyHelper touchEventCoalescingKeyHelper) {
        super.init(surfaceId, viewTag, motionEventToCopy.getEventTime());
        SoftAssertions.assertCondition(gestureStartTime != Long.MIN_VALUE, "Gesture start time must be initialized");
        short coalescingKey = 0;
        int action = motionEventToCopy.getAction() & 0xFF;
        switch (action) {
            case 0: {
                touchEventCoalescingKeyHelper.addCoalescingKey(gestureStartTime);
                break;
            }
            case 1: {
                touchEventCoalescingKeyHelper.removeCoalescingKey(gestureStartTime);
                break;
            }
            case 5: 
            case 6: {
                touchEventCoalescingKeyHelper.incrementCoalescingKey(gestureStartTime);
                break;
            }
            case 2: {
                coalescingKey = touchEventCoalescingKeyHelper.getCoalescingKey(gestureStartTime);
                break;
            }
            case 3: {
                touchEventCoalescingKeyHelper.removeCoalescingKey(gestureStartTime);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled MotionEvent action: " + action);
            }
        }
        this.mTouchEventType = touchEventType;
        this.mMotionEvent = MotionEvent.obtain((MotionEvent)motionEventToCopy);
        this.mCoalescingKey = coalescingKey;
        this.mViewX = viewX;
        this.mViewY = viewY;
    }

    @Override
    public void onDispose() {
        MotionEvent motionEvent = this.mMotionEvent;
        this.mMotionEvent = null;
        if (motionEvent != null) {
            motionEvent.recycle();
        }
        try {
            EVENTS_POOL.release((Object)this);
        }
        catch (IllegalStateException e) {
            ReactSoftExceptionLogger.logSoftException(TAG, e);
        }
    }

    @Override
    public String getEventName() {
        return TouchEventType.getJSEventName((TouchEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mTouchEventType))));
    }

    @Override
    public boolean canCoalesce() {
        switch ((TouchEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mTouchEventType)))) {
            case START: 
            case END: 
            case CANCEL: {
                return false;
            }
            case MOVE: {
                return true;
            }
        }
        throw new RuntimeException("Unknown touch event type: " + (Object)((Object)this.mTouchEventType));
    }

    @Override
    public short getCoalescingKey() {
        return this.mCoalescingKey;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        if (this.verifyMotionEvent()) {
            TouchesHelper.sendTouchesLegacy(rctEventEmitter, this);
        }
    }

    @Override
    public void dispatchModern(RCTModernEventEmitter rctEventEmitter) {
        if (this.verifyMotionEvent()) {
            rctEventEmitter.receiveTouches(this);
        }
    }

    @Override
    protected int getEventCategory() {
        TouchEventType type = this.mTouchEventType;
        if (type == null) {
            return 2;
        }
        switch (type) {
            case START: {
                return 0;
            }
            case END: 
            case CANCEL: {
                return 1;
            }
            case MOVE: {
                return 4;
            }
        }
        return super.getEventCategory();
    }

    public MotionEvent getMotionEvent() {
        Assertions.assertNotNull((Object)this.mMotionEvent);
        return this.mMotionEvent;
    }

    private boolean verifyMotionEvent() {
        if (this.mMotionEvent == null) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalStateException("Cannot dispatch a TouchEvent that has no MotionEvent; the TouchEvent has been recycled"));
            return false;
        }
        return true;
    }

    public TouchEventType getTouchEventType() {
        return (TouchEventType)((Object)Assertions.assertNotNull((Object)((Object)this.mTouchEventType)));
    }

    public float getViewX() {
        return this.mViewX;
    }

    public float getViewY() {
        return this.mViewY;
    }
}

