/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.uimanager.UIManagerModuleConstants;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UIManagerModuleConstantsHelper {
    private static final String TAG = "UIManagerModuleConstantsHelper";
    private static final String BUBBLING_EVENTS_KEY = "bubblingEventTypes";
    private static final String DIRECT_EVENTS_KEY = "directEventTypes";

    static Map<String, Object> createConstants(ViewManagerResolver resolver) {
        Map<String, Object> constants = UIManagerModuleConstants.getConstants();
        constants.put("ViewManagerNames", new ArrayList<String>(resolver.getViewManagerNames()));
        constants.put("LazyViewManagersEnabled", true);
        return constants;
    }

    public static Map<String, Object> getDefaultExportableEventTypes() {
        return MapBuilder.of(BUBBLING_EVENTS_KEY, UIManagerModuleConstants.getBubblingEventTypeConstants(), DIRECT_EVENTS_KEY, UIManagerModuleConstants.getDirectEventTypeConstants());
    }

    private static void validateDirectEventNames(String viewManagerName, Map<String, Object> directEvents) {
    }

    static Map<String, Object> createConstants(List<ViewManager> viewManagers, @Nullable Map<String, Object> allBubblingEventTypes, @Nullable Map<String, Object> allDirectEventTypes) {
        Map<String, Object> constants = UIManagerModuleConstants.getConstants();
        Map genericBubblingEventTypes = UIManagerModuleConstants.getBubblingEventTypeConstants();
        Map genericDirectEventTypes = UIManagerModuleConstants.getDirectEventTypeConstants();
        if (allBubblingEventTypes != null) {
            allBubblingEventTypes.putAll(genericBubblingEventTypes);
        }
        if (allDirectEventTypes != null) {
            allDirectEventTypes.putAll(genericDirectEventTypes);
        }
        for (ViewManager viewManager : viewManagers) {
            String viewManagerName = viewManager.getName();
            Map<String, Object> viewManagerConstants = UIManagerModuleConstantsHelper.createConstantsForViewManager(viewManager, null, null, allBubblingEventTypes, allDirectEventTypes);
            if (viewManagerConstants.isEmpty()) continue;
            constants.put(viewManagerName, viewManagerConstants);
        }
        constants.put("genericBubblingEventTypes", genericBubblingEventTypes);
        constants.put("genericDirectEventTypes", genericDirectEventTypes);
        return constants;
    }

    static Map<String, Object> createConstantsForViewManager(ViewManager viewManager, @Nullable Map defaultBubblingEvents, @Nullable Map defaultDirectEvents, @Nullable Map cumulativeBubblingEventTypes, @Nullable Map cumulativeDirectEventTypes) {
        Map<String, String> viewManagerNativeProps;
        Map<String, Integer> viewManagerCommands;
        HashMap<String, Object> viewManagerConstants = MapBuilder.newHashMap();
        Map<String, Object> viewManagerBubblingEvents = viewManager.getExportedCustomBubblingEventTypeConstants();
        if (viewManagerBubblingEvents != null) {
            if (ReactFeatureFlags.enableFabricRenderer && ReactFeatureFlags.unstable_useFabricInterop) {
                UIManagerModuleConstantsHelper.normalizeEventTypes(viewManagerBubblingEvents);
            }
            UIManagerModuleConstantsHelper.recursiveMerge(cumulativeBubblingEventTypes, viewManagerBubblingEvents);
            UIManagerModuleConstantsHelper.recursiveMerge(viewManagerBubblingEvents, defaultBubblingEvents);
            viewManagerConstants.put(BUBBLING_EVENTS_KEY, viewManagerBubblingEvents);
        } else if (defaultBubblingEvents != null) {
            viewManagerConstants.put(BUBBLING_EVENTS_KEY, defaultBubblingEvents);
        }
        Map<String, Object> viewManagerDirectEvents = viewManager.getExportedCustomDirectEventTypeConstants();
        UIManagerModuleConstantsHelper.validateDirectEventNames(viewManager.getName(), viewManagerDirectEvents);
        if (viewManagerDirectEvents != null) {
            if (ReactFeatureFlags.enableFabricRenderer && ReactFeatureFlags.unstable_useFabricInterop) {
                UIManagerModuleConstantsHelper.normalizeEventTypes(viewManagerDirectEvents);
            }
            UIManagerModuleConstantsHelper.recursiveMerge(cumulativeDirectEventTypes, viewManagerDirectEvents);
            UIManagerModuleConstantsHelper.recursiveMerge(viewManagerDirectEvents, defaultDirectEvents);
            viewManagerConstants.put(DIRECT_EVENTS_KEY, viewManagerDirectEvents);
        } else if (defaultDirectEvents != null) {
            viewManagerConstants.put(DIRECT_EVENTS_KEY, defaultDirectEvents);
        }
        Map<String, Object> customViewConstants = viewManager.getExportedViewConstants();
        if (customViewConstants != null) {
            viewManagerConstants.put("Constants", customViewConstants);
        }
        if ((viewManagerCommands = viewManager.getCommandsMap()) != null) {
            viewManagerConstants.put("Commands", viewManagerCommands);
        }
        if (!(viewManagerNativeProps = viewManager.getNativeProps()).isEmpty()) {
            viewManagerConstants.put("NativeProps", viewManagerNativeProps);
        }
        return viewManagerConstants;
    }

    @VisibleForTesting
    static void normalizeEventTypes(Map events) {
        if (events == null) {
            return;
        }
        HashSet<String> keysToNormalize = new HashSet<String>();
        for (Object key : events.keySet()) {
            String keyString;
            if (!(key instanceof String) || (keyString = (String)key).startsWith("top")) continue;
            keysToNormalize.add(keyString);
        }
        for (String oldKey : keysToNormalize) {
            Object value = events.get(oldKey);
            String baseKey = "";
            baseKey = oldKey.startsWith("on") ? oldKey.substring(2) : oldKey.substring(0, 1).toUpperCase() + oldKey.substring(1);
            String newKey = "top" + baseKey;
            events.put(newKey, value);
        }
    }

    private static void recursiveMerge(@Nullable Map dest, @Nullable Map source) {
        if (dest == null || source == null || source.isEmpty()) {
            return;
        }
        for (Object key : source.keySet()) {
            Object sourceValue = source.get(key);
            Object destValue = dest.get(key);
            if (destValue != null && sourceValue instanceof Map && destValue instanceof Map) {
                if (!(destValue instanceof HashMap)) {
                    destValue = new HashMap((Map)destValue);
                    dest.replace(key, (Map)destValue);
                }
                UIManagerModuleConstantsHelper.recursiveMerge((Map)destValue, (Map)sourceValue);
                continue;
            }
            dest.put(key, sourceValue);
        }
    }
}

