/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.content.Context;
import android.content.res.AssetManager;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.DebugCorePackage;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.ViewManagerOnDemandReactPackage;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JSBundleLoaderDelegate;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.RuntimeExecutor;
import com.facebook.react.bridge.RuntimeScheduler;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.bridge.queue.ReactQueueConfigurationImpl;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.fabric.BindingImpl;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.ReactNativeConfig;
import com.facebook.react.fabric.events.EventBeatManager;
import com.facebook.react.interfaces.exceptionmanager.ReactJsExceptionHandler;
import com.facebook.react.internal.AndroidChoreographerProvider;
import com.facebook.react.internal.turbomodule.core.TurboModuleManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.JavaTimerManager;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.runtime.BindingsInstaller;
import com.facebook.react.runtime.BridgelessReactContext;
import com.facebook.react.runtime.CoreReactPackage;
import com.facebook.react.runtime.JSRuntimeFactory;
import com.facebook.react.runtime.JSTimerExecutor;
import com.facebook.react.runtime.ReactHostDelegate;
import com.facebook.react.runtime.ReactSurfaceImpl;
import com.facebook.react.turbomodule.core.CallInvokerHolderImpl;
import com.facebook.react.turbomodule.core.NativeMethodCallInvokerHolderImpl;
import com.facebook.react.uimanager.ComponentNameResolverManager;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.UIConstantsProviderManager;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.UIManagerModuleConstantsHelper;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.ViewManagerResolver;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.soloader.SoLoader;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@ThreadSafe
final class ReactInstance {
    private static final String TAG = ReactInstance.class.getSimpleName();
    @DoNotStrip
    private final HybridData mHybridData;
    private final ReactHostDelegate mDelegate;
    private final BridgelessReactContext mBridgelessReactContext;
    private final List<ReactPackage> mReactPackages;
    private final ReactQueueConfiguration mQueueConfiguration;
    private final TurboModuleManager mTurboModuleManager;
    private final FabricUIManager mFabricUIManager;
    private final JavaTimerManager mJavaTimerManager;
    private final BridgelessViewManagerResolver mViewManagerResolver;
    private JavaScriptContextHolder mJavaScriptContextHolder;
    @Nullable
    @DoNotStrip
    private ComponentNameResolverManager mComponentNameResolverManager;
    @Nullable
    @DoNotStrip
    private UIConstantsProviderManager mUIConstantsProviderManager;
    private static volatile boolean sIsLibraryLoaded;

    ReactInstance(BridgelessReactContext bridgelessReactContext, ReactHostDelegate delegate, ComponentFactory componentFactory, DevSupportManager devSupportManager, QueueThreadExceptionHandler exceptionHandler, ReactJsExceptionHandler reactExceptionManager, boolean useDevSupport) {
        this.mBridgelessReactContext = bridgelessReactContext;
        this.mDelegate = delegate;
        Systrace.beginSection(0L, "ReactInstance.initialize");
        MessageQueueThreadSpec nativeModulesSpec = MessageQueueThreadSpec.newBackgroundThreadSpec("v_native");
        ReactQueueConfigurationSpec spec = ReactQueueConfigurationSpec.builder().setJSQueueThreadSpec(MessageQueueThreadSpec.newBackgroundThreadSpec("v_js")).setNativeModulesQueueThreadSpec(nativeModulesSpec).build();
        this.mQueueConfiguration = ReactQueueConfigurationImpl.create(spec, exceptionHandler);
        FLog.d((String)TAG, (String)"Calling initializeMessageQueueThreads()");
        this.mBridgelessReactContext.initializeMessageQueueThreads(this.mQueueConfiguration);
        MessageQueueThread jsMessageQueueThread = this.mQueueConfiguration.getJSQueueThread();
        MessageQueueThread nativeModulesMessageQueueThread = this.mQueueConfiguration.getNativeModulesQueueThread();
        ReactChoreographer.initialize(AndroidChoreographerProvider.getInstance());
        if (useDevSupport) {
            devSupportManager.startInspector();
        }
        JSTimerExecutor jsTimerExecutor = ReactInstance.createJSTimerExecutor();
        this.mJavaTimerManager = new JavaTimerManager(this.mBridgelessReactContext, jsTimerExecutor, ReactChoreographer.getInstance(), devSupportManager);
        this.mBridgelessReactContext.addLifecycleEventListener(new LifecycleEventListener(){

            @Override
            public void onHostResume() {
                ReactInstance.this.mJavaTimerManager.onHostResume();
            }

            @Override
            public void onHostPause() {
                ReactInstance.this.mJavaTimerManager.onHostPause();
            }

            @Override
            public void onHostDestroy() {
                ReactInstance.this.mJavaTimerManager.onHostDestroy();
            }
        });
        JSRuntimeFactory jsRuntimeFactory = this.mDelegate.getJsRuntimeFactory();
        BindingsInstaller bindingsInstaller = this.mDelegate.getBindingsInstaller();
        boolean isProfiling = Systrace.isTracing(0L);
        this.mHybridData = this.initHybrid(jsRuntimeFactory, jsMessageQueueThread, nativeModulesMessageQueueThread, this.mJavaTimerManager, jsTimerExecutor, reactExceptionManager, bindingsInstaller, isProfiling);
        this.mJavaScriptContextHolder = new JavaScriptContextHolder(this.getJavaScriptContext());
        Systrace.beginSection(0L, "ReactInstance.initialize#initTurboModules");
        this.mReactPackages = new ArrayList<ReactPackage>();
        this.mReactPackages.add(new CoreReactPackage(bridgelessReactContext.getDevSupportManager(), bridgelessReactContext.getDefaultHardwareBackBtnHandler()));
        if (useDevSupport) {
            this.mReactPackages.add(new DebugCorePackage());
        }
        this.mReactPackages.addAll(this.mDelegate.getReactPackages());
        ReactPackageTurboModuleManagerDelegate turboModuleManagerDelegate = this.mDelegate.getTurboModuleManagerDelegateBuilder().setPackages(this.mReactPackages).setReactApplicationContext(this.mBridgelessReactContext).build();
        RuntimeExecutor unbufferedRuntimeExecutor = this.getUnbufferedRuntimeExecutor();
        this.mTurboModuleManager = new TurboModuleManager(unbufferedRuntimeExecutor, turboModuleManagerDelegate, this.getJSCallInvokerHolder(), this.getNativeMethodCallInvokerHolder());
        for (String moduleName : this.mTurboModuleManager.getEagerInitModuleNames()) {
            this.mTurboModuleManager.getModule(moduleName);
        }
        Systrace.endSection(0L);
        Systrace.beginSection(0L, "ReactInstance.initialize#initFabric");
        this.mViewManagerResolver = new BridgelessViewManagerResolver(this.mReactPackages, this.mBridgelessReactContext);
        this.mComponentNameResolverManager = new ComponentNameResolverManager(unbufferedRuntimeExecutor, () -> {
            Collection<String> viewManagerNames = this.mViewManagerResolver.getViewManagerNames();
            if (viewManagerNames.size() < 1) {
                FLog.e((String)TAG, (String)"No ViewManager names found");
                return new String[0];
            }
            return viewManagerNames.toArray(new String[0]);
        });
        if (ReactFeatureFlags.useNativeViewConfigsInBridgelessMode) {
            HashMap customDirectEvents = new HashMap();
            this.mUIConstantsProviderManager = new UIConstantsProviderManager(unbufferedRuntimeExecutor, () -> Arguments.makeNativeMap(UIManagerModuleConstantsHelper.getDefaultExportableEventTypes()), viewManagerName -> {
                ViewManager viewManager = this.mViewManagerResolver.getViewManager(viewManagerName);
                if (viewManager == null) {
                    return null;
                }
                return (NativeMap)((Object)UIManagerModule.getConstantsForViewManager(viewManager, customDirectEvents));
            }, () -> {
                ArrayList<ViewManager> viewManagers = new ArrayList<ViewManager>(this.mViewManagerResolver.getEagerViewManagerMap().values());
                Map<String, Object> constants = UIManagerModule.createConstants(viewManagers, null, customDirectEvents);
                Collection<String> lazyViewManagers = this.mViewManagerResolver.getLazyViewManagerNames();
                if (lazyViewManagers.size() > 0) {
                    constants.put("ViewManagerNames", new ArrayList<String>(lazyViewManagers));
                    constants.put("LazyViewManagersEnabled", true);
                }
                return Arguments.makeNativeMap(constants);
            });
        }
        EventBeatManager eventBeatManager = new EventBeatManager();
        this.mFabricUIManager = new FabricUIManager(this.mBridgelessReactContext, new ViewManagerRegistry(this.mViewManagerResolver), eventBeatManager);
        ReactNativeConfig config = this.mDelegate.getReactNativeConfig();
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)this.mBridgelessReactContext);
        BindingImpl binding = new BindingImpl();
        binding.register(this.getBufferedRuntimeExecutor(), this.getRuntimeScheduler(), this.mFabricUIManager, eventBeatManager, componentFactory, config);
        Systrace.endSection(0L);
        this.mFabricUIManager.initialize();
    }

    private static synchronized void loadLibraryIfNeeded() {
        if (!sIsLibraryLoaded) {
            SoLoader.loadLibrary((String)"rninstance");
            sIsLibraryLoaded = true;
        }
    }

    public ReactQueueConfiguration getReactQueueConfiguration() {
        return this.mQueueConfiguration;
    }

    public void loadJSBundle(JSBundleLoader bundleLoader) {
        Systrace.beginSection(0L, "ReactInstance.loadJSBundle");
        bundleLoader.loadScript(new JSBundleLoaderDelegate(){

            @Override
            public void loadScriptFromFile(String fileName, String sourceURL, boolean loadSynchronously) {
                ReactInstance.this.mBridgelessReactContext.setSourceURL(sourceURL);
                ReactInstance.this.loadJSBundleFromFile(fileName, sourceURL);
            }

            @Override
            public void loadSplitBundleFromFile(String fileName, String sourceURL) {
                ReactInstance.this.loadJSBundleFromFile(fileName, sourceURL);
            }

            @Override
            public void loadScriptFromAssets(AssetManager assetManager, String assetURL, boolean loadSynchronously) {
                ReactInstance.this.mBridgelessReactContext.setSourceURL(assetURL);
                ReactInstance.this.loadJSBundleFromAssets(assetManager, assetURL);
            }

            @Override
            public void setSourceURLs(String deviceURL, String remoteURL) {
                ReactInstance.this.mBridgelessReactContext.setSourceURL(deviceURL);
            }
        });
        Systrace.endSection(0L);
    }

    public <T extends NativeModule> boolean hasNativeModule(Class<T> nativeModuleInterface) {
        ReactModule annotation = nativeModuleInterface.getAnnotation(ReactModule.class);
        if (annotation != null) {
            return this.mTurboModuleManager.hasModule(annotation.name());
        }
        return false;
    }

    public Collection<NativeModule> getNativeModules() {
        return new ArrayList<NativeModule>(this.mTurboModuleManager.getModules());
    }

    @Nullable
    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        ReactModule annotation = nativeModuleInterface.getAnnotation(ReactModule.class);
        if (annotation != null) {
            return (T)this.getNativeModule(annotation.name());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NativeModule getNativeModule(String nativeModuleName) {
        TurboModuleManager turboModuleManager = this.mTurboModuleManager;
        synchronized (turboModuleManager) {
            return this.mTurboModuleManager.getModule(nativeModuleName);
        }
    }

    void prerenderSurface(ReactSurfaceImpl surface) {
        Systrace.beginSection(0L, "ReactInstance.prerenderSurface");
        FLog.d((String)TAG, (String)("call prerenderSurface with surface: " + surface.getModuleName()));
        this.mFabricUIManager.startSurface(surface.getSurfaceHandler(), surface.getContext(), null);
        Systrace.endSection(0L);
    }

    @ThreadConfined(value="ReactHost")
    void startSurface(ReactSurfaceImpl surface) {
        FLog.d((String)TAG, (String)("startSurface() is called with surface: " + surface.getSurfaceID()));
        Systrace.beginSection(0L, "ReactInstance.startSurface");
        ViewGroup view = surface.getView();
        if (view == null) {
            throw new IllegalStateException("Starting surface without a view is not supported, use prerenderSurface instead.");
        }
        if (view.getId() != -1) {
            ReactSoftExceptionLogger.logSoftException(TAG, new IllegalViewOperationException("surfaceView's is NOT equal to View.NO_ID before calling startSurface."));
            view.setId(-1);
        }
        if (surface.isRunning()) {
            this.mFabricUIManager.attachRootView(surface.getSurfaceHandler(), (View)view);
        } else {
            this.mFabricUIManager.startSurface(surface.getSurfaceHandler(), surface.getContext(), (View)view);
        }
        Systrace.endSection(0L);
    }

    @ThreadConfined(value="ReactHost")
    void stopSurface(ReactSurfaceImpl surface) {
        FLog.d((String)TAG, (String)("stopSurface() is called with surface: " + surface.getSurfaceID()));
        this.mFabricUIManager.stopSurface(surface.getSurfaceHandler());
    }

    JavaScriptContextHolder getJavaScriptContextHolder() {
        return this.mJavaScriptContextHolder;
    }

    @ThreadConfined(value="ReactHost")
    void destroy() {
        FLog.d((String)TAG, (String)"ReactInstance.destroy() is called.");
        this.mQueueConfiguration.destroy();
        this.mTurboModuleManager.invalidate();
        this.mFabricUIManager.invalidate();
        this.mHybridData.resetNative();
        this.mComponentNameResolverManager = null;
        this.mUIConstantsProviderManager = null;
        this.mJavaScriptContextHolder.clear();
    }

    @DoNotStrip
    private native HybridData initHybrid(JSRuntimeFactory var1, MessageQueueThread var2, MessageQueueThread var3, JavaTimerManager var4, JSTimerExecutor var5, ReactJsExceptionHandler var6, @Nullable BindingsInstaller var7, boolean var8);

    @DoNotStrip
    private static native JSTimerExecutor createJSTimerExecutor();

    @DoNotStrip
    private native void installGlobals(boolean var1);

    private native void loadJSBundleFromFile(String var1, String var2);

    private native void loadJSBundleFromAssets(AssetManager var1, String var2);

    native CallInvokerHolderImpl getJSCallInvokerHolder();

    private native NativeMethodCallInvokerHolderImpl getNativeMethodCallInvokerHolder();

    private native RuntimeExecutor getUnbufferedRuntimeExecutor();

    native RuntimeExecutor getBufferedRuntimeExecutor();

    private native RuntimeScheduler getRuntimeScheduler();

    private native long getJavaScriptContext();

    native void callFunctionOnModule(String var1, String var2, NativeArray var3);

    private native void registerSegmentNative(int var1, String var2);

    private native void handleMemoryPressureJs(int var1);

    public void handleMemoryPressure(int level) {
        try {
            this.handleMemoryPressureJs(level);
        }
        catch (NullPointerException e) {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Native method handleMemoryPressureJs is called earlier than librninstance.so got ready."));
        }
    }

    EventDispatcher getEventDispatcher() {
        return this.mFabricUIManager.getEventDispatcher();
    }

    FabricUIManager getUIManager() {
        return this.mFabricUIManager;
    }

    public void registerSegment(int segmentId, String path) {
        this.registerSegmentNative(segmentId, path);
    }

    static {
        ReactInstance.loadLibraryIfNeeded();
    }

    private static class BridgelessViewManagerResolver
    implements ViewManagerResolver {
        private List<ReactPackage> mReactPackages;
        private BridgelessReactContext mBridgelessReactContext;
        private Map<String, ViewManager> mLazyViewManagerMap = new HashMap<String, ViewManager>();
        @Nullable
        private Map<String, ViewManager> mEagerViewManagerMap = null;

        public BridgelessViewManagerResolver(List<ReactPackage> reactPackages, BridgelessReactContext context) {
            this.mReactPackages = reactPackages;
            this.mBridgelessReactContext = context;
        }

        @Override
        @Nullable
        public synchronized ViewManager getViewManager(String viewManagerName) {
            ViewManager viewManager = this.getLazyViewManager(viewManagerName);
            if (viewManager != null) {
                return viewManager;
            }
            return this.getEagerViewManagerMap().get(viewManagerName);
        }

        @Override
        public synchronized Collection<String> getViewManagerNames() {
            HashSet<String> allViewManagerNames = new HashSet<String>();
            allViewManagerNames.addAll(this.getLazyViewManagerNames());
            allViewManagerNames.addAll(this.getEagerViewManagerMap().keySet());
            return allViewManagerNames;
        }

        public synchronized Map<String, ViewManager> getEagerViewManagerMap() {
            if (this.mEagerViewManagerMap != null) {
                return this.mEagerViewManagerMap;
            }
            HashMap<String, ViewManager> viewManagerMap = new HashMap<String, ViewManager>();
            for (ReactPackage reactPackage : this.mReactPackages) {
                if (reactPackage instanceof ViewManagerOnDemandReactPackage) continue;
                List<ViewManager> viewManagersInPackage = reactPackage.createViewManagers(this.mBridgelessReactContext);
                for (ViewManager viewManager : viewManagersInPackage) {
                    viewManagerMap.put(viewManager.getName(), viewManager);
                }
            }
            this.mEagerViewManagerMap = viewManagerMap;
            return this.mEagerViewManagerMap;
        }

        @Nullable
        private ViewManager getLazyViewManager(String viewManagerName) {
            if (this.mLazyViewManagerMap.containsKey(viewManagerName)) {
                return this.mLazyViewManagerMap.get(viewManagerName);
            }
            for (ReactPackage reactPackage : this.mReactPackages) {
                ViewManager viewManager;
                if (!(reactPackage instanceof ViewManagerOnDemandReactPackage) || (viewManager = ((ViewManagerOnDemandReactPackage)((Object)reactPackage)).createViewManager(this.mBridgelessReactContext, viewManagerName)) == null) continue;
                this.mLazyViewManagerMap.put(viewManagerName, viewManager);
                return viewManager;
            }
            return null;
        }

        public synchronized Collection<String> getLazyViewManagerNames() {
            HashSet<String> uniqueNames = new HashSet<String>();
            for (ReactPackage reactPackage : this.mReactPackages) {
                Collection<String> names;
                if (!(reactPackage instanceof ViewManagerOnDemandReactPackage) || (names = ((ViewManagerOnDemandReactPackage)((Object)reactPackage)).getViewManagerNames(this.mBridgelessReactContext)) == null) continue;
                uniqueNames.addAll(names);
            }
            return uniqueNames;
        }
    }
}

