/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.Nullable;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JavaJSExecutor;
import com.facebook.react.bridge.JavaScriptExecutorFactory;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.DevSupportManagerBase;
import com.facebook.react.devsupport.HMRClient;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.interfaces.DevSplitBundleCallback;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.runtime.ReactHostImpl;
import com.facebook.react.runtime.ReactSurfaceImpl;
import com.facebook.react.runtime.internal.bolts.Continuation;
import com.facebook.react.runtime.internal.bolts.Task;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class BridgelessDevSupportManager
extends DevSupportManagerBase {
    private final ReactHostImpl mReactHost;

    public BridgelessDevSupportManager(ReactHostImpl host, Context context, @javax.annotation.Nullable String packagerPathForJSBundleName) {
        super(context.getApplicationContext(), BridgelessDevSupportManager.createInstanceDevHelper(host), packagerPathForJSBundleName, true, null, null, 2, null, null, null);
        this.mReactHost = host;
    }

    @Override
    protected String getUniqueTag() {
        return "Bridgeless";
    }

    @Override
    public void loadSplitBundleFromServer(final String bundlePath, final DevSplitBundleCallback callback) {
        this.fetchSplitBundleAndCreateBundleLoader(bundlePath, new DevSupportManagerBase.CallbackWithBundleLoader(){

            @Override
            public void onSuccess(JSBundleLoader bundleLoader) {
                BridgelessDevSupportManager.this.mReactHost.loadBundle(bundleLoader).onSuccess(new Continuation<Boolean, Void>(){

                    @Override
                    public Void then(Task<Boolean> task) {
                        if (task.getResult().equals(Boolean.TRUE)) {
                            String bundleURL = BridgelessDevSupportManager.this.getDevServerHelper().getDevServerSplitBundleURL(bundlePath);
                            ReactContext reactContext = BridgelessDevSupportManager.this.mReactHost.getCurrentReactContext();
                            if (reactContext != null) {
                                reactContext.getJSModule(HMRClient.class).registerBundle(bundleURL);
                            }
                            callback.onSuccess();
                        }
                        return null;
                    }
                });
            }

            @Override
            public void onError(String url, Throwable cause) {
                callback.onError(url, cause);
            }
        });
    }

    @Override
    public void handleReloadJS() {
        UiThreadUtil.assertOnUiThread();
        this.hideRedboxDialog();
        this.mReactHost.reload("BridgelessDevSupportManager.handleReloadJS()");
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: load from Server");
        String bundleURL = this.getDevServerHelper().getDevServerBundleURL((String)Assertions.assertNotNull((Object)this.getJSAppBundleName()));
        this.reloadJSFromServer(bundleURL);
    }

    private static ReactInstanceDevHelper createInstanceDevHelper(final ReactHostImpl reactHost) {
        return new ReactInstanceDevHelper(){

            @Override
            public void onReloadWithJSDebugger(JavaJSExecutor.Factory proxyExecutorFactory) {
            }

            @Override
            public void onJSBundleLoadedFromServer() {
            }

            @Override
            public void toggleElementInspector() {
                ReactContext reactContext = reactHost.getCurrentReactContext();
                if (reactContext != null) {
                    reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("toggleElementInspector", null);
                }
            }

            @Override
            @Nullable
            public Activity getCurrentActivity() {
                return reactHost.getLastUsedActivity();
            }

            @Override
            public JavaScriptExecutorFactory getJavaScriptExecutorFactory() {
                throw new IllegalStateException("Not implemented for bridgeless mode");
            }

            @Override
            @Nullable
            public View createRootView(String appKey) {
                Activity currentActivity = this.getCurrentActivity();
                if (currentActivity != null && !reactHost.isSurfaceWithModuleNameAttached(appKey)) {
                    ReactSurfaceImpl reactSurface = ReactSurfaceImpl.createWithView((Context)currentActivity, appKey, new Bundle());
                    reactSurface.attach(reactHost);
                    reactSurface.start();
                    return reactSurface.getView();
                }
                return null;
            }

            @Override
            public void destroyRootView(View rootView) {
            }
        };
    }
}

