/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import com.facebook.react.modules.network.CountingOutputStream;
import com.facebook.react.modules.network.ProgressListener;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

class ProgressRequestBody
extends RequestBody {
    private final RequestBody mRequestBody;
    private final ProgressListener mProgressListener;
    private long mContentLength = 0L;

    public ProgressRequestBody(RequestBody requestBody, ProgressListener progressListener) {
        this.mRequestBody = requestBody;
        this.mProgressListener = progressListener;
    }

    public MediaType contentType() {
        return this.mRequestBody.contentType();
    }

    public long contentLength() throws IOException {
        if (this.mContentLength == 0L) {
            this.mContentLength = this.mRequestBody.contentLength();
        }
        return this.mContentLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        BufferedSink sinkWrapper = Okio.buffer((Sink)this.outputStreamSink(sink));
        this.contentLength();
        this.mRequestBody.writeTo(sinkWrapper);
        sinkWrapper.flush();
    }

    private Sink outputStreamSink(BufferedSink sink) {
        return Okio.sink((OutputStream)new CountingOutputStream(sink.outputStream()){

            @Override
            public void write(byte[] data, int offset, int byteCount) throws IOException {
                super.write(data, offset, byteCount);
                this.sendProgressUpdate();
            }

            @Override
            public void write(int data) throws IOException {
                super.write(data);
                this.sendProgressUpdate();
            }

            private void sendProgressUpdate() throws IOException {
                long bytesWritten = this.getCount();
                long contentLength = ProgressRequestBody.this.contentLength();
                ProgressRequestBody.this.mProgressListener.onProgress(bytesWritten, contentLength, bytesWritten == contentLength);
            }
        });
    }
}

