/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.net.Uri;
import android.os.SystemClock;
import com.facebook.imagepipeline.backends.okhttp3.OkHttpNetworkFetcher;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.modules.fresco.ReactNetworkImageRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;

class ReactOkHttpNetworkFetcher
extends OkHttpNetworkFetcher {
    private static final String TAG = "ReactOkHttpNetworkFetcher";
    private final OkHttpClient mOkHttpClient;
    private final Executor mCancellationExecutor;

    public ReactOkHttpNetworkFetcher(OkHttpClient okHttpClient) {
        super(okHttpClient);
        this.mOkHttpClient = okHttpClient;
        this.mCancellationExecutor = okHttpClient.dispatcher().executorService();
    }

    private Map<String, String> getHeaders(ReadableMap readableMap) {
        if (readableMap == null) {
            return null;
        }
        ReadableMapKeySetIterator iterator2 = readableMap.keySetIterator();
        HashMap<String, String> map = new HashMap<String, String>();
        while (iterator2.hasNextKey()) {
            String key = iterator2.nextKey();
            String value = readableMap.getString(key);
            map.put(key, value);
        }
        return map;
    }

    public void fetch(OkHttpNetworkFetcher.OkHttpNetworkFetchState fetchState, NetworkFetcher.Callback callback) {
        fetchState.submitTime = SystemClock.elapsedRealtime();
        Uri uri = fetchState.getUri();
        Map<Object, Object> requestHeaders = null;
        if (fetchState.getContext().getImageRequest() instanceof ReactNetworkImageRequest) {
            ReactNetworkImageRequest networkImageRequest = (ReactNetworkImageRequest)fetchState.getContext().getImageRequest();
            requestHeaders = this.getHeaders(networkImageRequest.getHeaders());
        }
        if (requestHeaders == null) {
            requestHeaders = Collections.emptyMap();
        }
        Request request = new Request.Builder().cacheControl(new CacheControl.Builder().noStore().build()).url(uri.toString()).headers(Headers.of(requestHeaders)).get().build();
        this.fetchWithRequest(fetchState, callback, request);
    }
}

