/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.view.Choreographer;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.internal.ChoreographerProvider;
import java.util.ArrayDeque;

public final class ReactChoreographer {
    private static ReactChoreographer sInstance;
    @Nullable
    private ChoreographerProvider.Choreographer mChoreographer;
    private final ArrayDeque<Choreographer.FrameCallback>[] mCallbackQueues;
    private final Choreographer.FrameCallback mFrameCallback = new Choreographer.FrameCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            ArrayDeque<Choreographer.FrameCallback>[] arrayDequeArray = ReactChoreographer.this.mCallbackQueues;
            synchronized (ReactChoreographer.this.mCallbackQueues) {
                ReactChoreographer.this.mHasPostedCallback = false;
                for (int i = 0; i < ReactChoreographer.this.mCallbackQueues.length; ++i) {
                    ArrayDeque<Choreographer.FrameCallback> callbackQueue = ReactChoreographer.this.mCallbackQueues[i];
                    int initialLength = callbackQueue.size();
                    for (int callback = 0; callback < initialLength; ++callback) {
                        Choreographer.FrameCallback frameCallback = callbackQueue.pollFirst();
                        if (frameCallback != null) {
                            frameCallback.doFrame(frameTimeNanos);
                            --ReactChoreographer.this.mTotalCallbacks;
                            continue;
                        }
                        FLog.e((String)"ReactNative", (String)"Tried to execute non-existent frame callback");
                    }
                }
                ReactChoreographer.this.maybeRemoveFrameCallback();
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }
    };
    private int mTotalCallbacks = 0;
    private boolean mHasPostedCallback = false;

    public static void initialize(ChoreographerProvider choreographerProvider) {
        if (sInstance == null) {
            sInstance = new ReactChoreographer(choreographerProvider);
        }
    }

    public static ReactChoreographer getInstance() {
        Assertions.assertNotNull((Object)sInstance, (String)"ReactChoreographer needs to be initialized.");
        return sInstance;
    }

    private ReactChoreographer(ChoreographerProvider choreographerProvider) {
        this.mCallbackQueues = new ArrayDeque[CallbackType.values().length];
        for (int i = 0; i < this.mCallbackQueues.length; ++i) {
            this.mCallbackQueues[i] = new ArrayDeque();
        }
        UiThreadUtil.runOnUiThread(() -> {
            this.mChoreographer = choreographerProvider.getChoreographer();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFrameCallback(CallbackType type, Choreographer.FrameCallback frameCallback) {
        ArrayDeque<Choreographer.FrameCallback>[] arrayDequeArray = this.mCallbackQueues;
        synchronized (this.mCallbackQueues) {
            this.mCallbackQueues[type.getOrder()].addLast(frameCallback);
            ++this.mTotalCallbacks;
            Assertions.assertCondition((this.mTotalCallbacks > 0 ? 1 : 0) != 0);
            if (!this.mHasPostedCallback) {
                if (this.mChoreographer == null) {
                    UiThreadUtil.runOnUiThread(() -> {
                        ArrayDeque<Choreographer.FrameCallback>[] arrayDequeArray = this.mCallbackQueues;
                        synchronized (this.mCallbackQueues) {
                            this.postFrameCallbackOnChoreographer();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    });
                } else {
                    this.postFrameCallbackOnChoreographer();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void postFrameCallbackOnChoreographer() {
        this.mChoreographer.postFrameCallback(this.mFrameCallback);
        this.mHasPostedCallback = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameCallback(CallbackType type, Choreographer.FrameCallback frameCallback) {
        ArrayDeque<Choreographer.FrameCallback>[] arrayDequeArray = this.mCallbackQueues;
        synchronized (this.mCallbackQueues) {
            if (this.mCallbackQueues[type.getOrder()].removeFirstOccurrence(frameCallback)) {
                --this.mTotalCallbacks;
                this.maybeRemoveFrameCallback();
            } else {
                FLog.e((String)"ReactNative", (String)"Tried to remove non-existent frame callback");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void maybeRemoveFrameCallback() {
        Assertions.assertCondition((this.mTotalCallbacks >= 0 ? 1 : 0) != 0);
        if (this.mTotalCallbacks == 0 && this.mHasPostedCallback) {
            if (this.mChoreographer != null) {
                this.mChoreographer.removeFrameCallback(this.mFrameCallback);
            }
            this.mHasPostedCallback = false;
        }
    }

    public static enum CallbackType {
        PERF_MARKERS(0),
        DISPATCH_UI(1),
        NATIVE_ANIMATED_MODULE(2),
        TIMERS_EVENTS(3),
        IDLE_EVENT(4);

        private final int mOrder;

        private CallbackType(int order) {
            this.mOrder = order;
        }

        int getOrder() {
            return this.mOrder;
        }
    }
}

