/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeHeadlessJsTaskSupportSpec;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="HeadlessJsTaskSupport")
public class HeadlessJsTaskSupportModule
extends NativeHeadlessJsTaskSupportSpec {
    public HeadlessJsTaskSupportModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public void notifyTaskRetry(double taskIdDouble, Promise promise) {
        int taskId = (int)taskIdDouble;
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        if (headlessJsTaskContext.isTaskRunning(taskId)) {
            boolean retryPosted = headlessJsTaskContext.retryTask(taskId);
            promise.resolve(retryPosted);
        } else {
            FLog.w(HeadlessJsTaskSupportModule.class, (String)"Tried to retry non-active task with id %d. Did it time out?", (Object[])new Object[]{taskId});
            promise.resolve(false);
        }
    }

    @Override
    public void notifyTaskFinished(double taskIdDouble) {
        int taskId = (int)taskIdDouble;
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        if (headlessJsTaskContext.isTaskRunning(taskId)) {
            headlessJsTaskContext.finishTask(taskId);
        } else {
            FLog.w(HeadlessJsTaskSupportModule.class, (String)"Tried to finish non-active task with id %d. Did it time out?", (Object[])new Object[]{taskId});
        }
    }
}

